/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.model.AppRunnerException;
import software.amazon.awssdk.services.apprunner.model.AppRunnerRequest;
import software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainRequest;
import software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse;
import software.amazon.awssdk.services.apprunner.model.CreateAutoScalingConfigurationRequest;
import software.amazon.awssdk.services.apprunner.model.CreateAutoScalingConfigurationResponse;
import software.amazon.awssdk.services.apprunner.model.CreateConnectionRequest;
import software.amazon.awssdk.services.apprunner.model.CreateConnectionResponse;
import software.amazon.awssdk.services.apprunner.model.CreateObservabilityConfigurationRequest;
import software.amazon.awssdk.services.apprunner.model.CreateObservabilityConfigurationResponse;
import software.amazon.awssdk.services.apprunner.model.CreateServiceRequest;
import software.amazon.awssdk.services.apprunner.model.CreateServiceResponse;
import software.amazon.awssdk.services.apprunner.model.CreateVpcConnectorRequest;
import software.amazon.awssdk.services.apprunner.model.CreateVpcConnectorResponse;
import software.amazon.awssdk.services.apprunner.model.DeleteAutoScalingConfigurationRequest;
import software.amazon.awssdk.services.apprunner.model.DeleteAutoScalingConfigurationResponse;
import software.amazon.awssdk.services.apprunner.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.apprunner.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.apprunner.model.DeleteObservabilityConfigurationRequest;
import software.amazon.awssdk.services.apprunner.model.DeleteObservabilityConfigurationResponse;
import software.amazon.awssdk.services.apprunner.model.DeleteServiceRequest;
import software.amazon.awssdk.services.apprunner.model.DeleteServiceResponse;
import software.amazon.awssdk.services.apprunner.model.DeleteVpcConnectorRequest;
import software.amazon.awssdk.services.apprunner.model.DeleteVpcConnectorResponse;
import software.amazon.awssdk.services.apprunner.model.DescribeAutoScalingConfigurationRequest;
import software.amazon.awssdk.services.apprunner.model.DescribeAutoScalingConfigurationResponse;
import software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest;
import software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsResponse;
import software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationRequest;
import software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationResponse;
import software.amazon.awssdk.services.apprunner.model.DescribeServiceRequest;
import software.amazon.awssdk.services.apprunner.model.DescribeServiceResponse;
import software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorRequest;
import software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorResponse;
import software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainRequest;
import software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainResponse;
import software.amazon.awssdk.services.apprunner.model.InternalServiceErrorException;
import software.amazon.awssdk.services.apprunner.model.InvalidRequestException;
import software.amazon.awssdk.services.apprunner.model.InvalidStateException;
import software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest;
import software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsResponse;
import software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest;
import software.amazon.awssdk.services.apprunner.model.ListConnectionsResponse;
import software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest;
import software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsResponse;
import software.amazon.awssdk.services.apprunner.model.ListOperationsRequest;
import software.amazon.awssdk.services.apprunner.model.ListOperationsResponse;
import software.amazon.awssdk.services.apprunner.model.ListServicesRequest;
import software.amazon.awssdk.services.apprunner.model.ListServicesResponse;
import software.amazon.awssdk.services.apprunner.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.apprunner.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsRequest;
import software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsResponse;
import software.amazon.awssdk.services.apprunner.model.PauseServiceRequest;
import software.amazon.awssdk.services.apprunner.model.PauseServiceResponse;
import software.amazon.awssdk.services.apprunner.model.ResourceNotFoundException;
import software.amazon.awssdk.services.apprunner.model.ResumeServiceRequest;
import software.amazon.awssdk.services.apprunner.model.ResumeServiceResponse;
import software.amazon.awssdk.services.apprunner.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.apprunner.model.StartDeploymentRequest;
import software.amazon.awssdk.services.apprunner.model.StartDeploymentResponse;
import software.amazon.awssdk.services.apprunner.model.TagResourceRequest;
import software.amazon.awssdk.services.apprunner.model.TagResourceResponse;
import software.amazon.awssdk.services.apprunner.model.UntagResourceRequest;
import software.amazon.awssdk.services.apprunner.model.UntagResourceResponse;
import software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest;
import software.amazon.awssdk.services.apprunner.model.UpdateServiceResponse;
import software.amazon.awssdk.services.apprunner.paginators.DescribeCustomDomainsIterable;
import software.amazon.awssdk.services.apprunner.paginators.ListAutoScalingConfigurationsIterable;
import software.amazon.awssdk.services.apprunner.paginators.ListConnectionsIterable;
import software.amazon.awssdk.services.apprunner.paginators.ListObservabilityConfigurationsIterable;
import software.amazon.awssdk.services.apprunner.paginators.ListOperationsIterable;
import software.amazon.awssdk.services.apprunner.paginators.ListServicesIterable;
import software.amazon.awssdk.services.apprunner.paginators.ListVpcConnectorsIterable;
import software.amazon.awssdk.services.apprunner.transform.AssociateCustomDomainRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.CreateAutoScalingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.CreateObservabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.CreateServiceRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.CreateVpcConnectorRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DeleteAutoScalingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DeleteObservabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DeleteServiceRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DeleteVpcConnectorRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DescribeAutoScalingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DescribeCustomDomainsRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DescribeObservabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DescribeServiceRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DescribeVpcConnectorRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.DisassociateCustomDomainRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.ListAutoScalingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.ListConnectionsRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.ListObservabilityConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.ListOperationsRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.ListVpcConnectorsRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.PauseServiceRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.ResumeServiceRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.StartDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.apprunner.transform.UpdateServiceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAppRunnerClient
implements AppRunnerClient {
    private static final Logger log = Logger.loggerFor(DefaultAppRunnerClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppRunnerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "apprunner";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateCustomDomainResponse associateCustomDomain(AssociateCustomDomainRequest associateCustomDomainRequest) throws InvalidRequestException, InternalServiceErrorException, InvalidStateException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateCustomDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, associateCustomDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateCustomDomain");
            AssociateCustomDomainResponse associateCustomDomainResponse = (AssociateCustomDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateCustomDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateCustomDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateCustomDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateCustomDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$associateCustomDomain$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAutoScalingConfigurationResponse createAutoScalingConfiguration(CreateAutoScalingConfigurationRequest createAutoScalingConfigurationRequest) throws InvalidRequestException, InternalServiceErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAutoScalingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, createAutoScalingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAutoScalingConfiguration");
            CreateAutoScalingConfigurationResponse createAutoScalingConfigurationResponse = (CreateAutoScalingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAutoScalingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAutoScalingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAutoScalingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAutoScalingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$createAutoScalingConfiguration$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest) throws InvalidRequestException, InternalServiceErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, createConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnection");
            CreateConnectionResponse createConnectionResponse = (CreateConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$createConnection$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateObservabilityConfigurationResponse createObservabilityConfiguration(CreateObservabilityConfigurationRequest createObservabilityConfigurationRequest) throws InvalidRequestException, InternalServiceErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateObservabilityConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, createObservabilityConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateObservabilityConfiguration");
            CreateObservabilityConfigurationResponse createObservabilityConfigurationResponse = (CreateObservabilityConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateObservabilityConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createObservabilityConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateObservabilityConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createObservabilityConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$createObservabilityConfiguration$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws InvalidRequestException, InternalServiceErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, createServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateService");
            CreateServiceResponse createServiceResponse = (CreateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$createService$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVpcConnectorResponse createVpcConnector(CreateVpcConnectorRequest createVpcConnectorRequest) throws InvalidRequestException, InternalServiceErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVpcConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, createVpcConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVpcConnector");
            CreateVpcConnectorResponse createVpcConnectorResponse = (CreateVpcConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVpcConnector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVpcConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVpcConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVpcConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$createVpcConnector$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAutoScalingConfigurationResponse deleteAutoScalingConfiguration(DeleteAutoScalingConfigurationRequest deleteAutoScalingConfigurationRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAutoScalingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, deleteAutoScalingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAutoScalingConfiguration");
            DeleteAutoScalingConfigurationResponse deleteAutoScalingConfigurationResponse = (DeleteAutoScalingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutoScalingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAutoScalingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAutoScalingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAutoScalingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$deleteAutoScalingConfiguration$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, deleteConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnection");
            DeleteConnectionResponse deleteConnectionResponse = (DeleteConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$deleteConnection$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteObservabilityConfigurationResponse deleteObservabilityConfiguration(DeleteObservabilityConfigurationRequest deleteObservabilityConfigurationRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteObservabilityConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, deleteObservabilityConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteObservabilityConfiguration");
            DeleteObservabilityConfigurationResponse deleteObservabilityConfigurationResponse = (DeleteObservabilityConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObservabilityConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteObservabilityConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteObservabilityConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteObservabilityConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$deleteObservabilityConfiguration$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws InvalidRequestException, ResourceNotFoundException, InvalidStateException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, deleteServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteService");
            DeleteServiceResponse deleteServiceResponse = (DeleteServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$deleteService$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVpcConnectorResponse deleteVpcConnector(DeleteVpcConnectorRequest deleteVpcConnectorRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVpcConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, deleteVpcConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVpcConnector");
            DeleteVpcConnectorResponse deleteVpcConnectorResponse = (DeleteVpcConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVpcConnector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVpcConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVpcConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVpcConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$deleteVpcConnector$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingConfigurationResponse describeAutoScalingConfiguration(DescribeAutoScalingConfigurationRequest describeAutoScalingConfigurationRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAutoScalingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, describeAutoScalingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAutoScalingConfiguration");
            DescribeAutoScalingConfigurationResponse describeAutoScalingConfigurationResponse = (DescribeAutoScalingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAutoScalingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAutoScalingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$describeAutoScalingConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCustomDomainsResponse describeCustomDomains(DescribeCustomDomainsRequest describeCustomDomainsRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomDomainsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, describeCustomDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomDomains");
            DescribeCustomDomainsResponse describeCustomDomainsResponse = (DescribeCustomDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomDomains").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCustomDomainsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCustomDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCustomDomainsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$describeCustomDomains$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeCustomDomainsIterable describeCustomDomainsPaginator(DescribeCustomDomainsRequest describeCustomDomainsRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        return new DescribeCustomDomainsIterable(this, this.applyPaginatorUserAgent(describeCustomDomainsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeObservabilityConfigurationResponse describeObservabilityConfiguration(DescribeObservabilityConfigurationRequest describeObservabilityConfigurationRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeObservabilityConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, describeObservabilityConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeObservabilityConfiguration");
            DescribeObservabilityConfigurationResponse describeObservabilityConfigurationResponse = (DescribeObservabilityConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeObservabilityConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeObservabilityConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeObservabilityConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeObservabilityConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$describeObservabilityConfiguration$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceResponse describeService(DescribeServiceRequest describeServiceRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, describeServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeService");
            DescribeServiceResponse describeServiceResponse = (DescribeServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$describeService$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVpcConnectorResponse describeVpcConnector(DescribeVpcConnectorRequest describeVpcConnectorRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVpcConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, describeVpcConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVpcConnector");
            DescribeVpcConnectorResponse describeVpcConnectorResponse = (DescribeVpcConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVpcConnector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVpcConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVpcConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVpcConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$describeVpcConnector$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateCustomDomainResponse disassociateCustomDomain(DisassociateCustomDomainRequest disassociateCustomDomainRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, InvalidStateException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateCustomDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, disassociateCustomDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateCustomDomain");
            DisassociateCustomDomainResponse disassociateCustomDomainResponse = (DisassociateCustomDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateCustomDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateCustomDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateCustomDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateCustomDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$disassociateCustomDomain$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAutoScalingConfigurationsResponse listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest listAutoScalingConfigurationsRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAutoScalingConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, listAutoScalingConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAutoScalingConfigurations");
            ListAutoScalingConfigurationsResponse listAutoScalingConfigurationsResponse = (ListAutoScalingConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAutoScalingConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAutoScalingConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAutoScalingConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAutoScalingConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$listAutoScalingConfigurations$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAutoScalingConfigurationsIterable listAutoScalingConfigurationsPaginator(ListAutoScalingConfigurationsRequest listAutoScalingConfigurationsRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        return new ListAutoScalingConfigurationsIterable(this, this.applyPaginatorUserAgent(listAutoScalingConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest listConnectionsRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, listConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnections");
            ListConnectionsResponse listConnectionsResponse = (ListConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnections").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$listConnections$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListConnectionsIterable listConnectionsPaginator(ListConnectionsRequest listConnectionsRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        return new ListConnectionsIterable(this, this.applyPaginatorUserAgent(listConnectionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObservabilityConfigurationsResponse listObservabilityConfigurations(ListObservabilityConfigurationsRequest listObservabilityConfigurationsRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObservabilityConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, listObservabilityConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObservabilityConfigurations");
            ListObservabilityConfigurationsResponse listObservabilityConfigurationsResponse = (ListObservabilityConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObservabilityConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listObservabilityConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListObservabilityConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listObservabilityConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$listObservabilityConfigurations$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListObservabilityConfigurationsIterable listObservabilityConfigurationsPaginator(ListObservabilityConfigurationsRequest listObservabilityConfigurationsRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        return new ListObservabilityConfigurationsIterable(this, this.applyPaginatorUserAgent(listObservabilityConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOperationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, listOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOperations");
            ListOperationsResponse listOperationsResponse = (ListOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOperations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOperationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOperationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$listOperations$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListOperationsIterable listOperationsPaginator(ListOperationsRequest listOperationsRequest) throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppRunnerException {
        return new ListOperationsIterable(this, this.applyPaginatorUserAgent(listOperationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            ListServicesResponse listServicesResponse = (ListServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$listServices$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServicesIterable listServicesPaginator(ListServicesRequest listServicesRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        return new ListServicesIterable(this, this.applyPaginatorUserAgent(listServicesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalServiceErrorException, InvalidRequestException, InvalidStateException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$listTagsForResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVpcConnectorsResponse listVpcConnectors(ListVpcConnectorsRequest listVpcConnectorsRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVpcConnectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, listVpcConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVpcConnectors");
            ListVpcConnectorsResponse listVpcConnectorsResponse = (ListVpcConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVpcConnectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVpcConnectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVpcConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVpcConnectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$listVpcConnectors$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVpcConnectorsIterable listVpcConnectorsPaginator(ListVpcConnectorsRequest listVpcConnectorsRequest) throws InvalidRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        return new ListVpcConnectorsIterable(this, this.applyPaginatorUserAgent(listVpcConnectorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PauseServiceResponse pauseService(PauseServiceRequest pauseServiceRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServiceErrorException, InvalidStateException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PauseServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, pauseServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PauseService");
            PauseServiceResponse pauseServiceResponse = (PauseServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PauseService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)pauseServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PauseServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return pauseServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$pauseService$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumeServiceResponse resumeService(ResumeServiceRequest resumeServiceRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServiceErrorException, InvalidStateException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResumeServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, resumeServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeService");
            ResumeServiceResponse resumeServiceResponse = (ResumeServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resumeServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResumeServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resumeServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$resumeService$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDeploymentResponse startDeployment(StartDeploymentRequest startDeploymentRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, startDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDeployment");
            StartDeploymentResponse startDeploymentResponse = (StartDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$startDeployment$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InternalServiceErrorException, InvalidRequestException, InvalidStateException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$tagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InternalServiceErrorException, InvalidRequestException, InvalidStateException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$untagResource$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws InvalidRequestException, ResourceNotFoundException, InvalidStateException, InternalServiceErrorException, AwsServiceException, SdkClientException, AppRunnerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppRunnerClient.resolveMetricPublishers(this.clientConfiguration, updateServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppRunner");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateService");
            UpdateServiceResponse updateServiceResponse = (UpdateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppRunnerClient.lambda$updateService$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppRunnerException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateException").exceptionBuilderSupplier(InvalidStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").exceptionBuilderSupplier(InternalServiceErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends AppRunnerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.281").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AppRunnerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateService$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDeployment$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resumeService$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pauseService$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVpcConnectors$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOperations$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObservabilityConfigurations$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnections$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAutoScalingConfigurations$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateCustomDomain$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVpcConnector$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeService$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeObservabilityConfiguration$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomDomains$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAutoScalingConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVpcConnector$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteService$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteObservabilityConfiguration$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnection$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAutoScalingConfiguration$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVpcConnector$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createService$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createObservabilityConfiguration$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnection$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAutoScalingConfiguration$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateCustomDomain$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

