/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HttpMethod {
    CONNECT("connect"),
    DELETE("delete"),
    GET("get"),
    HEAD("head"),
    OPTIONS("options"),
    PATCH("patch"),
    POST("post"),
    PUT("put"),
    TRACE("trace"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HttpMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HttpMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HttpMethod.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HttpMethod> knownValues() {
        return Stream.of(HttpMethod.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

