/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoutesRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, ListRoutesRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListRoutesRequest.getter(ListRoutesRequest::limit)).setter(ListRoutesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRoutesRequest.getter(ListRoutesRequest::meshName)).setter(ListRoutesRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRoutesRequest.getter(ListRoutesRequest::nextToken)).setter(ListRoutesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRoutesRequest.getter(ListRoutesRequest::virtualRouterName)).setter(ListRoutesRequest.setter(Builder::virtualRouterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualRouterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, MESH_NAME_FIELD, NEXT_TOKEN_FIELD, VIRTUAL_ROUTER_NAME_FIELD));
    private final Integer limit;
    private final String meshName;
    private final String nextToken;
    private final String virtualRouterName;

    private ListRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.meshName = builder.meshName;
        this.nextToken = builder.nextToken;
        this.virtualRouterName = builder.virtualRouterName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String meshName() {
        return this.meshName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String virtualRouterName() {
        return this.virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualRouterName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutesRequest)) {
            return false;
        }
        ListRoutesRequest other = (ListRoutesRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.virtualRouterName(), other.virtualRouterName());
    }

    public String toString() {
        return ToString.builder((String)"ListRoutesRequest").add("Limit", (Object)this.limit()).add("MeshName", (Object)this.meshName()).add("NextToken", (Object)this.nextToken()).add("VirtualRouterName", (Object)this.virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "virtualRouterName": {
                return Optional.ofNullable(clazz.cast(this.virtualRouterName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutesRequest, T> g) {
        return obj -> g.apply((ListRoutesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private Integer limit;
        private String meshName;
        private String nextToken;
        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutesRequest model) {
            super(model);
            this.limit(model.limit);
            this.meshName(model.meshName);
            this.nextToken(model.nextToken);
            this.virtualRouterName(model.virtualRouterName);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRoutesRequest build() {
            return new ListRoutesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoutesRequest> {
        public Builder limit(Integer var1);

        public Builder meshName(String var1);

        public Builder nextToken(String var1);

        public Builder virtualRouterName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

