/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualServiceRef
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualServiceRef> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualServiceRef.getter(VirtualServiceRef::arn)).setter(VirtualServiceRef.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualServiceRef.getter(VirtualServiceRef::meshName)).setter(VirtualServiceRef.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<String> VIRTUAL_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualServiceRef.getter(VirtualServiceRef::virtualServiceName)).setter(VirtualServiceRef.setter(Builder::virtualServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualServiceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MESH_NAME_FIELD, VIRTUAL_SERVICE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String meshName;
    private final String virtualServiceName;

    private VirtualServiceRef(BuilderImpl builder) {
        this.arn = builder.arn;
        this.meshName = builder.meshName;
        this.virtualServiceName = builder.virtualServiceName;
    }

    public String arn() {
        return this.arn;
    }

    public String meshName() {
        return this.meshName;
    }

    public String virtualServiceName() {
        return this.virtualServiceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualServiceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualServiceRef)) {
            return false;
        }
        VirtualServiceRef other = (VirtualServiceRef)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.virtualServiceName(), other.virtualServiceName());
    }

    public String toString() {
        return ToString.builder((String)"VirtualServiceRef").add("Arn", (Object)this.arn()).add("MeshName", (Object)this.meshName()).add("VirtualServiceName", (Object)this.virtualServiceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "virtualServiceName": {
                return Optional.ofNullable(clazz.cast(this.virtualServiceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualServiceRef, T> g) {
        return obj -> g.apply((VirtualServiceRef)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String meshName;
        private String virtualServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualServiceRef model) {
            this.arn(model.arn);
            this.meshName(model.meshName);
            this.virtualServiceName(model.virtualServiceName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getVirtualServiceName() {
            return this.virtualServiceName;
        }

        @Override
        public final Builder virtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
            return this;
        }

        public final void setVirtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
        }

        public VirtualServiceRef build() {
            return new VirtualServiceRef(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualServiceRef> {
        public Builder arn(String var1);

        public Builder meshName(String var1);

        public Builder virtualServiceName(String var1);
    }
}

