/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeServiceProvider;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterServiceProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualServiceProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualServiceProvider> {
    private static final SdkField<VirtualNodeServiceProvider> VIRTUAL_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("virtualNode").getter(VirtualServiceProvider.getter(VirtualServiceProvider::virtualNode)).setter(VirtualServiceProvider.setter(Builder::virtualNode)).constructor(VirtualNodeServiceProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNode").build()}).build();
    private static final SdkField<VirtualRouterServiceProvider> VIRTUAL_ROUTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("virtualRouter").getter(VirtualServiceProvider.getter(VirtualServiceProvider::virtualRouter)).setter(VirtualServiceProvider.setter(Builder::virtualRouter)).constructor(VirtualRouterServiceProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_NODE_FIELD, VIRTUAL_ROUTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VirtualServiceProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VirtualNodeServiceProvider virtualNode;
    private final VirtualRouterServiceProvider virtualRouter;
    private final Type type;

    private VirtualServiceProvider(BuilderImpl builder) {
        this.virtualNode = builder.virtualNode;
        this.virtualRouter = builder.virtualRouter;
        this.type = builder.type;
    }

    public final VirtualNodeServiceProvider virtualNode() {
        return this.virtualNode;
    }

    public final VirtualRouterServiceProvider virtualRouter() {
        return this.virtualRouter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualRouter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualServiceProvider)) {
            return false;
        }
        VirtualServiceProvider other = (VirtualServiceProvider)obj;
        return Objects.equals(this.virtualNode(), other.virtualNode()) && Objects.equals(this.virtualRouter(), other.virtualRouter());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualServiceProvider").add("VirtualNode", (Object)this.virtualNode()).add("VirtualRouter", (Object)this.virtualRouter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualNode": {
                return Optional.ofNullable(clazz.cast(this.virtualNode()));
            }
            case "virtualRouter": {
                return Optional.ofNullable(clazz.cast(this.virtualRouter()));
            }
        }
        return Optional.empty();
    }

    public static VirtualServiceProvider fromVirtualNode(VirtualNodeServiceProvider virtualNode) {
        return (VirtualServiceProvider)VirtualServiceProvider.builder().virtualNode(virtualNode).build();
    }

    public static VirtualServiceProvider fromVirtualNode(Consumer<VirtualNodeServiceProvider.Builder> virtualNode) {
        VirtualNodeServiceProvider.Builder builder = VirtualNodeServiceProvider.builder();
        virtualNode.accept(builder);
        return VirtualServiceProvider.fromVirtualNode((VirtualNodeServiceProvider)builder.build());
    }

    public static VirtualServiceProvider fromVirtualRouter(VirtualRouterServiceProvider virtualRouter) {
        return (VirtualServiceProvider)VirtualServiceProvider.builder().virtualRouter(virtualRouter).build();
    }

    public static VirtualServiceProvider fromVirtualRouter(Consumer<VirtualRouterServiceProvider.Builder> virtualRouter) {
        VirtualRouterServiceProvider.Builder builder = VirtualRouterServiceProvider.builder();
        virtualRouter.accept(builder);
        return VirtualServiceProvider.fromVirtualRouter((VirtualRouterServiceProvider)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("virtualNode", VIRTUAL_NODE_FIELD);
        map.put("virtualRouter", VIRTUAL_ROUTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VirtualServiceProvider, T> g) {
        return obj -> g.apply((VirtualServiceProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        VIRTUAL_NODE,
        VIRTUAL_ROUTER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private VirtualNodeServiceProvider virtualNode;
        private VirtualRouterServiceProvider virtualRouter;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualServiceProvider model) {
            this.virtualNode(model.virtualNode);
            this.virtualRouter(model.virtualRouter);
        }

        public final VirtualNodeServiceProvider.Builder getVirtualNode() {
            return this.virtualNode != null ? this.virtualNode.toBuilder() : null;
        }

        public final void setVirtualNode(VirtualNodeServiceProvider.BuilderImpl virtualNode) {
            VirtualNodeServiceProvider oldValue = this.virtualNode;
            this.virtualNode = virtualNode != null ? virtualNode.build() : null;
            this.handleUnionValueChange(Type.VIRTUAL_NODE, oldValue, this.virtualNode);
        }

        @Override
        public final Builder virtualNode(VirtualNodeServiceProvider virtualNode) {
            VirtualNodeServiceProvider oldValue = this.virtualNode;
            this.virtualNode = virtualNode;
            this.handleUnionValueChange(Type.VIRTUAL_NODE, oldValue, this.virtualNode);
            return this;
        }

        public final VirtualRouterServiceProvider.Builder getVirtualRouter() {
            return this.virtualRouter != null ? this.virtualRouter.toBuilder() : null;
        }

        public final void setVirtualRouter(VirtualRouterServiceProvider.BuilderImpl virtualRouter) {
            VirtualRouterServiceProvider oldValue = this.virtualRouter;
            this.virtualRouter = virtualRouter != null ? virtualRouter.build() : null;
            this.handleUnionValueChange(Type.VIRTUAL_ROUTER, oldValue, this.virtualRouter);
        }

        @Override
        public final Builder virtualRouter(VirtualRouterServiceProvider virtualRouter) {
            VirtualRouterServiceProvider oldValue = this.virtualRouter;
            this.virtualRouter = virtualRouter;
            this.handleUnionValueChange(Type.VIRTUAL_ROUTER, oldValue, this.virtualRouter);
            return this;
        }

        public VirtualServiceProvider build() {
            return new VirtualServiceProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualServiceProvider> {
        public Builder virtualNode(VirtualNodeServiceProvider var1);

        default public Builder virtualNode(Consumer<VirtualNodeServiceProvider.Builder> virtualNode) {
            return this.virtualNode((VirtualNodeServiceProvider)((VirtualNodeServiceProvider.Builder)VirtualNodeServiceProvider.builder().applyMutation(virtualNode)).build());
        }

        public Builder virtualRouter(VirtualRouterServiceProvider var1);

        default public Builder virtualRouter(Consumer<VirtualRouterServiceProvider.Builder> virtualRouter) {
            return this.virtualRouter((VirtualRouterServiceProvider)((VirtualRouterServiceProvider.Builder)VirtualRouterServiceProvider.builder().applyMutation(virtualRouter)).build());
        }
    }
}

