/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the Transport Layer Security (TLS) properties for a listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListenerTls implements SdkPojo, Serializable, ToCopyableBuilder<ListenerTls.Builder, ListenerTls> {
    private static final SdkField<ListenerTlsCertificate> CERTIFICATE_FIELD = SdkField
            .<ListenerTlsCertificate> builder(MarshallingType.SDK_POJO).memberName("certificate")
            .getter(getter(ListenerTls::certificate)).setter(setter(Builder::certificate))
            .constructor(ListenerTlsCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(ListenerTls::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<ListenerTlsValidationContext> VALIDATION_FIELD = SdkField
            .<ListenerTlsValidationContext> builder(MarshallingType.SDK_POJO).memberName("validation")
            .getter(getter(ListenerTls::validation)).setter(setter(Builder::validation))
            .constructor(ListenerTlsValidationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, MODE_FIELD,
            VALIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ListenerTlsCertificate certificate;

    private final String mode;

    private final ListenerTlsValidationContext validation;

    private ListenerTls(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.mode = builder.mode;
        this.validation = builder.validation;
    }

    /**
     * <p>
     * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
     * </p>
     * 
     * @return A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
     */
    public final ListenerTlsCertificate certificate() {
        return certificate;
    }

    /**
     * <p>
     * Specify one of the following modes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b/>STRICT – Listener only accepts connections with TLS enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b/>DISABLED – Listener only accepts connections without TLS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ListenerTlsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specify one of the following modes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b/>STRICT – Listener only accepts connections with TLS enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b/>DISABLED – Listener only accepts connections without TLS.
     *         </p>
     *         </li>
     * @see ListenerTlsMode
     */
    public final ListenerTlsMode mode() {
        return ListenerTlsMode.fromValue(mode);
    }

    /**
     * <p>
     * Specify one of the following modes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b/>STRICT – Listener only accepts connections with TLS enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b/>DISABLED – Listener only accepts connections without TLS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ListenerTlsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specify one of the following modes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b/>STRICT – Listener only accepts connections with TLS enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b/>DISABLED – Listener only accepts connections without TLS.
     *         </p>
     *         </li>
     * @see ListenerTlsMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
     * </p>
     * 
     * @return A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
     */
    public final ListenerTlsValidationContext validation() {
        return validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerTls)) {
            return false;
        }
        ListenerTls other = (ListenerTls) obj;
        return Objects.equals(certificate(), other.certificate()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(validation(), other.validation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListenerTls").add("Certificate", certificate()).add("Mode", modeAsString())
                .add("Validation", validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "validation":
            return Optional.ofNullable(clazz.cast(validation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificate", CERTIFICATE_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("validation", VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListenerTls, T> g) {
        return obj -> g.apply((ListenerTls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListenerTls> {
        /**
         * <p>
         * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
         * </p>
         * 
         * @param certificate
         *        A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(ListenerTlsCertificate certificate);

        /**
         * <p>
         * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListenerTlsCertificate.Builder} avoiding
         * the need to create one manually via {@link ListenerTlsCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListenerTlsCertificate.Builder#build()} is called immediately and
         * its result is passed to {@link #certificate(ListenerTlsCertificate)}.
         * 
         * @param certificate
         *        a consumer that will call methods on {@link ListenerTlsCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificate(ListenerTlsCertificate)
         */
        default Builder certificate(Consumer<ListenerTlsCertificate.Builder> certificate) {
            return certificate(ListenerTlsCertificate.builder().applyMutation(certificate).build());
        }

        /**
         * <p>
         * Specify one of the following modes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b/>STRICT – Listener only accepts connections with TLS enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b/>DISABLED – Listener only accepts connections without TLS.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        Specify one of the following modes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b/>STRICT – Listener only accepts connections with TLS enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b/>DISABLED – Listener only accepts connections without TLS.
         *        </p>
         *        </li>
         * @see ListenerTlsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListenerTlsMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Specify one of the following modes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b/>STRICT – Listener only accepts connections with TLS enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b/>DISABLED – Listener only accepts connections without TLS.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        Specify one of the following modes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b/>STRICT – Listener only accepts connections with TLS enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b/>DISABLED – Listener only accepts connections without TLS.
         *        </p>
         *        </li>
         * @see ListenerTlsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListenerTlsMode
         */
        Builder mode(ListenerTlsMode mode);

        /**
         * <p>
         * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
         * </p>
         * 
         * @param validation
         *        A reference to an object that represents a listener's Transport Layer Security (TLS) validation
         *        context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validation(ListenerTlsValidationContext validation);

        /**
         * <p>
         * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListenerTlsValidationContext.Builder}
         * avoiding the need to create one manually via {@link ListenerTlsValidationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListenerTlsValidationContext.Builder#build()} is called
         * immediately and its result is passed to {@link #validation(ListenerTlsValidationContext)}.
         * 
         * @param validation
         *        a consumer that will call methods on {@link ListenerTlsValidationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validation(ListenerTlsValidationContext)
         */
        default Builder validation(Consumer<ListenerTlsValidationContext.Builder> validation) {
            return validation(ListenerTlsValidationContext.builder().applyMutation(validation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ListenerTlsCertificate certificate;

        private String mode;

        private ListenerTlsValidationContext validation;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerTls model) {
            certificate(model.certificate);
            mode(model.mode);
            validation(model.validation);
        }

        public final ListenerTlsCertificate.Builder getCertificate() {
            return certificate != null ? certificate.toBuilder() : null;
        }

        public final void setCertificate(ListenerTlsCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(ListenerTlsCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ListenerTlsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final ListenerTlsValidationContext.Builder getValidation() {
            return validation != null ? validation.toBuilder() : null;
        }

        public final void setValidation(ListenerTlsValidationContext.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public final Builder validation(ListenerTlsValidationContext validation) {
            this.validation = validation;
            return this;
        }

        @Override
        public ListenerTls build() {
            return new ListenerTls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
