/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.AppMeshClientBuilder;
import software.amazon.awssdk.services.appmesh.AppMeshServiceClientConfiguration;
import software.amazon.awssdk.services.appmesh.DefaultAppMeshBaseClientBuilder;
import software.amazon.awssdk.services.appmesh.DefaultAppMeshClient;
import software.amazon.awssdk.services.appmesh.endpoints.AppMeshEndpointProvider;

@SdkInternalApi
final class DefaultAppMeshClientBuilder
extends DefaultAppMeshBaseClientBuilder<AppMeshClientBuilder, AppMeshClient>
implements AppMeshClientBuilder {
    DefaultAppMeshClientBuilder() {
    }

    @Override
    public DefaultAppMeshClientBuilder endpointProvider(AppMeshEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppMeshClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppMeshClientBuilder.validateClientOptions(clientConfiguration);
        AppMeshServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppMeshClient client = new DefaultAppMeshClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppMeshServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppMeshServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

