/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HttpScheme {
    HTTP("http"),
    HTTPS("https"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HttpScheme> VALUE_MAP;
    private final String value;

    private HttpScheme(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HttpScheme fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HttpScheme> knownValues() {
        EnumSet<HttpScheme> knownValues = EnumSet.allOf(HttpScheme.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HttpScheme.class, HttpScheme::toString);
    }
}

