/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.HttpMethod;
import software.amazon.awssdk.services.appmesh.model.HttpPathMatch;
import software.amazon.awssdk.services.appmesh.model.HttpQueryParameter;
import software.amazon.awssdk.services.appmesh.model.HttpQueryParametersCopier;
import software.amazon.awssdk.services.appmesh.model.HttpRouteHeader;
import software.amazon.awssdk.services.appmesh.model.HttpRouteHeadersCopier;
import software.amazon.awssdk.services.appmesh.model.HttpScheme;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpRouteMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpRouteMatch> {
    private static final SdkField<List<HttpRouteHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("headers").getter(HttpRouteMatch.getter(HttpRouteMatch::headers)).setter(HttpRouteMatch.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpRouteHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("method").getter(HttpRouteMatch.getter(HttpRouteMatch::methodAsString)).setter(HttpRouteMatch.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final SdkField<HttpPathMatch> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("path").getter(HttpRouteMatch.getter(HttpRouteMatch::path)).setter(HttpRouteMatch.setter(Builder::path)).constructor(HttpPathMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(HttpRouteMatch.getter(HttpRouteMatch::prefix)).setter(HttpRouteMatch.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final SdkField<List<HttpQueryParameter>> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queryParameters").getter(HttpRouteMatch.getter(HttpRouteMatch::queryParameters)).setter(HttpRouteMatch.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpQueryParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheme").getter(HttpRouteMatch.getter(HttpRouteMatch::schemeAsString)).setter(HttpRouteMatch.setter(Builder::scheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheme").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, METHOD_FIELD, PATH_FIELD, PREFIX_FIELD, QUERY_PARAMETERS_FIELD, SCHEME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<HttpRouteHeader> headers;
    private final String method;
    private final HttpPathMatch path;
    private final String prefix;
    private final List<HttpQueryParameter> queryParameters;
    private final String scheme;

    private HttpRouteMatch(BuilderImpl builder) {
        this.headers = builder.headers;
        this.method = builder.method;
        this.path = builder.path;
        this.prefix = builder.prefix;
        this.queryParameters = builder.queryParameters;
        this.scheme = builder.scheme;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<HttpRouteHeader> headers() {
        return this.headers;
    }

    public final HttpMethod method() {
        return HttpMethod.fromValue(this.method);
    }

    public final String methodAsString() {
        return this.method;
    }

    public final HttpPathMatch path() {
        return this.path;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final boolean hasQueryParameters() {
        return this.queryParameters != null && !(this.queryParameters instanceof SdkAutoConstructList);
    }

    public final List<HttpQueryParameter> queryParameters() {
        return this.queryParameters;
    }

    public final HttpScheme scheme() {
        return HttpScheme.fromValue(this.scheme);
    }

    public final String schemeAsString() {
        return this.scheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParameters() ? this.queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRouteMatch)) {
            return false;
        }
        HttpRouteMatch other = (HttpRouteMatch)obj;
        return this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.methodAsString(), other.methodAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.prefix(), other.prefix()) && this.hasQueryParameters() == other.hasQueryParameters() && Objects.equals(this.queryParameters(), other.queryParameters()) && Objects.equals(this.schemeAsString(), other.schemeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"HttpRouteMatch").add("Headers", this.hasHeaders() ? this.headers() : null).add("Method", (Object)this.methodAsString()).add("Path", (Object)this.path()).add("Prefix", (Object)this.prefix()).add("QueryParameters", this.hasQueryParameters() ? this.queryParameters() : null).add("Scheme", (Object)this.schemeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "method": {
                return Optional.ofNullable(clazz.cast(this.methodAsString()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "queryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "scheme": {
                return Optional.ofNullable(clazz.cast(this.schemeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRouteMatch, T> g) {
        return obj -> g.apply((HttpRouteMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<HttpRouteHeader> headers = DefaultSdkAutoConstructList.getInstance();
        private String method;
        private HttpPathMatch path;
        private String prefix;
        private List<HttpQueryParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();
        private String scheme;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRouteMatch model) {
            this.headers(model.headers);
            this.method(model.method);
            this.path(model.path);
            this.prefix(model.prefix);
            this.queryParameters(model.queryParameters);
            this.scheme(model.scheme);
        }

        public final List<HttpRouteHeader.Builder> getHeaders() {
            List<HttpRouteHeader.Builder> result = HttpRouteHeadersCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<HttpRouteHeader.BuilderImpl> headers) {
            this.headers = HttpRouteHeadersCopier.copyFromBuilder(headers);
        }

        @Override
        @Transient
        public final Builder headers(Collection<HttpRouteHeader> headers) {
            this.headers = HttpRouteHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headers(HttpRouteHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headers(Consumer<HttpRouteHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (HttpRouteHeader)((HttpRouteHeader.Builder)HttpRouteHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        @Transient
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        @Transient
        public final Builder method(HttpMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final HttpPathMatch.Builder getPath() {
            return this.path != null ? this.path.toBuilder() : null;
        }

        public final void setPath(HttpPathMatch.BuilderImpl path) {
            this.path = path != null ? path.build() : null;
        }

        @Override
        @Transient
        public final Builder path(HttpPathMatch path) {
            this.path = path;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final List<HttpQueryParameter.Builder> getQueryParameters() {
            List<HttpQueryParameter.Builder> result = HttpQueryParametersCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<HttpQueryParameter.BuilderImpl> queryParameters) {
            this.queryParameters = HttpQueryParametersCopier.copyFromBuilder(queryParameters);
        }

        @Override
        @Transient
        public final Builder queryParameters(Collection<HttpQueryParameter> queryParameters) {
            this.queryParameters = HttpQueryParametersCopier.copy(queryParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryParameters(HttpQueryParameter ... queryParameters) {
            this.queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryParameters(Consumer<HttpQueryParameter.Builder> ... queryParameters) {
            this.queryParameters(Stream.of(queryParameters).map(c -> (HttpQueryParameter)((HttpQueryParameter.Builder)HttpQueryParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScheme() {
            return this.scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        @Transient
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        @Transient
        public final Builder scheme(HttpScheme scheme) {
            this.scheme(scheme == null ? null : scheme.toString());
            return this;
        }

        public HttpRouteMatch build() {
            return new HttpRouteMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpRouteMatch> {
        public Builder headers(Collection<HttpRouteHeader> var1);

        public Builder headers(HttpRouteHeader ... var1);

        public Builder headers(Consumer<HttpRouteHeader.Builder> ... var1);

        public Builder method(String var1);

        public Builder method(HttpMethod var1);

        public Builder path(HttpPathMatch var1);

        default public Builder path(Consumer<HttpPathMatch.Builder> path) {
            return this.path((HttpPathMatch)((HttpPathMatch.Builder)HttpPathMatch.builder().applyMutation(path)).build());
        }

        public Builder prefix(String var1);

        public Builder queryParameters(Collection<HttpQueryParameter> var1);

        public Builder queryParameters(HttpQueryParameter ... var1);

        public Builder queryParameters(Consumer<HttpQueryParameter.Builder> ... var1);

        public Builder scheme(String var1);

        public Builder scheme(HttpScheme var1);
    }
}

