/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.AwsCloudMapServiceDiscovery;
import software.amazon.awssdk.services.appmesh.model.DnsServiceDiscovery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDiscovery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDiscovery> {
    private static final SdkField<AwsCloudMapServiceDiscovery> AWS_CLOUD_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsCloudMap").getter(ServiceDiscovery.getter(ServiceDiscovery::awsCloudMap)).setter(ServiceDiscovery.setter(Builder::awsCloudMap)).constructor(AwsCloudMapServiceDiscovery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsCloudMap").build()}).build();
    private static final SdkField<DnsServiceDiscovery> DNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dns").getter(ServiceDiscovery.getter(ServiceDiscovery::dns)).setter(ServiceDiscovery.setter(Builder::dns)).constructor(DnsServiceDiscovery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dns").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_CLOUD_MAP_FIELD, DNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsCloudMapServiceDiscovery awsCloudMap;
    private final DnsServiceDiscovery dns;
    private final Type type;

    private ServiceDiscovery(BuilderImpl builder) {
        this.awsCloudMap = builder.awsCloudMap;
        this.dns = builder.dns;
        this.type = builder.type;
    }

    public final AwsCloudMapServiceDiscovery awsCloudMap() {
        return this.awsCloudMap;
    }

    public final DnsServiceDiscovery dns() {
        return this.dns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsCloudMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.dns());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDiscovery)) {
            return false;
        }
        ServiceDiscovery other = (ServiceDiscovery)obj;
        return Objects.equals(this.awsCloudMap(), other.awsCloudMap()) && Objects.equals(this.dns(), other.dns());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceDiscovery").add("AwsCloudMap", (Object)this.awsCloudMap()).add("Dns", (Object)this.dns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsCloudMap": {
                return Optional.ofNullable(clazz.cast(this.awsCloudMap()));
            }
            case "dns": {
                return Optional.ofNullable(clazz.cast(this.dns()));
            }
        }
        return Optional.empty();
    }

    public static ServiceDiscovery fromAwsCloudMap(AwsCloudMapServiceDiscovery awsCloudMap) {
        return (ServiceDiscovery)ServiceDiscovery.builder().awsCloudMap(awsCloudMap).build();
    }

    public static ServiceDiscovery fromAwsCloudMap(Consumer<AwsCloudMapServiceDiscovery.Builder> awsCloudMap) {
        AwsCloudMapServiceDiscovery.Builder builder = AwsCloudMapServiceDiscovery.builder();
        awsCloudMap.accept(builder);
        return ServiceDiscovery.fromAwsCloudMap((AwsCloudMapServiceDiscovery)builder.build());
    }

    public static ServiceDiscovery fromDns(DnsServiceDiscovery dns) {
        return (ServiceDiscovery)ServiceDiscovery.builder().dns(dns).build();
    }

    public static ServiceDiscovery fromDns(Consumer<DnsServiceDiscovery.Builder> dns) {
        DnsServiceDiscovery.Builder builder = DnsServiceDiscovery.builder();
        dns.accept(builder);
        return ServiceDiscovery.fromDns((DnsServiceDiscovery)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceDiscovery, T> g) {
        return obj -> g.apply((ServiceDiscovery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AWS_CLOUD_MAP,
        DNS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AwsCloudMapServiceDiscovery awsCloudMap;
        private DnsServiceDiscovery dns;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDiscovery model) {
            this.awsCloudMap(model.awsCloudMap);
            this.dns(model.dns);
        }

        public final AwsCloudMapServiceDiscovery.Builder getAwsCloudMap() {
            return this.awsCloudMap != null ? this.awsCloudMap.toBuilder() : null;
        }

        public final void setAwsCloudMap(AwsCloudMapServiceDiscovery.BuilderImpl awsCloudMap) {
            AwsCloudMapServiceDiscovery oldValue = this.awsCloudMap;
            this.awsCloudMap = awsCloudMap != null ? awsCloudMap.build() : null;
            this.handleUnionValueChange(Type.AWS_CLOUD_MAP, oldValue, this.awsCloudMap);
        }

        @Override
        @Transient
        public final Builder awsCloudMap(AwsCloudMapServiceDiscovery awsCloudMap) {
            AwsCloudMapServiceDiscovery oldValue = this.awsCloudMap;
            this.awsCloudMap = awsCloudMap;
            this.handleUnionValueChange(Type.AWS_CLOUD_MAP, oldValue, this.awsCloudMap);
            return this;
        }

        public final DnsServiceDiscovery.Builder getDns() {
            return this.dns != null ? this.dns.toBuilder() : null;
        }

        public final void setDns(DnsServiceDiscovery.BuilderImpl dns) {
            DnsServiceDiscovery oldValue = this.dns;
            this.dns = dns != null ? dns.build() : null;
            this.handleUnionValueChange(Type.DNS, oldValue, this.dns);
        }

        @Override
        @Transient
        public final Builder dns(DnsServiceDiscovery dns) {
            DnsServiceDiscovery oldValue = this.dns;
            this.dns = dns;
            this.handleUnionValueChange(Type.DNS, oldValue, this.dns);
            return this;
        }

        public ServiceDiscovery build() {
            return new ServiceDiscovery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDiscovery> {
        public Builder awsCloudMap(AwsCloudMapServiceDiscovery var1);

        default public Builder awsCloudMap(Consumer<AwsCloudMapServiceDiscovery.Builder> awsCloudMap) {
            return this.awsCloudMap((AwsCloudMapServiceDiscovery)((AwsCloudMapServiceDiscovery.Builder)AwsCloudMapServiceDiscovery.builder().applyMutation(awsCloudMap)).build());
        }

        public Builder dns(DnsServiceDiscovery var1);

        default public Builder dns(Consumer<DnsServiceDiscovery.Builder> dns) {
            return this.dns((DnsServiceDiscovery)((DnsServiceDiscovery.Builder)DnsServiceDiscovery.builder().applyMutation(dns)).build());
        }
    }
}

