/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVirtualRouterRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, UpdateVirtualRouterRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateVirtualRouterRequest.getter(UpdateVirtualRouterRequest::clientToken)).setter(UpdateVirtualRouterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(UpdateVirtualRouterRequest.getter(UpdateVirtualRouterRequest::meshName)).setter(UpdateVirtualRouterRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshOwner").getter(UpdateVirtualRouterRequest.getter(UpdateVirtualRouterRequest::meshOwner)).setter(UpdateVirtualRouterRequest.setter(Builder::meshOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()}).build();
    private static final SdkField<VirtualRouterSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spec").getter(UpdateVirtualRouterRequest.getter(UpdateVirtualRouterRequest::spec)).setter(UpdateVirtualRouterRequest.setter(Builder::spec)).constructor(VirtualRouterSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualRouterName").getter(UpdateVirtualRouterRequest.getter(UpdateVirtualRouterRequest::virtualRouterName)).setter(UpdateVirtualRouterRequest.setter(Builder::virtualRouterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualRouterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, MESH_NAME_FIELD, MESH_OWNER_FIELD, SPEC_FIELD, VIRTUAL_ROUTER_NAME_FIELD));
    private final String clientToken;
    private final String meshName;
    private final String meshOwner;
    private final VirtualRouterSpec spec;
    private final String virtualRouterName;

    private UpdateVirtualRouterRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.spec = builder.spec;
        this.virtualRouterName = builder.virtualRouterName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String meshName() {
        return this.meshName;
    }

    public final String meshOwner() {
        return this.meshOwner;
    }

    public final VirtualRouterSpec spec() {
        return this.spec;
    }

    public final String virtualRouterName() {
        return this.virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualRouterName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualRouterRequest)) {
            return false;
        }
        UpdateVirtualRouterRequest other = (UpdateVirtualRouterRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.meshOwner(), other.meshOwner()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.virtualRouterName(), other.virtualRouterName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVirtualRouterRequest").add("ClientToken", (Object)this.clientToken()).add("MeshName", (Object)this.meshName()).add("MeshOwner", (Object)this.meshOwner()).add("Spec", (Object)this.spec()).add("VirtualRouterName", (Object)this.virtualRouterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "meshOwner": {
                return Optional.ofNullable(clazz.cast(this.meshOwner()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "virtualRouterName": {
                return Optional.ofNullable(clazz.cast(this.virtualRouterName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualRouterRequest, T> g) {
        return obj -> g.apply((UpdateVirtualRouterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String meshName;
        private String meshOwner;
        private VirtualRouterSpec spec;
        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualRouterRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.meshName(model.meshName);
            this.meshOwner(model.meshOwner);
            this.spec(model.spec);
            this.virtualRouterName(model.virtualRouterName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getMeshOwner() {
            return this.meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        public final VirtualRouterSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualRouterSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualRouterSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVirtualRouterRequest build() {
            return new UpdateVirtualRouterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVirtualRouterRequest> {
        public Builder clientToken(String var1);

        public Builder meshName(String var1);

        public Builder meshOwner(String var1);

        public Builder spec(VirtualRouterSpec var1);

        default public Builder spec(Consumer<VirtualRouterSpec.Builder> spec) {
            return this.spec((VirtualRouterSpec)((VirtualRouterSpec.Builder)VirtualRouterSpec.builder().applyMutation(spec)).build());
        }

        public Builder virtualRouterName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

