/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ChangeEvent;
import software.amazon.awssdk.services.applicationsignals.model.ListEntityEventsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListEntityEventsResponse;

public class ListEntityEventsIterable
implements SdkIterable<ListEntityEventsResponse> {
    private final ApplicationSignalsClient client;
    private final ListEntityEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntityEventsIterable(ApplicationSignalsClient client, ListEntityEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEntityEventsResponseFetcher();
    }

    public Iterator<ListEntityEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChangeEvent> changeEvents() {
        Function<ListEntityEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.changeEvents() != null) {
                return response.changeEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEntityEventsResponseFetcher
    implements SyncPageFetcher<ListEntityEventsResponse> {
        private ListEntityEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListEntityEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntityEventsResponse nextPage(ListEntityEventsResponse previousPage) {
            if (previousPage == null) {
                return ListEntityEventsIterable.this.client.listEntityEvents(ListEntityEventsIterable.this.firstRequest);
            }
            return ListEntityEventsIterable.this.client.listEntityEvents((ListEntityEventsRequest)((Object)ListEntityEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

