/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the performance metric that a period-based SLO monitors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLevelIndicator implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLevelIndicator.Builder, ServiceLevelIndicator> {
    private static final SdkField<ServiceLevelIndicatorMetric> SLI_METRIC_FIELD = SdkField
            .<ServiceLevelIndicatorMetric> builder(MarshallingType.SDK_POJO).memberName("SliMetric")
            .getter(getter(ServiceLevelIndicator::sliMetric)).setter(setter(Builder::sliMetric))
            .constructor(ServiceLevelIndicatorMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SliMetric").build()).build();

    private static final SdkField<Double> METRIC_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MetricThreshold").getter(getter(ServiceLevelIndicator::metricThreshold))
            .setter(setter(Builder::metricThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricThreshold").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(ServiceLevelIndicator::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLI_METRIC_FIELD,
            METRIC_THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceLevelIndicatorMetric sliMetric;

    private final Double metricThreshold;

    private final String comparisonOperator;

    private ServiceLevelIndicator(BuilderImpl builder) {
        this.sliMetric = builder.sliMetric;
        this.metricThreshold = builder.metricThreshold;
        this.comparisonOperator = builder.comparisonOperator;
    }

    /**
     * <p>
     * A structure that contains information about the metric that the SLO monitors.
     * </p>
     * 
     * @return A structure that contains information about the metric that the SLO monitors.
     */
    public final ServiceLevelIndicatorMetric sliMetric() {
        return sliMetric;
    }

    /**
     * <p>
     * The value that the SLI metric is compared to.
     * </p>
     * 
     * @return The value that the SLI metric is compared to.
     */
    public final Double metricThreshold() {
        return metricThreshold;
    }

    /**
     * <p>
     * The arithmetic operation used when comparing the specified metric to the threshold.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ServiceLevelIndicatorComparisonOperator#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The arithmetic operation used when comparing the specified metric to the threshold.
     * @see ServiceLevelIndicatorComparisonOperator
     */
    public final ServiceLevelIndicatorComparisonOperator comparisonOperator() {
        return ServiceLevelIndicatorComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * The arithmetic operation used when comparing the specified metric to the threshold.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ServiceLevelIndicatorComparisonOperator#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The arithmetic operation used when comparing the specified metric to the threshold.
     * @see ServiceLevelIndicatorComparisonOperator
     */
    public final String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sliMetric());
        hashCode = 31 * hashCode + Objects.hashCode(metricThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelIndicator)) {
            return false;
        }
        ServiceLevelIndicator other = (ServiceLevelIndicator) obj;
        return Objects.equals(sliMetric(), other.sliMetric()) && Objects.equals(metricThreshold(), other.metricThreshold())
                && Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLevelIndicator").add("SliMetric", sliMetric()).add("MetricThreshold", metricThreshold())
                .add("ComparisonOperator", comparisonOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SliMetric":
            return Optional.ofNullable(clazz.cast(sliMetric()));
        case "MetricThreshold":
            return Optional.ofNullable(clazz.cast(metricThreshold()));
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SliMetric", SLI_METRIC_FIELD);
        map.put("MetricThreshold", METRIC_THRESHOLD_FIELD);
        map.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelIndicator, T> g) {
        return obj -> g.apply((ServiceLevelIndicator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLevelIndicator> {
        /**
         * <p>
         * A structure that contains information about the metric that the SLO monitors.
         * </p>
         * 
         * @param sliMetric
         *        A structure that contains information about the metric that the SLO monitors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sliMetric(ServiceLevelIndicatorMetric sliMetric);

        /**
         * <p>
         * A structure that contains information about the metric that the SLO monitors.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceLevelIndicatorMetric.Builder}
         * avoiding the need to create one manually via {@link ServiceLevelIndicatorMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLevelIndicatorMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #sliMetric(ServiceLevelIndicatorMetric)}.
         * 
         * @param sliMetric
         *        a consumer that will call methods on {@link ServiceLevelIndicatorMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sliMetric(ServiceLevelIndicatorMetric)
         */
        default Builder sliMetric(Consumer<ServiceLevelIndicatorMetric.Builder> sliMetric) {
            return sliMetric(ServiceLevelIndicatorMetric.builder().applyMutation(sliMetric).build());
        }

        /**
         * <p>
         * The value that the SLI metric is compared to.
         * </p>
         * 
         * @param metricThreshold
         *        The value that the SLI metric is compared to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricThreshold(Double metricThreshold);

        /**
         * <p>
         * The arithmetic operation used when comparing the specified metric to the threshold.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation used when comparing the specified metric to the threshold.
         * @see ServiceLevelIndicatorComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The arithmetic operation used when comparing the specified metric to the threshold.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation used when comparing the specified metric to the threshold.
         * @see ServiceLevelIndicatorComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorComparisonOperator
         */
        Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator comparisonOperator);
    }

    static final class BuilderImpl implements Builder {
        private ServiceLevelIndicatorMetric sliMetric;

        private Double metricThreshold;

        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelIndicator model) {
            sliMetric(model.sliMetric);
            metricThreshold(model.metricThreshold);
            comparisonOperator(model.comparisonOperator);
        }

        public final ServiceLevelIndicatorMetric.Builder getSliMetric() {
            return sliMetric != null ? sliMetric.toBuilder() : null;
        }

        public final void setSliMetric(ServiceLevelIndicatorMetric.BuilderImpl sliMetric) {
            this.sliMetric = sliMetric != null ? sliMetric.build() : null;
        }

        @Override
        public final Builder sliMetric(ServiceLevelIndicatorMetric sliMetric) {
            this.sliMetric = sliMetric;
            return this;
        }

        public final Double getMetricThreshold() {
            return metricThreshold;
        }

        public final void setMetricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
        }

        @Override
        public final Builder metricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
            return this;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        @Override
        public ServiceLevelIndicator build() {
            return new ServiceLevelIndicator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
