/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a logical grouping of services based on shared attributes such as business unit,
 * environment, or entry point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceGroup implements SdkPojo, Serializable, ToCopyableBuilder<ServiceGroup.Builder, ServiceGroup> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(ServiceGroup::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupValue").getter(getter(ServiceGroup::groupValue)).setter(setter(Builder::groupValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupValue").build()).build();

    private static final SdkField<String> GROUP_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupSource").getter(getter(ServiceGroup::groupSource)).setter(setter(Builder::groupSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSource").build()).build();

    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupIdentifier").getter(getter(ServiceGroup::groupIdentifier)).setter(setter(Builder::groupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            GROUP_VALUE_FIELD, GROUP_SOURCE_FIELD, GROUP_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String groupValue;

    private final String groupSource;

    private final String groupIdentifier;

    private ServiceGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupValue = builder.groupValue;
        this.groupSource = builder.groupSource;
        this.groupIdentifier = builder.groupIdentifier;
    }

    /**
     * <p>
     * The name of the grouping attribute, such as <code>BusinessUnit</code> or <code>Environment</code>.
     * </p>
     * 
     * @return The name of the grouping attribute, such as <code>BusinessUnit</code> or <code>Environment</code>.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The value of the grouping attribute for this service, such as <code>Payments</code> or <code>Production</code>.
     * </p>
     * 
     * @return The value of the grouping attribute for this service, such as <code>Payments</code> or
     *         <code>Production</code>.
     */
    public final String groupValue() {
        return groupValue;
    }

    /**
     * <p>
     * The source of the grouping attribute, such as <code>TAG</code>, <code>OTEL</code>, or <code>DEFAULT</code>.
     * </p>
     * 
     * @return The source of the grouping attribute, such as <code>TAG</code>, <code>OTEL</code>, or
     *         <code>DEFAULT</code>.
     */
    public final String groupSource() {
        return groupSource;
    }

    /**
     * <p>
     * A unique identifier for this grouping attribute value, used for filtering and API operations.
     * </p>
     * 
     * @return A unique identifier for this grouping attribute value, used for filtering and API operations.
     */
    public final String groupIdentifier() {
        return groupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupValue());
        hashCode = 31 * hashCode + Objects.hashCode(groupSource());
        hashCode = 31 * hashCode + Objects.hashCode(groupIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceGroup)) {
            return false;
        }
        ServiceGroup other = (ServiceGroup) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(groupValue(), other.groupValue())
                && Objects.equals(groupSource(), other.groupSource())
                && Objects.equals(groupIdentifier(), other.groupIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceGroup").add("GroupName", groupName()).add("GroupValue", groupValue())
                .add("GroupSource", groupSource()).add("GroupIdentifier", groupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupValue":
            return Optional.ofNullable(clazz.cast(groupValue()));
        case "GroupSource":
            return Optional.ofNullable(clazz.cast(groupSource()));
        case "GroupIdentifier":
            return Optional.ofNullable(clazz.cast(groupIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("GroupValue", GROUP_VALUE_FIELD);
        map.put("GroupSource", GROUP_SOURCE_FIELD);
        map.put("GroupIdentifier", GROUP_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceGroup, T> g) {
        return obj -> g.apply((ServiceGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceGroup> {
        /**
         * <p>
         * The name of the grouping attribute, such as <code>BusinessUnit</code> or <code>Environment</code>.
         * </p>
         * 
         * @param groupName
         *        The name of the grouping attribute, such as <code>BusinessUnit</code> or <code>Environment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The value of the grouping attribute for this service, such as <code>Payments</code> or
         * <code>Production</code>.
         * </p>
         * 
         * @param groupValue
         *        The value of the grouping attribute for this service, such as <code>Payments</code> or
         *        <code>Production</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupValue(String groupValue);

        /**
         * <p>
         * The source of the grouping attribute, such as <code>TAG</code>, <code>OTEL</code>, or <code>DEFAULT</code>.
         * </p>
         * 
         * @param groupSource
         *        The source of the grouping attribute, such as <code>TAG</code>, <code>OTEL</code>, or
         *        <code>DEFAULT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupSource(String groupSource);

        /**
         * <p>
         * A unique identifier for this grouping attribute value, used for filtering and API operations.
         * </p>
         * 
         * @param groupIdentifier
         *        A unique identifier for this grouping attribute value, used for filtering and API operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIdentifier(String groupIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String groupValue;

        private String groupSource;

        private String groupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceGroup model) {
            groupName(model.groupName);
            groupValue(model.groupValue);
            groupSource(model.groupSource);
            groupIdentifier(model.groupIdentifier);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupValue() {
            return groupValue;
        }

        public final void setGroupValue(String groupValue) {
            this.groupValue = groupValue;
        }

        @Override
        public final Builder groupValue(String groupValue) {
            this.groupValue = groupValue;
            return this;
        }

        public final String getGroupSource() {
            return groupSource;
        }

        public final void setGroupSource(String groupSource) {
            this.groupSource = groupSource;
        }

        @Override
        public final Builder groupSource(String groupSource) {
            this.groupSource = groupSource;
            return this;
        }

        public final String getGroupIdentifier() {
            return groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        @Override
        public ServiceGroup build() {
            return new ServiceGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
