/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this structure to define a metric or metric math expression that you want to use as for a service level
 * objective.
 * </p>
 * <p>
 * Each <code>MetricDataQuery</code> in the <code>MetricDataQueries</code> array specifies either a metric to retrieve,
 * or a metric math expression to be performed on retrieved metrics. A single <code>MetricDataQueries</code> array can
 * include as many as 20 <code>MetricDataQuery</code> structures in the array. The 20 structures can include as many as
 * 10 structures that contain a <code>MetricStat</code> parameter to retrieve a metric, and as many as 10 structures
 * that contain the <code>Expression</code> parameter to perform a math expression. Of those <code>Expression</code>
 * structures, exactly one must have true as the value for <code>ReturnData</code>. The result of this expression used
 * for the SLO.
 * </p>
 * <p>
 * For more information about metric math expressions, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html">CloudWatchUse metric
 * math</a>.
 * </p>
 * <p>
 * Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
 * <code>MetricStat</code> but not both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDataQuery implements SdkPojo, Serializable, ToCopyableBuilder<MetricDataQuery.Builder, MetricDataQuery> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(MetricDataQuery::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<MetricStat> METRIC_STAT_FIELD = SdkField.<MetricStat> builder(MarshallingType.SDK_POJO)
            .memberName("MetricStat").getter(getter(MetricDataQuery::metricStat)).setter(setter(Builder::metricStat))
            .constructor(MetricStat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStat").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(MetricDataQuery::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(MetricDataQuery::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<Boolean> RETURN_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnData").getter(getter(MetricDataQuery::returnData)).setter(setter(Builder::returnData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnData").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(MetricDataQuery::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(MetricDataQuery::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, METRIC_STAT_FIELD,
            EXPRESSION_FIELD, LABEL_FIELD, RETURN_DATA_FIELD, PERIOD_FIELD, ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final MetricStat metricStat;

    private final String expression;

    private final String label;

    private final Boolean returnData;

    private final Integer period;

    private final String accountId;

    private MetricDataQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.metricStat = builder.metricStat;
        this.expression = builder.expression;
        this.label = builder.label;
        this.returnData = builder.returnData;
        this.period = builder.period;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * A short name used to tie this object to the results in the response. This <code>Id</code> must be unique within a
     * <code>MetricDataQueries</code> array. If you are performing math expressions on this set of data, this name
     * represents that data and can serve as a variable in the metric math expression. The valid characters are letters,
     * numbers, and underscore. The first character must be a lowercase letter.
     * </p>
     * 
     * @return A short name used to tie this object to the results in the response. This <code>Id</code> must be unique
     *         within a <code>MetricDataQueries</code> array. If you are performing math expressions on this set of
     *         data, this name represents that data and can serve as a variable in the metric math expression. The valid
     *         characters are letters, numbers, and underscore. The first character must be a lowercase letter.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO.
     * </p>
     * <p>
     * Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
     * <code>MetricStat</code> but not both.
     * </p>
     * 
     * @return A metric to be used directly for the SLO, or to be used in the math expression that will be used for the
     *         SLO.</p>
     *         <p>
     *         Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
     *         <code>MetricStat</code> but not both.
     */
    public final MetricStat metricStat() {
        return metricStat;
    }

    /**
     * <p>
     * This field can contain a metric math expression to be performed on the other metrics that you are retrieving
     * within this <code>MetricDataQueries</code> structure.
     * </p>
     * <p>
     * A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can
     * also use the <code>Id</code> of other expressions to use the result of those expressions. For more information
     * about metric math expressions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
     * <code>MetricStat</code> but not both.
     * </p>
     * 
     * @return This field can contain a metric math expression to be performed on the other metrics that you are
     *         retrieving within this <code>MetricDataQueries</code> structure. </p>
     *         <p>
     *         A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics,
     *         and can also use the <code>Id</code> of other expressions to use the result of those expressions. For
     *         more information about metric math expressions, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     *         >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     *         </p>
     *         <p>
     *         Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
     *         <code>MetricStat</code> but not both.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * A human-readable label for this metric or expression. This is especially useful if this is an expression, so that
     * you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the
     * label is shown. If <code>Label</code> is omitted, CloudWatch generates a default.
     * </p>
     * <p>
     * You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic
     * Labels</a>.
     * </p>
     * 
     * @return A human-readable label for this metric or expression. This is especially useful if this is an expression,
     *         so that you know what the value represents. If the metric or expression is shown in a CloudWatch
     *         dashboard widget, the label is shown. If <code>Label</code> is omitted, CloudWatch generates a
     *         default.</p>
     *         <p>
     *         You can put dynamic expressions into a label, so that it is more descriptive. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using
     *         Dynamic Labels</a>.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * Use this only if you are using a metric math expression for the SLO. Specify <code>true</code> for
     * <code>ReturnData</code> for only the one expression result to use as the alarm. For all other metrics and
     * expressions in the same <code>CreateServiceLevelObjective</code> operation, specify <code>ReturnData</code> as
     * <code>false</code>.
     * </p>
     * 
     * @return Use this only if you are using a metric math expression for the SLO. Specify <code>true</code> for
     *         <code>ReturnData</code> for only the one expression result to use as the alarm. For all other metrics and
     *         expressions in the same <code>CreateServiceLevelObjective</code> operation, specify
     *         <code>ReturnData</code> as <code>false</code>.
     */
    public final Boolean returnData() {
        return returnData;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points for this metric. For metrics with regular resolution, a
     * period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that
     * are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60.
     * High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a
     * <code>StorageResolution</code> of 1 second.
     * </p>
     * <p>
     * If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must specify
     * the period as follows or no data points in that time range is returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The granularity, in seconds, of the returned data points for this metric. For metrics with regular
     *         resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For
     *         high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5,
     *         10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a
     *         <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p>
     *         <p>
     *         If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must
     *         specify the period as follows or no data points in that time range is returned:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
     *         </p>
     *         </li>
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The ID of the account where this metric is located. If you are performing this operation in a monitoring account,
     * use this to specify which source account to retrieve this metric from.
     * </p>
     * 
     * @return The ID of the account where this metric is located. If you are performing this operation in a monitoring
     *         account, use this to specify which source account to retrieve this metric from.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metricStat());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(returnData());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataQuery)) {
            return false;
        }
        MetricDataQuery other = (MetricDataQuery) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(metricStat(), other.metricStat())
                && Objects.equals(expression(), other.expression()) && Objects.equals(label(), other.label())
                && Objects.equals(returnData(), other.returnData()) && Objects.equals(period(), other.period())
                && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDataQuery").add("Id", id()).add("MetricStat", metricStat())
                .add("Expression", expression()).add("Label", label()).add("ReturnData", returnData()).add("Period", period())
                .add("AccountId", accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MetricStat":
            return Optional.ofNullable(clazz.cast(metricStat()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "ReturnData":
            return Optional.ofNullable(clazz.cast(returnData()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("MetricStat", METRIC_STAT_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("ReturnData", RETURN_DATA_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDataQuery, T> g) {
        return obj -> g.apply((MetricDataQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDataQuery> {
        /**
         * <p>
         * A short name used to tie this object to the results in the response. This <code>Id</code> must be unique
         * within a <code>MetricDataQueries</code> array. If you are performing math expressions on this set of data,
         * this name represents that data and can serve as a variable in the metric math expression. The valid
         * characters are letters, numbers, and underscore. The first character must be a lowercase letter.
         * </p>
         * 
         * @param id
         *        A short name used to tie this object to the results in the response. This <code>Id</code> must be
         *        unique within a <code>MetricDataQueries</code> array. If you are performing math expressions on this
         *        set of data, this name represents that data and can serve as a variable in the metric math expression.
         *        The valid characters are letters, numbers, and underscore. The first character must be a lowercase
         *        letter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO.
         * </p>
         * <p>
         * Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
         * <code>MetricStat</code> but not both.
         * </p>
         * 
         * @param metricStat
         *        A metric to be used directly for the SLO, or to be used in the math expression that will be used for
         *        the SLO.</p>
         *        <p>
         *        Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
         *        <code>MetricStat</code> but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricStat(MetricStat metricStat);

        /**
         * <p>
         * A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO.
         * </p>
         * <p>
         * Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
         * <code>MetricStat</code> but not both.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricStat.Builder} avoiding the need to
         * create one manually via {@link MetricStat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricStat.Builder#build()} is called immediately and its result
         * is passed to {@link #metricStat(MetricStat)}.
         * 
         * @param metricStat
         *        a consumer that will call methods on {@link MetricStat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricStat(MetricStat)
         */
        default Builder metricStat(Consumer<MetricStat.Builder> metricStat) {
            return metricStat(MetricStat.builder().applyMutation(metricStat).build());
        }

        /**
         * <p>
         * This field can contain a metric math expression to be performed on the other metrics that you are retrieving
         * within this <code>MetricDataQueries</code> structure.
         * </p>
         * <p>
         * A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and
         * can also use the <code>Id</code> of other expressions to use the result of those expressions. For more
         * information about metric math expressions, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
         * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * <p>
         * Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
         * <code>MetricStat</code> but not both.
         * </p>
         * 
         * @param expression
         *        This field can contain a metric math expression to be performed on the other metrics that you are
         *        retrieving within this <code>MetricDataQueries</code> structure. </p>
         *        <p>
         *        A math expression can use the <code>Id</code> of the other metrics or queries to refer to those
         *        metrics, and can also use the <code>Id</code> of other expressions to use the result of those
         *        expressions. For more information about metric math expressions, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
         *        >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
         *        </p>
         *        <p>
         *        Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or
         *        <code>MetricStat</code> but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * A human-readable label for this metric or expression. This is especially useful if this is an expression, so
         * that you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard
         * widget, the label is shown. If <code>Label</code> is omitted, CloudWatch generates a default.
         * </p>
         * <p>
         * You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic
         * Labels</a>.
         * </p>
         * 
         * @param label
         *        A human-readable label for this metric or expression. This is especially useful if this is an
         *        expression, so that you know what the value represents. If the metric or expression is shown in a
         *        CloudWatch dashboard widget, the label is shown. If <code>Label</code> is omitted, CloudWatch
         *        generates a default.</p>
         *        <p>
         *        You can put dynamic expressions into a label, so that it is more descriptive. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using
         *        Dynamic Labels</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * Use this only if you are using a metric math expression for the SLO. Specify <code>true</code> for
         * <code>ReturnData</code> for only the one expression result to use as the alarm. For all other metrics and
         * expressions in the same <code>CreateServiceLevelObjective</code> operation, specify <code>ReturnData</code>
         * as <code>false</code>.
         * </p>
         * 
         * @param returnData
         *        Use this only if you are using a metric math expression for the SLO. Specify <code>true</code> for
         *        <code>ReturnData</code> for only the one expression result to use as the alarm. For all other metrics
         *        and expressions in the same <code>CreateServiceLevelObjective</code> operation, specify
         *        <code>ReturnData</code> as <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnData(Boolean returnData);

        /**
         * <p>
         * The granularity, in seconds, of the returned data points for this metric. For metrics with regular
         * resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For
         * high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10,
         * 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a
         * <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.
         * </p>
         * <p>
         * If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must
         * specify the period as follows or no data points in that time range is returned:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
         * </p>
         * </li>
         * </ul>
         * 
         * @param period
         *        The granularity, in seconds, of the returned data points for this metric. For metrics with regular
         *        resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For
         *        high-resolution metrics that are collected at intervals of less than one minute, the period can be 1,
         *        5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a
         *        <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p>
         *        <p>
         *        If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you
         *        must specify the period as follows or no data points in that time range is returned:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The ID of the account where this metric is located. If you are performing this operation in a monitoring
         * account, use this to specify which source account to retrieve this metric from.
         * </p>
         * 
         * @param accountId
         *        The ID of the account where this metric is located. If you are performing this operation in a
         *        monitoring account, use this to specify which source account to retrieve this metric from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private MetricStat metricStat;

        private String expression;

        private String label;

        private Boolean returnData;

        private Integer period;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataQuery model) {
            id(model.id);
            metricStat(model.metricStat);
            expression(model.expression);
            label(model.label);
            returnData(model.returnData);
            period(model.period);
            accountId(model.accountId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MetricStat.Builder getMetricStat() {
            return metricStat != null ? metricStat.toBuilder() : null;
        }

        public final void setMetricStat(MetricStat.BuilderImpl metricStat) {
            this.metricStat = metricStat != null ? metricStat.build() : null;
        }

        @Override
        public final Builder metricStat(MetricStat metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Boolean getReturnData() {
            return returnData;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public MetricDataQuery build() {
            return new MetricDataQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
