/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditFindingsResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<ListAuditFindingsResponse.Builder, ListAuditFindingsResponse> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListAuditFindingsResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListAuditFindingsResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<AuditFinding>> AUDIT_FINDINGS_FIELD = SdkField
            .<List<AuditFinding>> builder(MarshallingType.LIST)
            .memberName("AuditFindings")
            .getter(getter(ListAuditFindingsResponse::auditFindings))
            .setter(setter(Builder::auditFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAuditFindingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, AUDIT_FINDINGS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startTime;

    private final Instant endTime;

    private final List<AuditFinding> auditFindings;

    private final String nextToken;

    private ListAuditFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.auditFindings = builder.auditFindings;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start of the time period that the returned audit findings apply to. When used in a raw HTTP Query API, it is
     * formatted as epoch time in seconds. For example, <code>1698778057</code>
     * </p>
     * 
     * @return The start of the time period that the returned audit findings apply to. When used in a raw HTTP Query
     *         API, it is formatted as epoch time in seconds. For example, <code>1698778057</code>
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period that the returned audit findings apply to. When used in a raw HTTP Query API, it is
     * formatted as epoch time in seconds. For example, <code>1698778057</code>
     * </p>
     * 
     * @return The end of the time period that the returned audit findings apply to. When used in a raw HTTP Query API,
     *         it is formatted as epoch time in seconds. For example, <code>1698778057</code>
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuditFindings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuditFindings() {
        return auditFindings != null && !(auditFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure contains information about one audit finding, including the auditor
     * results, severity, and associated metric and dependency graphs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditFindings} method.
     * </p>
     * 
     * @return An array of structures, where each structure contains information about one audit finding, including the
     *         auditor results, severity, and associated metric and dependency graphs.
     */
    public final List<AuditFinding> auditFindings() {
        return auditFindings;
    }

    /**
     * <p>
     * Include this value in your next use of this API to get the next set of audit findings.
     * </p>
     * 
     * @return Include this value in your next use of this API to get the next set of audit findings.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditFindings() ? auditFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditFindingsResponse)) {
            return false;
        }
        ListAuditFindingsResponse other = (ListAuditFindingsResponse) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasAuditFindings() == other.hasAuditFindings() && Objects.equals(auditFindings(), other.auditFindings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAuditFindingsResponse").add("StartTime", startTime()).add("EndTime", endTime())
                .add("AuditFindings", hasAuditFindings() ? auditFindings() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "AuditFindings":
            return Optional.ofNullable(clazz.cast(auditFindings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("AuditFindings", AUDIT_FINDINGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAuditFindingsResponse, T> g) {
        return obj -> g.apply((ListAuditFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAuditFindingsResponse> {
        /**
         * <p>
         * The start of the time period that the returned audit findings apply to. When used in a raw HTTP Query API, it
         * is formatted as epoch time in seconds. For example, <code>1698778057</code>
         * </p>
         * 
         * @param startTime
         *        The start of the time period that the returned audit findings apply to. When used in a raw HTTP Query
         *        API, it is formatted as epoch time in seconds. For example, <code>1698778057</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period that the returned audit findings apply to. When used in a raw HTTP Query API, it
         * is formatted as epoch time in seconds. For example, <code>1698778057</code>
         * </p>
         * 
         * @param endTime
         *        The end of the time period that the returned audit findings apply to. When used in a raw HTTP Query
         *        API, it is formatted as epoch time in seconds. For example, <code>1698778057</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * An array of structures, where each structure contains information about one audit finding, including the
         * auditor results, severity, and associated metric and dependency graphs.
         * </p>
         * 
         * @param auditFindings
         *        An array of structures, where each structure contains information about one audit finding, including
         *        the auditor results, severity, and associated metric and dependency graphs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditFindings(Collection<AuditFinding> auditFindings);

        /**
         * <p>
         * An array of structures, where each structure contains information about one audit finding, including the
         * auditor results, severity, and associated metric and dependency graphs.
         * </p>
         * 
         * @param auditFindings
         *        An array of structures, where each structure contains information about one audit finding, including
         *        the auditor results, severity, and associated metric and dependency graphs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditFindings(AuditFinding... auditFindings);

        /**
         * <p>
         * An array of structures, where each structure contains information about one audit finding, including the
         * auditor results, severity, and associated metric and dependency graphs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditFinding.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditFinding.Builder#build()} is called
         * immediately and its result is passed to {@link #auditFindings(List<AuditFinding>)}.
         * 
         * @param auditFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.AuditFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditFindings(java.util.Collection<AuditFinding>)
         */
        Builder auditFindings(Consumer<AuditFinding.Builder>... auditFindings);

        /**
         * <p>
         * Include this value in your next use of this API to get the next set of audit findings.
         * </p>
         * 
         * @param nextToken
         *        Include this value in your next use of this API to get the next set of audit findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private List<AuditFinding> auditFindings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditFindingsResponse model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            auditFindings(model.auditFindings);
            nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<AuditFinding.Builder> getAuditFindings() {
            List<AuditFinding.Builder> result = AuditFindingsCopier.copyToBuilder(this.auditFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditFindings(Collection<AuditFinding.BuilderImpl> auditFindings) {
            this.auditFindings = AuditFindingsCopier.copyFromBuilder(auditFindings);
        }

        @Override
        public final Builder auditFindings(Collection<AuditFinding> auditFindings) {
            this.auditFindings = AuditFindingsCopier.copy(auditFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditFindings(AuditFinding... auditFindings) {
            auditFindings(Arrays.asList(auditFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditFindings(Consumer<AuditFinding.Builder>... auditFindings) {
            auditFindings(Stream.of(auditFindings).map(c -> AuditFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAuditFindingsResponse build() {
            return new ListAuditFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
