/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The core SLO time window exclusion object that includes Window, StartTime, RecurrenceRule, and Reason.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExclusionWindow implements SdkPojo, Serializable, ToCopyableBuilder<ExclusionWindow.Builder, ExclusionWindow> {
    private static final SdkField<Window> WINDOW_FIELD = SdkField.<Window> builder(MarshallingType.SDK_POJO).memberName("Window")
            .getter(getter(ExclusionWindow::window)).setter(setter(Builder::window)).constructor(Window::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Window").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ExclusionWindow::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<RecurrenceRule> RECURRENCE_RULE_FIELD = SdkField
            .<RecurrenceRule> builder(MarshallingType.SDK_POJO).memberName("RecurrenceRule")
            .getter(getter(ExclusionWindow::recurrenceRule)).setter(setter(Builder::recurrenceRule))
            .constructor(RecurrenceRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurrenceRule").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ExclusionWindow::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_FIELD,
            START_TIME_FIELD, RECURRENCE_RULE_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Window window;

    private final Instant startTime;

    private final RecurrenceRule recurrenceRule;

    private final String reason;

    private ExclusionWindow(BuilderImpl builder) {
        this.window = builder.window;
        this.startTime = builder.startTime;
        this.recurrenceRule = builder.recurrenceRule;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The SLO time window exclusion .
     * </p>
     * 
     * @return The SLO time window exclusion .
     */
    public final Window window() {
        return window;
    }

    /**
     * <p>
     * The start of the SLO time window exclusion. Defaults to current time if not specified.
     * </p>
     * 
     * @return The start of the SLO time window exclusion. Defaults to current time if not specified.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The recurrence rule for the SLO time window exclusion. Supports both cron and rate expressions.
     * </p>
     * 
     * @return The recurrence rule for the SLO time window exclusion. Supports both cron and rate expressions.
     */
    public final RecurrenceRule recurrenceRule() {
        return recurrenceRule;
    }

    /**
     * <p>
     * A description explaining why this time period should be excluded from SLO calculations.
     * </p>
     * 
     * @return A description explaining why this time period should be excluded from SLO calculations.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(window());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(recurrenceRule());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExclusionWindow)) {
            return false;
        }
        ExclusionWindow other = (ExclusionWindow) obj;
        return Objects.equals(window(), other.window()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(recurrenceRule(), other.recurrenceRule()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExclusionWindow").add("Window", window()).add("StartTime", startTime())
                .add("RecurrenceRule", recurrenceRule()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Window":
            return Optional.ofNullable(clazz.cast(window()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "RecurrenceRule":
            return Optional.ofNullable(clazz.cast(recurrenceRule()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Window", WINDOW_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("RecurrenceRule", RECURRENCE_RULE_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExclusionWindow, T> g) {
        return obj -> g.apply((ExclusionWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExclusionWindow> {
        /**
         * <p>
         * The SLO time window exclusion .
         * </p>
         * 
         * @param window
         *        The SLO time window exclusion .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder window(Window window);

        /**
         * <p>
         * The SLO time window exclusion .
         * </p>
         * This is a convenience method that creates an instance of the {@link Window.Builder} avoiding the need to
         * create one manually via {@link Window#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Window.Builder#build()} is called immediately and its result is
         * passed to {@link #window(Window)}.
         * 
         * @param window
         *        a consumer that will call methods on {@link Window.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #window(Window)
         */
        default Builder window(Consumer<Window.Builder> window) {
            return window(Window.builder().applyMutation(window).build());
        }

        /**
         * <p>
         * The start of the SLO time window exclusion. Defaults to current time if not specified.
         * </p>
         * 
         * @param startTime
         *        The start of the SLO time window exclusion. Defaults to current time if not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The recurrence rule for the SLO time window exclusion. Supports both cron and rate expressions.
         * </p>
         * 
         * @param recurrenceRule
         *        The recurrence rule for the SLO time window exclusion. Supports both cron and rate expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrenceRule(RecurrenceRule recurrenceRule);

        /**
         * <p>
         * The recurrence rule for the SLO time window exclusion. Supports both cron and rate expressions.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecurrenceRule.Builder} avoiding the need
         * to create one manually via {@link RecurrenceRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecurrenceRule.Builder#build()} is called immediately and its
         * result is passed to {@link #recurrenceRule(RecurrenceRule)}.
         * 
         * @param recurrenceRule
         *        a consumer that will call methods on {@link RecurrenceRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrenceRule(RecurrenceRule)
         */
        default Builder recurrenceRule(Consumer<RecurrenceRule.Builder> recurrenceRule) {
            return recurrenceRule(RecurrenceRule.builder().applyMutation(recurrenceRule).build());
        }

        /**
         * <p>
         * A description explaining why this time period should be excluded from SLO calculations.
         * </p>
         * 
         * @param reason
         *        A description explaining why this time period should be excluded from SLO calculations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private Window window;

        private Instant startTime;

        private RecurrenceRule recurrenceRule;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ExclusionWindow model) {
            window(model.window);
            startTime(model.startTime);
            recurrenceRule(model.recurrenceRule);
            reason(model.reason);
        }

        public final Window.Builder getWindow() {
            return window != null ? window.toBuilder() : null;
        }

        public final void setWindow(Window.BuilderImpl window) {
            this.window = window != null ? window.build() : null;
        }

        @Override
        public final Builder window(Window window) {
            this.window = window;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final RecurrenceRule.Builder getRecurrenceRule() {
            return recurrenceRule != null ? recurrenceRule.toBuilder() : null;
        }

        public final void setRecurrenceRule(RecurrenceRule.BuilderImpl recurrenceRule) {
            this.recurrenceRule = recurrenceRule != null ? recurrenceRule.build() : null;
        }

        @Override
        public final Builder recurrenceRule(RecurrenceRule recurrenceRule) {
            this.recurrenceRule = recurrenceRule;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public ExclusionWindow build() {
            return new ExclusionWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
