/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If the interval for this service level objective is a calendar interval, this structure contains the interval
 * specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalendarInterval implements SdkPojo, Serializable,
        ToCopyableBuilder<CalendarInterval.Builder, CalendarInterval> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(CalendarInterval::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> DURATION_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurationUnit").getter(getter(CalendarInterval::durationUnitAsString))
            .setter(setter(Builder::durationUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationUnit").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(CalendarInterval::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            DURATION_UNIT_FIELD, DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final String durationUnit;

    private final Integer duration;

    private CalendarInterval(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.durationUnit = builder.durationUnit;
        this.duration = builder.duration;
    }

    /**
     * <p>
     * The date and time when you want the first interval to start. Be sure to choose a time that configures the
     * intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure
     * to specify a start time that is a Monday at 6 a.m.
     * </p>
     * <p>
     * When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
     * <code>1698778057</code>
     * </p>
     * <p>
     * As soon as one calendar interval ends, another automatically begins.
     * </p>
     * 
     * @return The date and time when you want the first interval to start. Be sure to choose a time that configures the
     *         intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m.,
     *         be sure to specify a start time that is a Monday at 6 a.m.</p>
     *         <p>
     *         When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
     *         <code>1698778057</code>
     *         </p>
     *         <p>
     *         As soon as one calendar interval ends, another automatically begins.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Specifies the calendar interval unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnit} will
     * return {@link DurationUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #durationUnitAsString}.
     * </p>
     * 
     * @return Specifies the calendar interval unit.
     * @see DurationUnit
     */
    public final DurationUnit durationUnit() {
        return DurationUnit.fromValue(durationUnit);
    }

    /**
     * <p>
     * Specifies the calendar interval unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnit} will
     * return {@link DurationUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #durationUnitAsString}.
     * </p>
     * 
     * @return Specifies the calendar interval unit.
     * @see DurationUnit
     */
    public final String durationUnitAsString() {
        return durationUnit;
    }

    /**
     * <p>
     * Specifies the duration of each calendar interval. For example, if <code>Duration</code> is <code>1</code> and
     * <code>DurationUnit</code> is <code>MONTH</code>, each interval is one month, aligned with the calendar.
     * </p>
     * 
     * @return Specifies the duration of each calendar interval. For example, if <code>Duration</code> is <code>1</code>
     *         and <code>DurationUnit</code> is <code>MONTH</code>, each interval is one month, aligned with the
     *         calendar.
     */
    public final Integer duration() {
        return duration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(durationUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalendarInterval)) {
            return false;
        }
        CalendarInterval other = (CalendarInterval) obj;
        return Objects.equals(startTime(), other.startTime())
                && Objects.equals(durationUnitAsString(), other.durationUnitAsString())
                && Objects.equals(duration(), other.duration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalendarInterval").add("StartTime", startTime()).add("DurationUnit", durationUnitAsString())
                .add("Duration", duration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "DurationUnit":
            return Optional.ofNullable(clazz.cast(durationUnitAsString()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("DurationUnit", DURATION_UNIT_FIELD);
        map.put("Duration", DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalendarInterval, T> g) {
        return obj -> g.apply((CalendarInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalendarInterval> {
        /**
         * <p>
         * The date and time when you want the first interval to start. Be sure to choose a time that configures the
         * intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be
         * sure to specify a start time that is a Monday at 6 a.m.
         * </p>
         * <p>
         * When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
         * <code>1698778057</code>
         * </p>
         * <p>
         * As soon as one calendar interval ends, another automatically begins.
         * </p>
         * 
         * @param startTime
         *        The date and time when you want the first interval to start. Be sure to choose a time that configures
         *        the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at
         *        6 a.m., be sure to specify a start time that is a Monday at 6 a.m.</p>
         *        <p>
         *        When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example:
         *        <code>1698778057</code>
         *        </p>
         *        <p>
         *        As soon as one calendar interval ends, another automatically begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Specifies the calendar interval unit.
         * </p>
         * 
         * @param durationUnit
         *        Specifies the calendar interval unit.
         * @see DurationUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DurationUnit
         */
        Builder durationUnit(String durationUnit);

        /**
         * <p>
         * Specifies the calendar interval unit.
         * </p>
         * 
         * @param durationUnit
         *        Specifies the calendar interval unit.
         * @see DurationUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DurationUnit
         */
        Builder durationUnit(DurationUnit durationUnit);

        /**
         * <p>
         * Specifies the duration of each calendar interval. For example, if <code>Duration</code> is <code>1</code> and
         * <code>DurationUnit</code> is <code>MONTH</code>, each interval is one month, aligned with the calendar.
         * </p>
         * 
         * @param duration
         *        Specifies the duration of each calendar interval. For example, if <code>Duration</code> is
         *        <code>1</code> and <code>DurationUnit</code> is <code>MONTH</code>, each interval is one month,
         *        aligned with the calendar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private String durationUnit;

        private Integer duration;

        private BuilderImpl() {
        }

        private BuilderImpl(CalendarInterval model) {
            startTime(model.startTime);
            durationUnit(model.durationUnit);
            duration(model.duration);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getDurationUnit() {
            return durationUnit;
        }

        public final void setDurationUnit(String durationUnit) {
            this.durationUnit = durationUnit;
        }

        @Override
        public final Builder durationUnit(String durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        @Override
        public final Builder durationUnit(DurationUnit durationUnit) {
            this.durationUnit(durationUnit == null ? null : durationUnit.toString());
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public CalendarInterval build() {
            return new CalendarInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
