/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetServiceLevelObjectiveBudgetReportResponse extends ApplicationSignalsResponse
        implements
        ToCopyableBuilder<BatchGetServiceLevelObjectiveBudgetReportResponse.Builder, BatchGetServiceLevelObjectiveBudgetReportResponse> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(BatchGetServiceLevelObjectiveBudgetReportResponse::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<List<ServiceLevelObjectiveBudgetReport>> REPORTS_FIELD = SdkField
            .<List<ServiceLevelObjectiveBudgetReport>> builder(MarshallingType.LIST)
            .memberName("Reports")
            .getter(getter(BatchGetServiceLevelObjectiveBudgetReportResponse::reports))
            .setter(setter(Builder::reports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceLevelObjectiveBudgetReport> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceLevelObjectiveBudgetReport::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceLevelObjectiveBudgetReportError>> ERRORS_FIELD = SdkField
            .<List<ServiceLevelObjectiveBudgetReportError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetServiceLevelObjectiveBudgetReportResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceLevelObjectiveBudgetReportError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceLevelObjectiveBudgetReportError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            REPORTS_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant timestamp;

    private final List<ServiceLevelObjectiveBudgetReport> reports;

    private final List<ServiceLevelObjectiveBudgetReportError> errors;

    private BatchGetServiceLevelObjectiveBudgetReportResponse(BuilderImpl builder) {
        super(builder);
        this.timestamp = builder.timestamp;
        this.reports = builder.reports;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The date and time that the report is for. It is expressed as the number of milliseconds since Jan 1, 1970
     * 00:00:00 UTC.
     * </p>
     * 
     * @return The date and time that the report is for. It is expressed as the number of milliseconds since Jan 1, 1970
     *         00:00:00 UTC.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Reports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReports() {
        return reports != null && !(reports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure is one budget report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReports} method.
     * </p>
     * 
     * @return An array of structures, where each structure is one budget report.
     */
    public final List<ServiceLevelObjectiveBudgetReport> reports() {
        return reports;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure includes an error indicating that one of the requests in the array
     * was not valid.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return An array of structures, where each structure includes an error indicating that one of the requests in the
     *         array was not valid.
     */
    public final List<ServiceLevelObjectiveBudgetReportError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasReports() ? reports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetServiceLevelObjectiveBudgetReportResponse)) {
            return false;
        }
        BatchGetServiceLevelObjectiveBudgetReportResponse other = (BatchGetServiceLevelObjectiveBudgetReportResponse) obj;
        return Objects.equals(timestamp(), other.timestamp()) && hasReports() == other.hasReports()
                && Objects.equals(reports(), other.reports()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetServiceLevelObjectiveBudgetReportResponse").add("Timestamp", timestamp())
                .add("Reports", hasReports() ? reports() : null).add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Reports":
            return Optional.ofNullable(clazz.cast(reports()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("Reports", REPORTS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetServiceLevelObjectiveBudgetReportResponse, T> g) {
        return obj -> g.apply((BatchGetServiceLevelObjectiveBudgetReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetServiceLevelObjectiveBudgetReportResponse> {
        /**
         * <p>
         * The date and time that the report is for. It is expressed as the number of milliseconds since Jan 1, 1970
         * 00:00:00 UTC.
         * </p>
         * 
         * @param timestamp
         *        The date and time that the report is for. It is expressed as the number of milliseconds since Jan 1,
         *        1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * An array of structures, where each structure is one budget report.
         * </p>
         * 
         * @param reports
         *        An array of structures, where each structure is one budget report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(Collection<ServiceLevelObjectiveBudgetReport> reports);

        /**
         * <p>
         * An array of structures, where each structure is one budget report.
         * </p>
         * 
         * @param reports
         *        An array of structures, where each structure is one budget report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(ServiceLevelObjectiveBudgetReport... reports);

        /**
         * <p>
         * An array of structures, where each structure is one budget report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReport.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReport.Builder#build()}
         * is called immediately and its result is passed to {@link #reports(List<ServiceLevelObjectiveBudgetReport>)}.
         * 
         * @param reports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reports(java.util.Collection<ServiceLevelObjectiveBudgetReport>)
         */
        Builder reports(Consumer<ServiceLevelObjectiveBudgetReport.Builder>... reports);

        /**
         * <p>
         * An array of structures, where each structure includes an error indicating that one of the requests in the
         * array was not valid.
         * </p>
         * 
         * @param errors
         *        An array of structures, where each structure includes an error indicating that one of the requests in
         *        the array was not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<ServiceLevelObjectiveBudgetReportError> errors);

        /**
         * <p>
         * An array of structures, where each structure includes an error indicating that one of the requests in the
         * array was not valid.
         * </p>
         * 
         * @param errors
         *        An array of structures, where each structure includes an error indicating that one of the requests in
         *        the array was not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(ServiceLevelObjectiveBudgetReportError... errors);

        /**
         * <p>
         * An array of structures, where each structure includes an error indicating that one of the requests in the
         * array was not valid.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReportError.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReportError#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReportError.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errors(List<ServiceLevelObjectiveBudgetReportError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReportError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<ServiceLevelObjectiveBudgetReportError>)
         */
        Builder errors(Consumer<ServiceLevelObjectiveBudgetReportError.Builder>... errors);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private Instant timestamp;

        private List<ServiceLevelObjectiveBudgetReport> reports = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceLevelObjectiveBudgetReportError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetServiceLevelObjectiveBudgetReportResponse model) {
            super(model);
            timestamp(model.timestamp);
            reports(model.reports);
            errors(model.errors);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final List<ServiceLevelObjectiveBudgetReport.Builder> getReports() {
            List<ServiceLevelObjectiveBudgetReport.Builder> result = ServiceLevelObjectiveBudgetReportsCopier
                    .copyToBuilder(this.reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReports(Collection<ServiceLevelObjectiveBudgetReport.BuilderImpl> reports) {
            this.reports = ServiceLevelObjectiveBudgetReportsCopier.copyFromBuilder(reports);
        }

        @Override
        public final Builder reports(Collection<ServiceLevelObjectiveBudgetReport> reports) {
            this.reports = ServiceLevelObjectiveBudgetReportsCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(ServiceLevelObjectiveBudgetReport... reports) {
            reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Consumer<ServiceLevelObjectiveBudgetReport.Builder>... reports) {
            reports(Stream.of(reports).map(c -> ServiceLevelObjectiveBudgetReport.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceLevelObjectiveBudgetReportError.Builder> getErrors() {
            List<ServiceLevelObjectiveBudgetReportError.Builder> result = ServiceLevelObjectiveBudgetReportErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ServiceLevelObjectiveBudgetReportError.BuilderImpl> errors) {
            this.errors = ServiceLevelObjectiveBudgetReportErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ServiceLevelObjectiveBudgetReportError> errors) {
            this.errors = ServiceLevelObjectiveBudgetReportErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ServiceLevelObjectiveBudgetReportError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ServiceLevelObjectiveBudgetReportError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> ServiceLevelObjectiveBudgetReportError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetServiceLevelObjectiveBudgetReportResponse build() {
            return new BatchGetServiceLevelObjectiveBudgetReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
