/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A union structure that contains the specific entity information for different types of audit targets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditTargetEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditTargetEntity.Builder, AuditTargetEntity> {
    private static final SdkField<ServiceEntity> SERVICE_FIELD = SdkField.<ServiceEntity> builder(MarshallingType.SDK_POJO)
            .memberName("Service").getter(getter(AuditTargetEntity::service)).setter(setter(Builder::service))
            .constructor(ServiceEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<ServiceLevelObjectiveEntity> SLO_FIELD = SdkField
            .<ServiceLevelObjectiveEntity> builder(MarshallingType.SDK_POJO).memberName("Slo")
            .getter(getter(AuditTargetEntity::slo)).setter(setter(Builder::slo))
            .constructor(ServiceLevelObjectiveEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slo").build()).build();

    private static final SdkField<ServiceOperationEntity> SERVICE_OPERATION_FIELD = SdkField
            .<ServiceOperationEntity> builder(MarshallingType.SDK_POJO).memberName("ServiceOperation")
            .getter(getter(AuditTargetEntity::serviceOperation)).setter(setter(Builder::serviceOperation))
            .constructor(ServiceOperationEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceOperation").build()).build();

    private static final SdkField<CanaryEntity> CANARY_FIELD = SdkField.<CanaryEntity> builder(MarshallingType.SDK_POJO)
            .memberName("Canary").getter(getter(AuditTargetEntity::canary)).setter(setter(Builder::canary))
            .constructor(CanaryEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Canary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, SLO_FIELD,
            SERVICE_OPERATION_FIELD, CANARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceEntity service;

    private final ServiceLevelObjectiveEntity slo;

    private final ServiceOperationEntity serviceOperation;

    private final CanaryEntity canary;

    private final Type type;

    private AuditTargetEntity(BuilderImpl builder) {
        this.service = builder.service;
        this.slo = builder.slo;
        this.serviceOperation = builder.serviceOperation;
        this.canary = builder.canary;
        this.type = builder.type;
    }

    /**
     * <p>
     * Service entity information when the audit target is a service.
     * </p>
     * 
     * @return Service entity information when the audit target is a service.
     */
    public final ServiceEntity service() {
        return service;
    }

    /**
     * <p>
     * SLO entity information when the audit target is a service level objective.
     * </p>
     * 
     * @return SLO entity information when the audit target is a service level objective.
     */
    public final ServiceLevelObjectiveEntity slo() {
        return slo;
    }

    /**
     * <p>
     * Service operation entity information when the audit target is a specific service operation.
     * </p>
     * 
     * @return Service operation entity information when the audit target is a specific service operation.
     */
    public final ServiceOperationEntity serviceOperation() {
        return serviceOperation;
    }

    /**
     * <p>
     * Canary entity information when the audit target is a CloudWatch Synthetics canary.
     * </p>
     * 
     * @return Canary entity information when the audit target is a CloudWatch Synthetics canary.
     */
    public final CanaryEntity canary() {
        return canary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(slo());
        hashCode = 31 * hashCode + Objects.hashCode(serviceOperation());
        hashCode = 31 * hashCode + Objects.hashCode(canary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditTargetEntity)) {
            return false;
        }
        AuditTargetEntity other = (AuditTargetEntity) obj;
        return Objects.equals(service(), other.service()) && Objects.equals(slo(), other.slo())
                && Objects.equals(serviceOperation(), other.serviceOperation()) && Objects.equals(canary(), other.canary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditTargetEntity").add("Service", service()).add("Slo", slo())
                .add("ServiceOperation", serviceOperation()).add("Canary", canary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "Slo":
            return Optional.ofNullable(clazz.cast(slo()));
        case "ServiceOperation":
            return Optional.ofNullable(clazz.cast(serviceOperation()));
        case "Canary":
            return Optional.ofNullable(clazz.cast(canary()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #service()} initialized to the given value.
     *
     * <p>
     * Service entity information when the audit target is a service.
     * </p>
     * 
     * @param service
     *        Service entity information when the audit target is a service.
     */
    public static AuditTargetEntity fromService(ServiceEntity service) {
        return builder().service(service).build();
    }

    /**
     * Create an instance of this class with {@link #service()} initialized to the given value.
     *
     * <p>
     * Service entity information when the audit target is a service.
     * </p>
     * 
     * @param service
     *        Service entity information when the audit target is a service.
     */
    public static AuditTargetEntity fromService(Consumer<ServiceEntity.Builder> service) {
        ServiceEntity.Builder builder = ServiceEntity.builder();
        service.accept(builder);
        return fromService(builder.build());
    }

    /**
     * Create an instance of this class with {@link #slo()} initialized to the given value.
     *
     * <p>
     * SLO entity information when the audit target is a service level objective.
     * </p>
     * 
     * @param slo
     *        SLO entity information when the audit target is a service level objective.
     */
    public static AuditTargetEntity fromSlo(ServiceLevelObjectiveEntity slo) {
        return builder().slo(slo).build();
    }

    /**
     * Create an instance of this class with {@link #slo()} initialized to the given value.
     *
     * <p>
     * SLO entity information when the audit target is a service level objective.
     * </p>
     * 
     * @param slo
     *        SLO entity information when the audit target is a service level objective.
     */
    public static AuditTargetEntity fromSlo(Consumer<ServiceLevelObjectiveEntity.Builder> slo) {
        ServiceLevelObjectiveEntity.Builder builder = ServiceLevelObjectiveEntity.builder();
        slo.accept(builder);
        return fromSlo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #serviceOperation()} initialized to the given value.
     *
     * <p>
     * Service operation entity information when the audit target is a specific service operation.
     * </p>
     * 
     * @param serviceOperation
     *        Service operation entity information when the audit target is a specific service operation.
     */
    public static AuditTargetEntity fromServiceOperation(ServiceOperationEntity serviceOperation) {
        return builder().serviceOperation(serviceOperation).build();
    }

    /**
     * Create an instance of this class with {@link #serviceOperation()} initialized to the given value.
     *
     * <p>
     * Service operation entity information when the audit target is a specific service operation.
     * </p>
     * 
     * @param serviceOperation
     *        Service operation entity information when the audit target is a specific service operation.
     */
    public static AuditTargetEntity fromServiceOperation(Consumer<ServiceOperationEntity.Builder> serviceOperation) {
        ServiceOperationEntity.Builder builder = ServiceOperationEntity.builder();
        serviceOperation.accept(builder);
        return fromServiceOperation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #canary()} initialized to the given value.
     *
     * <p>
     * Canary entity information when the audit target is a CloudWatch Synthetics canary.
     * </p>
     * 
     * @param canary
     *        Canary entity information when the audit target is a CloudWatch Synthetics canary.
     */
    public static AuditTargetEntity fromCanary(CanaryEntity canary) {
        return builder().canary(canary).build();
    }

    /**
     * Create an instance of this class with {@link #canary()} initialized to the given value.
     *
     * <p>
     * Canary entity information when the audit target is a CloudWatch Synthetics canary.
     * </p>
     * 
     * @param canary
     *        Canary entity information when the audit target is a CloudWatch Synthetics canary.
     */
    public static AuditTargetEntity fromCanary(Consumer<CanaryEntity.Builder> canary) {
        CanaryEntity.Builder builder = CanaryEntity.builder();
        canary.accept(builder);
        return fromCanary(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Service", SERVICE_FIELD);
        map.put("Slo", SLO_FIELD);
        map.put("ServiceOperation", SERVICE_OPERATION_FIELD);
        map.put("Canary", CANARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditTargetEntity, T> g) {
        return obj -> g.apply((AuditTargetEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditTargetEntity> {
        /**
         * <p>
         * Service entity information when the audit target is a service.
         * </p>
         * 
         * @param service
         *        Service entity information when the audit target is a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(ServiceEntity service);

        /**
         * <p>
         * Service entity information when the audit target is a service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceEntity.Builder} avoiding the need
         * to create one manually via {@link ServiceEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceEntity.Builder#build()} is called immediately and its
         * result is passed to {@link #service(ServiceEntity)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link ServiceEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(ServiceEntity)
         */
        default Builder service(Consumer<ServiceEntity.Builder> service) {
            return service(ServiceEntity.builder().applyMutation(service).build());
        }

        /**
         * <p>
         * SLO entity information when the audit target is a service level objective.
         * </p>
         * 
         * @param slo
         *        SLO entity information when the audit target is a service level objective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slo(ServiceLevelObjectiveEntity slo);

        /**
         * <p>
         * SLO entity information when the audit target is a service level objective.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceLevelObjectiveEntity.Builder}
         * avoiding the need to create one manually via {@link ServiceLevelObjectiveEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLevelObjectiveEntity.Builder#build()} is called
         * immediately and its result is passed to {@link #slo(ServiceLevelObjectiveEntity)}.
         * 
         * @param slo
         *        a consumer that will call methods on {@link ServiceLevelObjectiveEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slo(ServiceLevelObjectiveEntity)
         */
        default Builder slo(Consumer<ServiceLevelObjectiveEntity.Builder> slo) {
            return slo(ServiceLevelObjectiveEntity.builder().applyMutation(slo).build());
        }

        /**
         * <p>
         * Service operation entity information when the audit target is a specific service operation.
         * </p>
         * 
         * @param serviceOperation
         *        Service operation entity information when the audit target is a specific service operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceOperation(ServiceOperationEntity serviceOperation);

        /**
         * <p>
         * Service operation entity information when the audit target is a specific service operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceOperationEntity.Builder} avoiding
         * the need to create one manually via {@link ServiceOperationEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceOperationEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceOperation(ServiceOperationEntity)}.
         * 
         * @param serviceOperation
         *        a consumer that will call methods on {@link ServiceOperationEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceOperation(ServiceOperationEntity)
         */
        default Builder serviceOperation(Consumer<ServiceOperationEntity.Builder> serviceOperation) {
            return serviceOperation(ServiceOperationEntity.builder().applyMutation(serviceOperation).build());
        }

        /**
         * <p>
         * Canary entity information when the audit target is a CloudWatch Synthetics canary.
         * </p>
         * 
         * @param canary
         *        Canary entity information when the audit target is a CloudWatch Synthetics canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canary(CanaryEntity canary);

        /**
         * <p>
         * Canary entity information when the audit target is a CloudWatch Synthetics canary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CanaryEntity.Builder} avoiding the need
         * to create one manually via {@link CanaryEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CanaryEntity.Builder#build()} is called immediately and its
         * result is passed to {@link #canary(CanaryEntity)}.
         * 
         * @param canary
         *        a consumer that will call methods on {@link CanaryEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canary(CanaryEntity)
         */
        default Builder canary(Consumer<CanaryEntity.Builder> canary) {
            return canary(CanaryEntity.builder().applyMutation(canary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceEntity service;

        private ServiceLevelObjectiveEntity slo;

        private ServiceOperationEntity serviceOperation;

        private CanaryEntity canary;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AuditTargetEntity model) {
            service(model.service);
            slo(model.slo);
            serviceOperation(model.serviceOperation);
            canary(model.canary);
        }

        public final ServiceEntity.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        public final void setService(ServiceEntity.BuilderImpl service) {
            Object oldValue = this.service;
            this.service = service != null ? service.build() : null;
            handleUnionValueChange(Type.SERVICE, oldValue, this.service);
        }

        @Override
        public final Builder service(ServiceEntity service) {
            Object oldValue = this.service;
            this.service = service;
            handleUnionValueChange(Type.SERVICE, oldValue, this.service);
            return this;
        }

        public final ServiceLevelObjectiveEntity.Builder getSlo() {
            return slo != null ? slo.toBuilder() : null;
        }

        public final void setSlo(ServiceLevelObjectiveEntity.BuilderImpl slo) {
            Object oldValue = this.slo;
            this.slo = slo != null ? slo.build() : null;
            handleUnionValueChange(Type.SLO, oldValue, this.slo);
        }

        @Override
        public final Builder slo(ServiceLevelObjectiveEntity slo) {
            Object oldValue = this.slo;
            this.slo = slo;
            handleUnionValueChange(Type.SLO, oldValue, this.slo);
            return this;
        }

        public final ServiceOperationEntity.Builder getServiceOperation() {
            return serviceOperation != null ? serviceOperation.toBuilder() : null;
        }

        public final void setServiceOperation(ServiceOperationEntity.BuilderImpl serviceOperation) {
            Object oldValue = this.serviceOperation;
            this.serviceOperation = serviceOperation != null ? serviceOperation.build() : null;
            handleUnionValueChange(Type.SERVICE_OPERATION, oldValue, this.serviceOperation);
        }

        @Override
        public final Builder serviceOperation(ServiceOperationEntity serviceOperation) {
            Object oldValue = this.serviceOperation;
            this.serviceOperation = serviceOperation;
            handleUnionValueChange(Type.SERVICE_OPERATION, oldValue, this.serviceOperation);
            return this;
        }

        public final CanaryEntity.Builder getCanary() {
            return canary != null ? canary.toBuilder() : null;
        }

        public final void setCanary(CanaryEntity.BuilderImpl canary) {
            Object oldValue = this.canary;
            this.canary = canary != null ? canary.build() : null;
            handleUnionValueChange(Type.CANARY, oldValue, this.canary);
        }

        @Override
        public final Builder canary(CanaryEntity canary) {
            Object oldValue = this.canary;
            this.canary = canary;
            handleUnionValueChange(Type.CANARY, oldValue, this.canary);
            return this;
        }

        @Override
        public AuditTargetEntity build() {
            return new AuditTargetEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AuditTargetEntity#type()
     */
    public enum Type {
        SERVICE,

        SLO,

        SERVICE_OPERATION,

        CANARY,

        UNKNOWN_TO_SDK_VERSION
    }
}
