/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributeFilter;
import software.amazon.awssdk.services.applicationsignals.model.AttributeFiltersCopier;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.ChangeEvent;
import software.amazon.awssdk.services.applicationsignals.model.LatestChangeEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceState> {
    private static final SdkField<List<AttributeFilter>> ATTRIBUTE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeFilters").getter(ServiceState.getter(ServiceState::attributeFilters)).setter(ServiceState.setter(Builder::attributeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Service").getter(ServiceState.getter(ServiceState::service)).setter(ServiceState.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ChangeEvent>> LATEST_CHANGE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LatestChangeEvents").getter(ServiceState.getter(ServiceState::latestChangeEvents)).setter(ServiceState.setter(Builder::latestChangeEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestChangeEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FILTERS_FIELD, SERVICE_FIELD, LATEST_CHANGE_EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AttributeFilter> attributeFilters;
    private final Map<String, String> service;
    private final List<ChangeEvent> latestChangeEvents;

    private ServiceState(BuilderImpl builder) {
        this.attributeFilters = builder.attributeFilters;
        this.service = builder.service;
        this.latestChangeEvents = builder.latestChangeEvents;
    }

    public final boolean hasAttributeFilters() {
        return this.attributeFilters != null && !(this.attributeFilters instanceof SdkAutoConstructList);
    }

    public final List<AttributeFilter> attributeFilters() {
        return this.attributeFilters;
    }

    public final boolean hasService() {
        return this.service != null && !(this.service instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> service() {
        return this.service;
    }

    public final boolean hasLatestChangeEvents() {
        return this.latestChangeEvents != null && !(this.latestChangeEvents instanceof SdkAutoConstructList);
    }

    public final List<ChangeEvent> latestChangeEvents() {
        return this.latestChangeEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeFilters() ? this.attributeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasService() ? this.service() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLatestChangeEvents() ? this.latestChangeEvents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceState)) {
            return false;
        }
        ServiceState other = (ServiceState)obj;
        return this.hasAttributeFilters() == other.hasAttributeFilters() && Objects.equals(this.attributeFilters(), other.attributeFilters()) && this.hasService() == other.hasService() && Objects.equals(this.service(), other.service()) && this.hasLatestChangeEvents() == other.hasLatestChangeEvents() && Objects.equals(this.latestChangeEvents(), other.latestChangeEvents());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceState").add("AttributeFilters", this.hasAttributeFilters() ? this.attributeFilters() : null).add("Service", this.hasService() ? this.service() : null).add("LatestChangeEvents", this.hasLatestChangeEvents() ? this.latestChangeEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeFilters": {
                return Optional.ofNullable(clazz.cast(this.attributeFilters()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "LatestChangeEvents": {
                return Optional.ofNullable(clazz.cast(this.latestChangeEvents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttributeFilters", ATTRIBUTE_FILTERS_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("LatestChangeEvents", LATEST_CHANGE_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceState, T> g) {
        return obj -> g.apply((ServiceState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeFilter> attributeFilters = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> service = DefaultSdkAutoConstructMap.getInstance();
        private List<ChangeEvent> latestChangeEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceState model) {
            this.attributeFilters(model.attributeFilters);
            this.service(model.service);
            this.latestChangeEvents(model.latestChangeEvents);
        }

        public final List<AttributeFilter.Builder> getAttributeFilters() {
            List<AttributeFilter.Builder> result = AttributeFiltersCopier.copyToBuilder(this.attributeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeFilters(Collection<AttributeFilter.BuilderImpl> attributeFilters) {
            this.attributeFilters = AttributeFiltersCopier.copyFromBuilder(attributeFilters);
        }

        @Override
        public final Builder attributeFilters(Collection<AttributeFilter> attributeFilters) {
            this.attributeFilters = AttributeFiltersCopier.copy(attributeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeFilters(AttributeFilter ... attributeFilters) {
            this.attributeFilters(Arrays.asList(attributeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeFilters(Consumer<AttributeFilter.Builder> ... attributeFilters) {
            this.attributeFilters(Stream.of(attributeFilters).map(c -> (AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getService() {
            if (this.service instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.service;
        }

        public final void setService(Map<String, String> service) {
            this.service = AttributesCopier.copy(service);
        }

        @Override
        public final Builder service(Map<String, String> service) {
            this.service = AttributesCopier.copy(service);
            return this;
        }

        public final List<ChangeEvent.Builder> getLatestChangeEvents() {
            List<ChangeEvent.Builder> result = LatestChangeEventsCopier.copyToBuilder(this.latestChangeEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestChangeEvents(Collection<ChangeEvent.BuilderImpl> latestChangeEvents) {
            this.latestChangeEvents = LatestChangeEventsCopier.copyFromBuilder(latestChangeEvents);
        }

        @Override
        public final Builder latestChangeEvents(Collection<ChangeEvent> latestChangeEvents) {
            this.latestChangeEvents = LatestChangeEventsCopier.copy(latestChangeEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestChangeEvents(ChangeEvent ... latestChangeEvents) {
            this.latestChangeEvents(Arrays.asList(latestChangeEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestChangeEvents(Consumer<ChangeEvent.Builder> ... latestChangeEvents) {
            this.latestChangeEvents(Stream.of(latestChangeEvents).map(c -> (ChangeEvent)((ChangeEvent.Builder)ChangeEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceState build() {
            return new ServiceState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceState> {
        public Builder attributeFilters(Collection<AttributeFilter> var1);

        public Builder attributeFilters(AttributeFilter ... var1);

        public Builder attributeFilters(Consumer<AttributeFilter.Builder> ... var1);

        public Builder service(Map<String, String> var1);

        public Builder latestChangeEvents(Collection<ChangeEvent> var1);

        public Builder latestChangeEvents(ChangeEvent ... var1);

        public Builder latestChangeEvents(Consumer<ChangeEvent.Builder> ... var1);
    }
}

