/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsRequest;
import software.amazon.awssdk.services.applicationsignals.model.BurnRateConfiguration;
import software.amazon.awssdk.services.applicationsignals.model.BurnRateConfigurationsCopier;
import software.amazon.awssdk.services.applicationsignals.model.Goal;
import software.amazon.awssdk.services.applicationsignals.model.RequestBasedServiceLevelIndicatorConfig;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceLevelObjectiveRequest
extends ApplicationSignalsRequest
implements ToCopyableBuilder<Builder, UpdateServiceLevelObjectiveRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateServiceLevelObjectiveRequest.getter(UpdateServiceLevelObjectiveRequest::id)).setter(UpdateServiceLevelObjectiveRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateServiceLevelObjectiveRequest.getter(UpdateServiceLevelObjectiveRequest::description)).setter(UpdateServiceLevelObjectiveRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ServiceLevelIndicatorConfig> SLI_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SliConfig").getter(UpdateServiceLevelObjectiveRequest.getter(UpdateServiceLevelObjectiveRequest::sliConfig)).setter(UpdateServiceLevelObjectiveRequest.setter(Builder::sliConfig)).constructor(ServiceLevelIndicatorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SliConfig").build()}).build();
    private static final SdkField<RequestBasedServiceLevelIndicatorConfig> REQUEST_BASED_SLI_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestBasedSliConfig").getter(UpdateServiceLevelObjectiveRequest.getter(UpdateServiceLevelObjectiveRequest::requestBasedSliConfig)).setter(UpdateServiceLevelObjectiveRequest.setter(Builder::requestBasedSliConfig)).constructor(RequestBasedServiceLevelIndicatorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSliConfig").build()}).build();
    private static final SdkField<Goal> GOAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Goal").getter(UpdateServiceLevelObjectiveRequest.getter(UpdateServiceLevelObjectiveRequest::goal)).setter(UpdateServiceLevelObjectiveRequest.setter(Builder::goal)).constructor(Goal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Goal").build()}).build();
    private static final SdkField<List<BurnRateConfiguration>> BURN_RATE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BurnRateConfigurations").getter(UpdateServiceLevelObjectiveRequest.getter(UpdateServiceLevelObjectiveRequest::burnRateConfigurations)).setter(UpdateServiceLevelObjectiveRequest.setter(Builder::burnRateConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BurnRateConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BurnRateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD, SLI_CONFIG_FIELD, REQUEST_BASED_SLI_CONFIG_FIELD, GOAL_FIELD, BURN_RATE_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServiceLevelObjectiveRequest.memberNameToFieldInitializer();
    private final String id;
    private final String description;
    private final ServiceLevelIndicatorConfig sliConfig;
    private final RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig;
    private final Goal goal;
    private final List<BurnRateConfiguration> burnRateConfigurations;

    private UpdateServiceLevelObjectiveRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.sliConfig = builder.sliConfig;
        this.requestBasedSliConfig = builder.requestBasedSliConfig;
        this.goal = builder.goal;
        this.burnRateConfigurations = builder.burnRateConfigurations;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final ServiceLevelIndicatorConfig sliConfig() {
        return this.sliConfig;
    }

    public final RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig() {
        return this.requestBasedSliConfig;
    }

    public final Goal goal() {
        return this.goal;
    }

    public final boolean hasBurnRateConfigurations() {
        return this.burnRateConfigurations != null && !(this.burnRateConfigurations instanceof SdkAutoConstructList);
    }

    public final List<BurnRateConfiguration> burnRateConfigurations() {
        return this.burnRateConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sliConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestBasedSliConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.goal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBurnRateConfigurations() ? this.burnRateConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceLevelObjectiveRequest)) {
            return false;
        }
        UpdateServiceLevelObjectiveRequest other = (UpdateServiceLevelObjectiveRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sliConfig(), other.sliConfig()) && Objects.equals(this.requestBasedSliConfig(), other.requestBasedSliConfig()) && Objects.equals(this.goal(), other.goal()) && this.hasBurnRateConfigurations() == other.hasBurnRateConfigurations() && Objects.equals(this.burnRateConfigurations(), other.burnRateConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceLevelObjectiveRequest").add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("SliConfig", (Object)this.sliConfig()).add("RequestBasedSliConfig", (Object)this.requestBasedSliConfig()).add("Goal", (Object)this.goal()).add("BurnRateConfigurations", this.hasBurnRateConfigurations() ? this.burnRateConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SliConfig": {
                return Optional.ofNullable(clazz.cast(this.sliConfig()));
            }
            case "RequestBasedSliConfig": {
                return Optional.ofNullable(clazz.cast(this.requestBasedSliConfig()));
            }
            case "Goal": {
                return Optional.ofNullable(clazz.cast(this.goal()));
            }
            case "BurnRateConfigurations": {
                return Optional.ofNullable(clazz.cast(this.burnRateConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SliConfig", SLI_CONFIG_FIELD);
        map.put("RequestBasedSliConfig", REQUEST_BASED_SLI_CONFIG_FIELD);
        map.put("Goal", GOAL_FIELD);
        map.put("BurnRateConfigurations", BURN_RATE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceLevelObjectiveRequest, T> g) {
        return obj -> g.apply((UpdateServiceLevelObjectiveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsRequest.BuilderImpl
    implements Builder {
        private String id;
        private String description;
        private ServiceLevelIndicatorConfig sliConfig;
        private RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig;
        private Goal goal;
        private List<BurnRateConfiguration> burnRateConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceLevelObjectiveRequest model) {
            super(model);
            this.id(model.id);
            this.description(model.description);
            this.sliConfig(model.sliConfig);
            this.requestBasedSliConfig(model.requestBasedSliConfig);
            this.goal(model.goal);
            this.burnRateConfigurations(model.burnRateConfigurations);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ServiceLevelIndicatorConfig.Builder getSliConfig() {
            return this.sliConfig != null ? this.sliConfig.toBuilder() : null;
        }

        public final void setSliConfig(ServiceLevelIndicatorConfig.BuilderImpl sliConfig) {
            this.sliConfig = sliConfig != null ? sliConfig.build() : null;
        }

        @Override
        public final Builder sliConfig(ServiceLevelIndicatorConfig sliConfig) {
            this.sliConfig = sliConfig;
            return this;
        }

        public final RequestBasedServiceLevelIndicatorConfig.Builder getRequestBasedSliConfig() {
            return this.requestBasedSliConfig != null ? this.requestBasedSliConfig.toBuilder() : null;
        }

        public final void setRequestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig.BuilderImpl requestBasedSliConfig) {
            this.requestBasedSliConfig = requestBasedSliConfig != null ? requestBasedSliConfig.build() : null;
        }

        @Override
        public final Builder requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig) {
            this.requestBasedSliConfig = requestBasedSliConfig;
            return this;
        }

        public final Goal.Builder getGoal() {
            return this.goal != null ? this.goal.toBuilder() : null;
        }

        public final void setGoal(Goal.BuilderImpl goal) {
            this.goal = goal != null ? goal.build() : null;
        }

        @Override
        public final Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public final List<BurnRateConfiguration.Builder> getBurnRateConfigurations() {
            List<BurnRateConfiguration.Builder> result = BurnRateConfigurationsCopier.copyToBuilder(this.burnRateConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBurnRateConfigurations(Collection<BurnRateConfiguration.BuilderImpl> burnRateConfigurations) {
            this.burnRateConfigurations = BurnRateConfigurationsCopier.copyFromBuilder(burnRateConfigurations);
        }

        @Override
        public final Builder burnRateConfigurations(Collection<BurnRateConfiguration> burnRateConfigurations) {
            this.burnRateConfigurations = BurnRateConfigurationsCopier.copy(burnRateConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder burnRateConfigurations(BurnRateConfiguration ... burnRateConfigurations) {
            this.burnRateConfigurations(Arrays.asList(burnRateConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder burnRateConfigurations(Consumer<BurnRateConfiguration.Builder> ... burnRateConfigurations) {
            this.burnRateConfigurations(Stream.of(burnRateConfigurations).map(c -> (BurnRateConfiguration)((BurnRateConfiguration.Builder)BurnRateConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceLevelObjectiveRequest build() {
            return new UpdateServiceLevelObjectiveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceLevelObjectiveRequest> {
        public Builder id(String var1);

        public Builder description(String var1);

        public Builder sliConfig(ServiceLevelIndicatorConfig var1);

        default public Builder sliConfig(Consumer<ServiceLevelIndicatorConfig.Builder> sliConfig) {
            return this.sliConfig((ServiceLevelIndicatorConfig)((ServiceLevelIndicatorConfig.Builder)ServiceLevelIndicatorConfig.builder().applyMutation(sliConfig)).build());
        }

        public Builder requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig var1);

        default public Builder requestBasedSliConfig(Consumer<RequestBasedServiceLevelIndicatorConfig.Builder> requestBasedSliConfig) {
            return this.requestBasedSliConfig((RequestBasedServiceLevelIndicatorConfig)((RequestBasedServiceLevelIndicatorConfig.Builder)RequestBasedServiceLevelIndicatorConfig.builder().applyMutation(requestBasedSliConfig)).build());
        }

        public Builder goal(Goal var1);

        default public Builder goal(Consumer<Goal.Builder> goal) {
            return this.goal((Goal)((Goal.Builder)Goal.builder().applyMutation(goal)).build());
        }

        public Builder burnRateConfigurations(Collection<BurnRateConfiguration> var1);

        public Builder burnRateConfigurations(BurnRateConfiguration ... var1);

        public Builder burnRateConfigurations(Consumer<BurnRateConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

