/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.BurnRateConfiguration;
import software.amazon.awssdk.services.applicationsignals.model.BurnRateConfigurationsCopier;
import software.amazon.awssdk.services.applicationsignals.model.EvaluationType;
import software.amazon.awssdk.services.applicationsignals.model.Goal;
import software.amazon.awssdk.services.applicationsignals.model.MetricSourceType;
import software.amazon.awssdk.services.applicationsignals.model.RequestBasedServiceLevelIndicator;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLevelObjective
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLevelObjective> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ServiceLevelObjective.getter(ServiceLevelObjective::arn)).setter(ServiceLevelObjective.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ServiceLevelObjective.getter(ServiceLevelObjective::name)).setter(ServiceLevelObjective.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ServiceLevelObjective.getter(ServiceLevelObjective::description)).setter(ServiceLevelObjective.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ServiceLevelObjective.getter(ServiceLevelObjective::createdTime)).setter(ServiceLevelObjective.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(ServiceLevelObjective.getter(ServiceLevelObjective::lastUpdatedTime)).setter(ServiceLevelObjective.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<ServiceLevelIndicator> SLI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sli").getter(ServiceLevelObjective.getter(ServiceLevelObjective::sli)).setter(ServiceLevelObjective.setter(Builder::sli)).constructor(ServiceLevelIndicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sli").build()}).build();
    private static final SdkField<RequestBasedServiceLevelIndicator> REQUEST_BASED_SLI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestBasedSli").getter(ServiceLevelObjective.getter(ServiceLevelObjective::requestBasedSli)).setter(ServiceLevelObjective.setter(Builder::requestBasedSli)).constructor(RequestBasedServiceLevelIndicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSli").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationType").getter(ServiceLevelObjective.getter(ServiceLevelObjective::evaluationTypeAsString)).setter(ServiceLevelObjective.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<Goal> GOAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Goal").getter(ServiceLevelObjective.getter(ServiceLevelObjective::goal)).setter(ServiceLevelObjective.setter(Builder::goal)).constructor(Goal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Goal").build()}).build();
    private static final SdkField<List<BurnRateConfiguration>> BURN_RATE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BurnRateConfigurations").getter(ServiceLevelObjective.getter(ServiceLevelObjective::burnRateConfigurations)).setter(ServiceLevelObjective.setter(Builder::burnRateConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BurnRateConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BurnRateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSourceType").getter(ServiceLevelObjective.getter(ServiceLevelObjective::metricSourceTypeAsString)).setter(ServiceLevelObjective.setter(Builder::metricSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, SLI_FIELD, REQUEST_BASED_SLI_FIELD, EVALUATION_TYPE_FIELD, GOAL_FIELD, BURN_RATE_CONFIGURATIONS_FIELD, METRIC_SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceLevelObjective.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final ServiceLevelIndicator sli;
    private final RequestBasedServiceLevelIndicator requestBasedSli;
    private final String evaluationType;
    private final Goal goal;
    private final List<BurnRateConfiguration> burnRateConfigurations;
    private final String metricSourceType;

    private ServiceLevelObjective(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.sli = builder.sli;
        this.requestBasedSli = builder.requestBasedSli;
        this.evaluationType = builder.evaluationType;
        this.goal = builder.goal;
        this.burnRateConfigurations = builder.burnRateConfigurations;
        this.metricSourceType = builder.metricSourceType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final ServiceLevelIndicator sli() {
        return this.sli;
    }

    public final RequestBasedServiceLevelIndicator requestBasedSli() {
        return this.requestBasedSli;
    }

    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public final String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public final Goal goal() {
        return this.goal;
    }

    public final boolean hasBurnRateConfigurations() {
        return this.burnRateConfigurations != null && !(this.burnRateConfigurations instanceof SdkAutoConstructList);
    }

    public final List<BurnRateConfiguration> burnRateConfigurations() {
        return this.burnRateConfigurations;
    }

    public final MetricSourceType metricSourceType() {
        return MetricSourceType.fromValue(this.metricSourceType);
    }

    public final String metricSourceTypeAsString() {
        return this.metricSourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sli());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestBasedSli());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.goal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBurnRateConfigurations() ? this.burnRateConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelObjective)) {
            return false;
        }
        ServiceLevelObjective other = (ServiceLevelObjective)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.sli(), other.sli()) && Objects.equals(this.requestBasedSli(), other.requestBasedSli()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && Objects.equals(this.goal(), other.goal()) && this.hasBurnRateConfigurations() == other.hasBurnRateConfigurations() && Objects.equals(this.burnRateConfigurations(), other.burnRateConfigurations()) && Objects.equals(this.metricSourceTypeAsString(), other.metricSourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLevelObjective").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Sli", (Object)this.sli()).add("RequestBasedSli", (Object)this.requestBasedSli()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("Goal", (Object)this.goal()).add("BurnRateConfigurations", this.hasBurnRateConfigurations() ? this.burnRateConfigurations() : null).add("MetricSourceType", (Object)this.metricSourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Sli": {
                return Optional.ofNullable(clazz.cast(this.sli()));
            }
            case "RequestBasedSli": {
                return Optional.ofNullable(clazz.cast(this.requestBasedSli()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "Goal": {
                return Optional.ofNullable(clazz.cast(this.goal()));
            }
            case "BurnRateConfigurations": {
                return Optional.ofNullable(clazz.cast(this.burnRateConfigurations()));
            }
            case "MetricSourceType": {
                return Optional.ofNullable(clazz.cast(this.metricSourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Sli", SLI_FIELD);
        map.put("RequestBasedSli", REQUEST_BASED_SLI_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("Goal", GOAL_FIELD);
        map.put("BurnRateConfigurations", BURN_RATE_CONFIGURATIONS_FIELD);
        map.put("MetricSourceType", METRIC_SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelObjective, T> g) {
        return obj -> g.apply((ServiceLevelObjective)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private ServiceLevelIndicator sli;
        private RequestBasedServiceLevelIndicator requestBasedSli;
        private String evaluationType;
        private Goal goal;
        private List<BurnRateConfiguration> burnRateConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String metricSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelObjective model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.sli(model.sli);
            this.requestBasedSli(model.requestBasedSli);
            this.evaluationType(model.evaluationType);
            this.goal(model.goal);
            this.burnRateConfigurations(model.burnRateConfigurations);
            this.metricSourceType(model.metricSourceType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final ServiceLevelIndicator.Builder getSli() {
            return this.sli != null ? this.sli.toBuilder() : null;
        }

        public final void setSli(ServiceLevelIndicator.BuilderImpl sli) {
            this.sli = sli != null ? sli.build() : null;
        }

        @Override
        public final Builder sli(ServiceLevelIndicator sli) {
            this.sli = sli;
            return this;
        }

        public final RequestBasedServiceLevelIndicator.Builder getRequestBasedSli() {
            return this.requestBasedSli != null ? this.requestBasedSli.toBuilder() : null;
        }

        public final void setRequestBasedSli(RequestBasedServiceLevelIndicator.BuilderImpl requestBasedSli) {
            this.requestBasedSli = requestBasedSli != null ? requestBasedSli.build() : null;
        }

        @Override
        public final Builder requestBasedSli(RequestBasedServiceLevelIndicator requestBasedSli) {
            this.requestBasedSli = requestBasedSli;
            return this;
        }

        public final String getEvaluationType() {
            return this.evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final Goal.Builder getGoal() {
            return this.goal != null ? this.goal.toBuilder() : null;
        }

        public final void setGoal(Goal.BuilderImpl goal) {
            this.goal = goal != null ? goal.build() : null;
        }

        @Override
        public final Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public final List<BurnRateConfiguration.Builder> getBurnRateConfigurations() {
            List<BurnRateConfiguration.Builder> result = BurnRateConfigurationsCopier.copyToBuilder(this.burnRateConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBurnRateConfigurations(Collection<BurnRateConfiguration.BuilderImpl> burnRateConfigurations) {
            this.burnRateConfigurations = BurnRateConfigurationsCopier.copyFromBuilder(burnRateConfigurations);
        }

        @Override
        public final Builder burnRateConfigurations(Collection<BurnRateConfiguration> burnRateConfigurations) {
            this.burnRateConfigurations = BurnRateConfigurationsCopier.copy(burnRateConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder burnRateConfigurations(BurnRateConfiguration ... burnRateConfigurations) {
            this.burnRateConfigurations(Arrays.asList(burnRateConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder burnRateConfigurations(Consumer<BurnRateConfiguration.Builder> ... burnRateConfigurations) {
            this.burnRateConfigurations(Stream.of(burnRateConfigurations).map(c -> (BurnRateConfiguration)((BurnRateConfiguration.Builder)BurnRateConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMetricSourceType() {
            return this.metricSourceType;
        }

        public final void setMetricSourceType(String metricSourceType) {
            this.metricSourceType = metricSourceType;
        }

        @Override
        public final Builder metricSourceType(String metricSourceType) {
            this.metricSourceType = metricSourceType;
            return this;
        }

        @Override
        public final Builder metricSourceType(MetricSourceType metricSourceType) {
            this.metricSourceType(metricSourceType == null ? null : metricSourceType.toString());
            return this;
        }

        public ServiceLevelObjective build() {
            return new ServiceLevelObjective(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLevelObjective> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder sli(ServiceLevelIndicator var1);

        default public Builder sli(Consumer<ServiceLevelIndicator.Builder> sli) {
            return this.sli((ServiceLevelIndicator)((ServiceLevelIndicator.Builder)ServiceLevelIndicator.builder().applyMutation(sli)).build());
        }

        public Builder requestBasedSli(RequestBasedServiceLevelIndicator var1);

        default public Builder requestBasedSli(Consumer<RequestBasedServiceLevelIndicator.Builder> requestBasedSli) {
            return this.requestBasedSli((RequestBasedServiceLevelIndicator)((RequestBasedServiceLevelIndicator.Builder)RequestBasedServiceLevelIndicator.builder().applyMutation(requestBasedSli)).build());
        }

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder goal(Goal var1);

        default public Builder goal(Consumer<Goal.Builder> goal) {
            return this.goal((Goal)((Goal.Builder)Goal.builder().applyMutation(goal)).build());
        }

        public Builder burnRateConfigurations(Collection<BurnRateConfiguration> var1);

        public Builder burnRateConfigurations(BurnRateConfiguration ... var1);

        public Builder burnRateConfigurations(Consumer<BurnRateConfiguration.Builder> ... var1);

        public Builder metricSourceType(String var1);

        public Builder metricSourceType(MetricSourceType var1);
    }
}

