/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsAsyncClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsResponse;

public class ListServiceLevelObjectiveExclusionWindowsPublisher
implements SdkPublisher<ListServiceLevelObjectiveExclusionWindowsResponse> {
    private final ApplicationSignalsAsyncClient client;
    private final ListServiceLevelObjectiveExclusionWindowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceLevelObjectiveExclusionWindowsPublisher(ApplicationSignalsAsyncClient client, ListServiceLevelObjectiveExclusionWindowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceLevelObjectiveExclusionWindowsPublisher(ApplicationSignalsAsyncClient client, ListServiceLevelObjectiveExclusionWindowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceLevelObjectiveExclusionWindowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceLevelObjectiveExclusionWindowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExclusionWindow> exclusionWindows() {
        Function<ListServiceLevelObjectiveExclusionWindowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exclusionWindows() != null) {
                return response.exclusionWindows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceLevelObjectiveExclusionWindowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceLevelObjectiveExclusionWindowsResponseFetcher
    implements AsyncPageFetcher<ListServiceLevelObjectiveExclusionWindowsResponse> {
        private ListServiceLevelObjectiveExclusionWindowsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceLevelObjectiveExclusionWindowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceLevelObjectiveExclusionWindowsResponse> nextPage(ListServiceLevelObjectiveExclusionWindowsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceLevelObjectiveExclusionWindowsPublisher.this.client.listServiceLevelObjectiveExclusionWindows(ListServiceLevelObjectiveExclusionWindowsPublisher.this.firstRequest);
            }
            return ListServiceLevelObjectiveExclusionWindowsPublisher.this.client.listServiceLevelObjectiveExclusionWindows((ListServiceLevelObjectiveExclusionWindowsRequest)((Object)ListServiceLevelObjectiveExclusionWindowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

