/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsAsyncClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceDependent;

public class ListServiceDependentsPublisher
implements SdkPublisher<ListServiceDependentsResponse> {
    private final ApplicationSignalsAsyncClient client;
    private final ListServiceDependentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceDependentsPublisher(ApplicationSignalsAsyncClient client, ListServiceDependentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceDependentsPublisher(ApplicationSignalsAsyncClient client, ListServiceDependentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceDependentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceDependentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceDependent> serviceDependents() {
        Function<ListServiceDependentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceDependents() != null) {
                return response.serviceDependents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceDependentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceDependentsResponseFetcher
    implements AsyncPageFetcher<ListServiceDependentsResponse> {
        private ListServiceDependentsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceDependentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceDependentsResponse> nextPage(ListServiceDependentsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceDependentsPublisher.this.client.listServiceDependents(ListServiceDependentsPublisher.this.firstRequest);
            }
            return ListServiceDependentsPublisher.this.client.listServiceDependents((ListServiceDependentsRequest)((Object)ListServiceDependentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

