/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsRequest;
import software.amazon.awssdk.services.applicationsignals.model.Goal;
import software.amazon.awssdk.services.applicationsignals.model.RequestBasedServiceLevelIndicatorConfig;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorConfig;
import software.amazon.awssdk.services.applicationsignals.model.Tag;
import software.amazon.awssdk.services.applicationsignals.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceLevelObjectiveRequest
extends ApplicationSignalsRequest
implements ToCopyableBuilder<Builder, CreateServiceLevelObjectiveRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateServiceLevelObjectiveRequest.getter(CreateServiceLevelObjectiveRequest::name)).setter(CreateServiceLevelObjectiveRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateServiceLevelObjectiveRequest.getter(CreateServiceLevelObjectiveRequest::description)).setter(CreateServiceLevelObjectiveRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ServiceLevelIndicatorConfig> SLI_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SliConfig").getter(CreateServiceLevelObjectiveRequest.getter(CreateServiceLevelObjectiveRequest::sliConfig)).setter(CreateServiceLevelObjectiveRequest.setter(Builder::sliConfig)).constructor(ServiceLevelIndicatorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SliConfig").build()}).build();
    private static final SdkField<RequestBasedServiceLevelIndicatorConfig> REQUEST_BASED_SLI_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestBasedSliConfig").getter(CreateServiceLevelObjectiveRequest.getter(CreateServiceLevelObjectiveRequest::requestBasedSliConfig)).setter(CreateServiceLevelObjectiveRequest.setter(Builder::requestBasedSliConfig)).constructor(RequestBasedServiceLevelIndicatorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSliConfig").build()}).build();
    private static final SdkField<Goal> GOAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Goal").getter(CreateServiceLevelObjectiveRequest.getter(CreateServiceLevelObjectiveRequest::goal)).setter(CreateServiceLevelObjectiveRequest.setter(Builder::goal)).constructor(Goal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Goal").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateServiceLevelObjectiveRequest.getter(CreateServiceLevelObjectiveRequest::tags)).setter(CreateServiceLevelObjectiveRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SLI_CONFIG_FIELD, REQUEST_BASED_SLI_CONFIG_FIELD, GOAL_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final ServiceLevelIndicatorConfig sliConfig;
    private final RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig;
    private final Goal goal;
    private final List<Tag> tags;

    private CreateServiceLevelObjectiveRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.sliConfig = builder.sliConfig;
        this.requestBasedSliConfig = builder.requestBasedSliConfig;
        this.goal = builder.goal;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ServiceLevelIndicatorConfig sliConfig() {
        return this.sliConfig;
    }

    public final RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig() {
        return this.requestBasedSliConfig;
    }

    public final Goal goal() {
        return this.goal;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sliConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestBasedSliConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.goal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceLevelObjectiveRequest)) {
            return false;
        }
        CreateServiceLevelObjectiveRequest other = (CreateServiceLevelObjectiveRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sliConfig(), other.sliConfig()) && Objects.equals(this.requestBasedSliConfig(), other.requestBasedSliConfig()) && Objects.equals(this.goal(), other.goal()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceLevelObjectiveRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SliConfig", (Object)this.sliConfig()).add("RequestBasedSliConfig", (Object)this.requestBasedSliConfig()).add("Goal", (Object)this.goal()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SliConfig": {
                return Optional.ofNullable(clazz.cast(this.sliConfig()));
            }
            case "RequestBasedSliConfig": {
                return Optional.ofNullable(clazz.cast(this.requestBasedSliConfig()));
            }
            case "Goal": {
                return Optional.ofNullable(clazz.cast(this.goal()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceLevelObjectiveRequest, T> g) {
        return obj -> g.apply((CreateServiceLevelObjectiveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private ServiceLevelIndicatorConfig sliConfig;
        private RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig;
        private Goal goal;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceLevelObjectiveRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.sliConfig(model.sliConfig);
            this.requestBasedSliConfig(model.requestBasedSliConfig);
            this.goal(model.goal);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ServiceLevelIndicatorConfig.Builder getSliConfig() {
            return this.sliConfig != null ? this.sliConfig.toBuilder() : null;
        }

        public final void setSliConfig(ServiceLevelIndicatorConfig.BuilderImpl sliConfig) {
            this.sliConfig = sliConfig != null ? sliConfig.build() : null;
        }

        @Override
        public final Builder sliConfig(ServiceLevelIndicatorConfig sliConfig) {
            this.sliConfig = sliConfig;
            return this;
        }

        public final RequestBasedServiceLevelIndicatorConfig.Builder getRequestBasedSliConfig() {
            return this.requestBasedSliConfig != null ? this.requestBasedSliConfig.toBuilder() : null;
        }

        public final void setRequestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig.BuilderImpl requestBasedSliConfig) {
            this.requestBasedSliConfig = requestBasedSliConfig != null ? requestBasedSliConfig.build() : null;
        }

        @Override
        public final Builder requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig) {
            this.requestBasedSliConfig = requestBasedSliConfig;
            return this;
        }

        public final Goal.Builder getGoal() {
            return this.goal != null ? this.goal.toBuilder() : null;
        }

        public final void setGoal(Goal.BuilderImpl goal) {
            this.goal = goal != null ? goal.build() : null;
        }

        @Override
        public final Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceLevelObjectiveRequest build() {
            return new CreateServiceLevelObjectiveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationSignalsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceLevelObjectiveRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder sliConfig(ServiceLevelIndicatorConfig var1);

        default public Builder sliConfig(Consumer<ServiceLevelIndicatorConfig.Builder> sliConfig) {
            return this.sliConfig((ServiceLevelIndicatorConfig)((ServiceLevelIndicatorConfig.Builder)ServiceLevelIndicatorConfig.builder().applyMutation(sliConfig)).build());
        }

        public Builder requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig var1);

        default public Builder requestBasedSliConfig(Consumer<RequestBasedServiceLevelIndicatorConfig.Builder> requestBasedSliConfig) {
            return this.requestBasedSliConfig((RequestBasedServiceLevelIndicatorConfig)((RequestBasedServiceLevelIndicatorConfig.Builder)RequestBasedServiceLevelIndicatorConfig.builder().applyMutation(requestBasedSliConfig)).build());
        }

        public Builder goal(Goal var1);

        default public Builder goal(Consumer<Goal.Builder> goal) {
            return this.goal((Goal)((Goal.Builder)Goal.builder().applyMutation(goal)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

