/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType;
import software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationEvent> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(ConfigurationEvent.getter(ConfigurationEvent::resourceGroupName)).setter(ConfigurationEvent.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ConfigurationEvent.getter(ConfigurationEvent::accountId)).setter(ConfigurationEvent.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> MONITORED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoredResourceARN").getter(ConfigurationEvent.getter(ConfigurationEvent::monitoredResourceARN)).setter(ConfigurationEvent.setter(Builder::monitoredResourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoredResourceARN").build()}).build();
    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventStatus").getter(ConfigurationEvent.getter(ConfigurationEvent::eventStatusAsString)).setter(ConfigurationEvent.setter(Builder::eventStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStatus").build()}).build();
    private static final SdkField<String> EVENT_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventResourceType").getter(ConfigurationEvent.getter(ConfigurationEvent::eventResourceTypeAsString)).setter(ConfigurationEvent.setter(Builder::eventResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventResourceType").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTime").getter(ConfigurationEvent.getter(ConfigurationEvent::eventTime)).setter(ConfigurationEvent.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()}).build();
    private static final SdkField<String> EVENT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDetail").getter(ConfigurationEvent.getter(ConfigurationEvent::eventDetail)).setter(ConfigurationEvent.setter(Builder::eventDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDetail").build()}).build();
    private static final SdkField<String> EVENT_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventResourceName").getter(ConfigurationEvent.getter(ConfigurationEvent::eventResourceName)).setter(ConfigurationEvent.setter(Builder::eventResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventResourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, ACCOUNT_ID_FIELD, MONITORED_RESOURCE_ARN_FIELD, EVENT_STATUS_FIELD, EVENT_RESOURCE_TYPE_FIELD, EVENT_TIME_FIELD, EVENT_DETAIL_FIELD, EVENT_RESOURCE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceGroupName;
    private final String accountId;
    private final String monitoredResourceARN;
    private final String eventStatus;
    private final String eventResourceType;
    private final Instant eventTime;
    private final String eventDetail;
    private final String eventResourceName;

    private ConfigurationEvent(BuilderImpl builder) {
        this.resourceGroupName = builder.resourceGroupName;
        this.accountId = builder.accountId;
        this.monitoredResourceARN = builder.monitoredResourceARN;
        this.eventStatus = builder.eventStatus;
        this.eventResourceType = builder.eventResourceType;
        this.eventTime = builder.eventTime;
        this.eventDetail = builder.eventDetail;
        this.eventResourceName = builder.eventResourceName;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String monitoredResourceARN() {
        return this.monitoredResourceARN;
    }

    public final ConfigurationEventStatus eventStatus() {
        return ConfigurationEventStatus.fromValue(this.eventStatus);
    }

    public final String eventStatusAsString() {
        return this.eventStatus;
    }

    public final ConfigurationEventResourceType eventResourceType() {
        return ConfigurationEventResourceType.fromValue(this.eventResourceType);
    }

    public final String eventResourceTypeAsString() {
        return this.eventResourceType;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String eventDetail() {
        return this.eventDetail;
    }

    public final String eventResourceName() {
        return this.eventResourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoredResourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventResourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent)obj;
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.monitoredResourceARN(), other.monitoredResourceARN()) && Objects.equals(this.eventStatusAsString(), other.eventStatusAsString()) && Objects.equals(this.eventResourceTypeAsString(), other.eventResourceTypeAsString()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.eventDetail(), other.eventDetail()) && Objects.equals(this.eventResourceName(), other.eventResourceName());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationEvent").add("ResourceGroupName", (Object)this.resourceGroupName()).add("AccountId", (Object)this.accountId()).add("MonitoredResourceARN", (Object)this.monitoredResourceARN()).add("EventStatus", (Object)this.eventStatusAsString()).add("EventResourceType", (Object)this.eventResourceTypeAsString()).add("EventTime", (Object)this.eventTime()).add("EventDetail", (Object)this.eventDetail()).add("EventResourceName", (Object)this.eventResourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "MonitoredResourceARN": {
                return Optional.ofNullable(clazz.cast(this.monitoredResourceARN()));
            }
            case "EventStatus": {
                return Optional.ofNullable(clazz.cast(this.eventStatusAsString()));
            }
            case "EventResourceType": {
                return Optional.ofNullable(clazz.cast(this.eventResourceTypeAsString()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "EventDetail": {
                return Optional.ofNullable(clazz.cast(this.eventDetail()));
            }
            case "EventResourceName": {
                return Optional.ofNullable(clazz.cast(this.eventResourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("MonitoredResourceARN", MONITORED_RESOURCE_ARN_FIELD);
        map.put("EventStatus", EVENT_STATUS_FIELD);
        map.put("EventResourceType", EVENT_RESOURCE_TYPE_FIELD);
        map.put("EventTime", EVENT_TIME_FIELD);
        map.put("EventDetail", EVENT_DETAIL_FIELD);
        map.put("EventResourceName", EVENT_RESOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String accountId;
        private String monitoredResourceARN;
        private String eventStatus;
        private String eventResourceType;
        private Instant eventTime;
        private String eventDetail;
        private String eventResourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationEvent model) {
            this.resourceGroupName(model.resourceGroupName);
            this.accountId(model.accountId);
            this.monitoredResourceARN(model.monitoredResourceARN);
            this.eventStatus(model.eventStatus);
            this.eventResourceType(model.eventResourceType);
            this.eventTime(model.eventTime);
            this.eventDetail(model.eventDetail);
            this.eventResourceName(model.eventResourceName);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getMonitoredResourceARN() {
            return this.monitoredResourceARN;
        }

        public final void setMonitoredResourceARN(String monitoredResourceARN) {
            this.monitoredResourceARN = monitoredResourceARN;
        }

        @Override
        public final Builder monitoredResourceARN(String monitoredResourceARN) {
            this.monitoredResourceARN = monitoredResourceARN;
            return this;
        }

        public final String getEventStatus() {
            return this.eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(ConfigurationEventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final String getEventResourceType() {
            return this.eventResourceType;
        }

        public final void setEventResourceType(String eventResourceType) {
            this.eventResourceType = eventResourceType;
        }

        @Override
        public final Builder eventResourceType(String eventResourceType) {
            this.eventResourceType = eventResourceType;
            return this;
        }

        @Override
        public final Builder eventResourceType(ConfigurationEventResourceType eventResourceType) {
            this.eventResourceType(eventResourceType == null ? null : eventResourceType.toString());
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getEventDetail() {
            return this.eventDetail;
        }

        public final void setEventDetail(String eventDetail) {
            this.eventDetail = eventDetail;
        }

        @Override
        public final Builder eventDetail(String eventDetail) {
            this.eventDetail = eventDetail;
            return this;
        }

        public final String getEventResourceName() {
            return this.eventResourceName;
        }

        public final void setEventResourceName(String eventResourceName) {
            this.eventResourceName = eventResourceName;
        }

        @Override
        public final Builder eventResourceName(String eventResourceName) {
            this.eventResourceName = eventResourceName;
            return this;
        }

        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationEvent> {
        public Builder resourceGroupName(String var1);

        public Builder accountId(String var1);

        public Builder monitoredResourceARN(String var1);

        public Builder eventStatus(String var1);

        public Builder eventStatus(ConfigurationEventStatus var1);

        public Builder eventResourceType(String var1);

        public Builder eventResourceType(ConfigurationEventResourceType var1);

        public Builder eventTime(Instant var1);

        public Builder eventDetail(String var1);

        public Builder eventResourceName(String var1);
    }
}

