/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComponentResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<DescribeComponentResponse.Builder, DescribeComponentResponse> {
    private static final SdkField<ApplicationComponent> APPLICATION_COMPONENT_FIELD = SdkField
            .<ApplicationComponent> builder(MarshallingType.SDK_POJO).memberName("ApplicationComponent")
            .getter(getter(DescribeComponentResponse::applicationComponent)).setter(setter(Builder::applicationComponent))
            .constructor(ApplicationComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationComponent").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceList")
            .getter(getter(DescribeComponentResponse::resourceList))
            .setter(setter(Builder::resourceList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_FIELD,
            RESOURCE_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ApplicationComponent applicationComponent;

    private final List<String> resourceList;

    private DescribeComponentResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponent = builder.applicationComponent;
        this.resourceList = builder.resourceList;
    }

    /**
     * Returns the value of the ApplicationComponent property for this object.
     * 
     * @return The value of the ApplicationComponent property for this object.
     */
    public final ApplicationComponent applicationComponent() {
        return applicationComponent;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceList() {
        return resourceList != null && !(resourceList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resource ARNs that belong to the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceList} method.
     * </p>
     * 
     * @return The list of resource ARNs that belong to the component.
     */
    public final List<String> resourceList() {
        return resourceList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationComponent());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceList() ? resourceList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentResponse)) {
            return false;
        }
        DescribeComponentResponse other = (DescribeComponentResponse) obj;
        return Objects.equals(applicationComponent(), other.applicationComponent())
                && hasResourceList() == other.hasResourceList() && Objects.equals(resourceList(), other.resourceList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeComponentResponse").add("ApplicationComponent", applicationComponent())
                .add("ResourceList", hasResourceList() ? resourceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationComponent":
            return Optional.ofNullable(clazz.cast(applicationComponent()));
        case "ResourceList":
            return Optional.ofNullable(clazz.cast(resourceList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationComponent", APPLICATION_COMPONENT_FIELD);
        map.put("ResourceList", RESOURCE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentResponse, T> g) {
        return obj -> g.apply((DescribeComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComponentResponse> {
        /**
         * Sets the value of the ApplicationComponent property for this object.
         *
         * @param applicationComponent
         *        The new value for the ApplicationComponent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponent(ApplicationComponent applicationComponent);

        /**
         * Sets the value of the ApplicationComponent property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ApplicationComponent.Builder} avoiding
         * the need to create one manually via {@link ApplicationComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationComponent.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationComponent(ApplicationComponent)}.
         * 
         * @param applicationComponent
         *        a consumer that will call methods on {@link ApplicationComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationComponent(ApplicationComponent)
         */
        default Builder applicationComponent(Consumer<ApplicationComponent.Builder> applicationComponent) {
            return applicationComponent(ApplicationComponent.builder().applyMutation(applicationComponent).build());
        }

        /**
         * <p>
         * The list of resource ARNs that belong to the component.
         * </p>
         * 
         * @param resourceList
         *        The list of resource ARNs that belong to the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceList(Collection<String> resourceList);

        /**
         * <p>
         * The list of resource ARNs that belong to the component.
         * </p>
         * 
         * @param resourceList
         *        The list of resource ARNs that belong to the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceList(String... resourceList);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private ApplicationComponent applicationComponent;

        private List<String> resourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentResponse model) {
            super(model);
            applicationComponent(model.applicationComponent);
            resourceList(model.resourceList);
        }

        public final ApplicationComponent.Builder getApplicationComponent() {
            return applicationComponent != null ? applicationComponent.toBuilder() : null;
        }

        public final void setApplicationComponent(ApplicationComponent.BuilderImpl applicationComponent) {
            this.applicationComponent = applicationComponent != null ? applicationComponent.build() : null;
        }

        @Override
        public final Builder applicationComponent(ApplicationComponent applicationComponent) {
            this.applicationComponent = applicationComponent;
            return this;
        }

        public final Collection<String> getResourceList() {
            if (resourceList instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceList;
        }

        public final void setResourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
        }

        @Override
        public final Builder resourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceList(String... resourceList) {
            resourceList(Arrays.asList(resourceList));
            return this;
        }

        @Override
        public DescribeComponentResponse build() {
            return new DescribeComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
