/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBatchDeleteConfigurationTaskResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<DescribeBatchDeleteConfigurationTaskResponse.Builder, DescribeBatchDeleteConfigurationTaskResponse> {
    private static final SdkField<BatchDeleteConfigurationTask> TASK_FIELD = SdkField
            .<BatchDeleteConfigurationTask> builder(MarshallingType.SDK_POJO).memberName("task")
            .getter(getter(DescribeBatchDeleteConfigurationTaskResponse::task)).setter(setter(Builder::task))
            .constructor(BatchDeleteConfigurationTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final BatchDeleteConfigurationTask task;

    private DescribeBatchDeleteConfigurationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.task = builder.task;
    }

    /**
     * <p>
     * The <code>BatchDeleteConfigurationTask</code> that represents the deletion task being executed.
     * </p>
     * 
     * @return The <code>BatchDeleteConfigurationTask</code> that represents the deletion task being executed.
     */
    public final BatchDeleteConfigurationTask task() {
        return task;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(task());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBatchDeleteConfigurationTaskResponse)) {
            return false;
        }
        DescribeBatchDeleteConfigurationTaskResponse other = (DescribeBatchDeleteConfigurationTaskResponse) obj;
        return Objects.equals(task(), other.task());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBatchDeleteConfigurationTaskResponse").add("Task", task()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "task":
            return Optional.ofNullable(clazz.cast(task()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("task", TASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBatchDeleteConfigurationTaskResponse, T> g) {
        return obj -> g.apply((DescribeBatchDeleteConfigurationTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBatchDeleteConfigurationTaskResponse> {
        /**
         * <p>
         * The <code>BatchDeleteConfigurationTask</code> that represents the deletion task being executed.
         * </p>
         * 
         * @param task
         *        The <code>BatchDeleteConfigurationTask</code> that represents the deletion task being executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(BatchDeleteConfigurationTask task);

        /**
         * <p>
         * The <code>BatchDeleteConfigurationTask</code> that represents the deletion task being executed.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchDeleteConfigurationTask.Builder}
         * avoiding the need to create one manually via {@link BatchDeleteConfigurationTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchDeleteConfigurationTask.Builder#build()} is called
         * immediately and its result is passed to {@link #task(BatchDeleteConfigurationTask)}.
         * 
         * @param task
         *        a consumer that will call methods on {@link BatchDeleteConfigurationTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #task(BatchDeleteConfigurationTask)
         */
        default Builder task(Consumer<BatchDeleteConfigurationTask.Builder> task) {
            return task(BatchDeleteConfigurationTask.builder().applyMutation(task).build());
        }
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private BatchDeleteConfigurationTask task;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBatchDeleteConfigurationTaskResponse model) {
            super(model);
            task(model.task);
        }

        public final BatchDeleteConfigurationTask.Builder getTask() {
            return task != null ? task.toBuilder() : null;
        }

        public final void setTask(BatchDeleteConfigurationTask.BuilderImpl task) {
            this.task = task != null ? task.build() : null;
        }

        @Override
        public final Builder task(BatchDeleteConfigurationTask task) {
            this.task = task;
            return this;
        }

        @Override
        public DescribeBatchDeleteConfigurationTaskResponse build() {
            return new DescribeBatchDeleteConfigurationTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
