/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExportTaskRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<StartExportTaskRequest.Builder, StartExportTaskRequest> {
    private static final SdkField<List<String>> EXPORT_DATA_FORMAT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exportDataFormat")
            .getter(getter(StartExportTaskRequest::exportDataFormatAsStrings))
            .setter(setter(Builder::exportDataFormatWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataFormat").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExportFilter>> FILTERS_FIELD = SdkField
            .<List<ExportFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(StartExportTaskRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(StartExportTaskRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(StartExportTaskRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_DATA_FORMAT_FIELD,
            FILTERS_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private final List<String> exportDataFormat;

    private final List<ExportFilter> filters;

    private final Instant startTime;

    private final Instant endTime;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.exportDataFormat = builder.exportDataFormat;
        this.filters = builder.filters;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
     * <code>GRAPHML</code> <i>option has been deprecated.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExportDataFormat()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
     *         <code>GRAPHML</code> <i>option has been deprecated.</i>
     */
    public final List<ExportDataFormat> exportDataFormat() {
        return ExportDataFormatsCopier.copyStringToEnum(exportDataFormat);
    }

    /**
     * Returns true if the ExportDataFormat property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExportDataFormat() {
        return exportDataFormat != null && !(exportDataFormat instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
     * <code>GRAPHML</code> <i>option has been deprecated.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExportDataFormat()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
     *         <code>GRAPHML</code> <i>option has been deprecated.</i>
     */
    public final List<String> exportDataFormatAsStrings() {
        return exportDataFormat;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for which
     * data is exported. The <code>agentId</code> can be found in the results of the <code>DescribeAgents</code> API or
     * CLI. If no filter is present, <code>startTime</code> and <code>endTime</code> are ignored and exported data
     * includes both Agentless Discovery Connector data and summary data from Application Discovery agents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for
     *         which data is exported. The <code>agentId</code> can be found in the results of the
     *         <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
     *         <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data and
     *         summary data from Application Discovery agents.
     */
    public final List<ExportFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If no
     * value is specified, data is exported starting from the first data collected by the agent.
     * </p>
     * 
     * @return The start timestamp for exported data from the single Application Discovery Agent selected in the
     *         filters. If no value is specified, data is exported starting from the first data collected by the agent.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If no
     * value is specified, exported data includes the most recent data collected by the agent.
     * </p>
     * 
     * @return The end timestamp for exported data from the single Application Discovery Agent selected in the filters.
     *         If no value is specified, exported data includes the most recent data collected by the agent.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExportDataFormat() ? exportDataFormatAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest) obj;
        return hasExportDataFormat() == other.hasExportDataFormat()
                && Objects.equals(exportDataFormatAsStrings(), other.exportDataFormatAsStrings())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExportTaskRequest")
                .add("ExportDataFormat", hasExportDataFormat() ? exportDataFormatAsStrings() : null)
                .add("Filters", hasFilters() ? filters() : null).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportDataFormat":
            return Optional.ofNullable(clazz.cast(exportDataFormatAsStrings()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskRequest, T> g) {
        return obj -> g.apply((StartExportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartExportTaskRequest> {
        /**
         * <p>
         * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
         * <code>GRAPHML</code> <i>option has been deprecated.</i>
         * </p>
         * 
         * @param exportDataFormat
         *        The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b>
         *        <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataFormatWithStrings(Collection<String> exportDataFormat);

        /**
         * <p>
         * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
         * <code>GRAPHML</code> <i>option has been deprecated.</i>
         * </p>
         * 
         * @param exportDataFormat
         *        The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b>
         *        <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataFormatWithStrings(String... exportDataFormat);

        /**
         * <p>
         * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
         * <code>GRAPHML</code> <i>option has been deprecated.</i>
         * </p>
         * 
         * @param exportDataFormat
         *        The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b>
         *        <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataFormat(Collection<ExportDataFormat> exportDataFormat);

        /**
         * <p>
         * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
         * <code>GRAPHML</code> <i>option has been deprecated.</i>
         * </p>
         * 
         * @param exportDataFormat
         *        The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b>
         *        <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataFormat(ExportDataFormat... exportDataFormat);

        /**
         * <p>
         * If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for
         * which data is exported. The <code>agentId</code> can be found in the results of the
         * <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         * <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data and
         * summary data from Application Discovery agents.
         * </p>
         * 
         * @param filters
         *        If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent
         *        for which data is exported. The <code>agentId</code> can be found in the results of the
         *        <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         *        <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data
         *        and summary data from Application Discovery agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ExportFilter> filters);

        /**
         * <p>
         * If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for
         * which data is exported. The <code>agentId</code> can be found in the results of the
         * <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         * <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data and
         * summary data from Application Discovery agents.
         * </p>
         * 
         * @param filters
         *        If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent
         *        for which data is exported. The <code>agentId</code> can be found in the results of the
         *        <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         *        <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data
         *        and summary data from Application Discovery agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ExportFilter... filters);

        /**
         * <p>
         * If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for
         * which data is exported. The <code>agentId</code> can be found in the results of the
         * <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         * <code>endTime</code> are ignored and exported data includes both Agentless Discovery Connector data and
         * summary data from Application Discovery agents.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExportFilter>.Builder} avoiding the need to
         * create one manually via {@link List<ExportFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExportFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<ExportFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ExportFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ExportFilter>)
         */
        Builder filters(Consumer<ExportFilter.Builder>... filters);

        /**
         * <p>
         * The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If
         * no value is specified, data is exported starting from the first data collected by the agent.
         * </p>
         * 
         * @param startTime
         *        The start timestamp for exported data from the single Application Discovery Agent selected in the
         *        filters. If no value is specified, data is exported starting from the first data collected by the
         *        agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If
         * no value is specified, exported data includes the most recent data collected by the agent.
         * </p>
         * 
         * @param endTime
         *        The end timestamp for exported data from the single Application Discovery Agent selected in the
         *        filters. If no value is specified, exported data includes the most recent data collected by the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<String> exportDataFormat = DefaultSdkAutoConstructList.getInstance();

        private List<ExportFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            exportDataFormatWithStrings(model.exportDataFormat);
            filters(model.filters);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final Collection<String> getExportDataFormat() {
            if (exportDataFormat instanceof SdkAutoConstructList) {
                return null;
            }
            return exportDataFormat;
        }

        @Override
        public final Builder exportDataFormatWithStrings(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormatWithStrings(String... exportDataFormat) {
            exportDataFormatWithStrings(Arrays.asList(exportDataFormat));
            return this;
        }

        @Override
        public final Builder exportDataFormat(Collection<ExportDataFormat> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copyEnumToString(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormat(ExportDataFormat... exportDataFormat) {
            exportDataFormat(Arrays.asList(exportDataFormat));
            return this;
        }

        public final void setExportDataFormat(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
        }

        public final Collection<ExportFilter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(ExportFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ExportFilter> filters) {
            this.filters = ExportFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExportFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExportFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ExportFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ExportFilter.BuilderImpl> filters) {
            this.filters = ExportFiltersCopier.copyFromBuilder(filters);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
