/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.CustomerAgentInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CustomerAgentInfoMarshaller {
    private static final MarshallingInfo<Integer> ACTIVEAGENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activeAgents").isBinary(false).build();
    private static final MarshallingInfo<Integer> HEALTHYAGENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("healthyAgents").isBinary(false).build();
    private static final MarshallingInfo<Integer> BLACKLISTEDAGENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blackListedAgents").isBinary(false).build();
    private static final MarshallingInfo<Integer> SHUTDOWNAGENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("shutdownAgents").isBinary(false).build();
    private static final MarshallingInfo<Integer> UNHEALTHYAGENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unhealthyAgents").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOTALAGENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalAgents").isBinary(false).build();
    private static final MarshallingInfo<Integer> UNKNOWNAGENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unknownAgents").isBinary(false).build();
    private static final CustomerAgentInfoMarshaller INSTANCE = new CustomerAgentInfoMarshaller();

    private CustomerAgentInfoMarshaller() {
    }

    public static CustomerAgentInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CustomerAgentInfo customerAgentInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)customerAgentInfo, (String)"customerAgentInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)customerAgentInfo.activeAgents(), ACTIVEAGENTS_BINDING);
            protocolMarshaller.marshall((Object)customerAgentInfo.healthyAgents(), HEALTHYAGENTS_BINDING);
            protocolMarshaller.marshall((Object)customerAgentInfo.blackListedAgents(), BLACKLISTEDAGENTS_BINDING);
            protocolMarshaller.marshall((Object)customerAgentInfo.shutdownAgents(), SHUTDOWNAGENTS_BINDING);
            protocolMarshaller.marshall((Object)customerAgentInfo.unhealthyAgents(), UNHEALTHYAGENTS_BINDING);
            protocolMarshaller.marshall((Object)customerAgentInfo.totalAgents(), TOTALAGENTS_BINDING);
            protocolMarshaller.marshall((Object)customerAgentInfo.unknownAgents(), UNKNOWNAGENTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

