/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ContinuousExportDescriptionMarshaller {
    private static final MarshallingInfo<String> EXPORTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exportId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusDetail").isBinary(false).build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Bucket").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> STOPTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopTime").isBinary(false).build();
    private static final MarshallingInfo<String> DATASOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSource").isBinary(false).build();
    private static final MarshallingInfo<Map> SCHEMASTORAGECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("schemaStorageConfig").isBinary(false).build();
    private static final ContinuousExportDescriptionMarshaller INSTANCE = new ContinuousExportDescriptionMarshaller();

    private ContinuousExportDescriptionMarshaller() {
    }

    public static ContinuousExportDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ContinuousExportDescription continuousExportDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)continuousExportDescription, (String)"continuousExportDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)continuousExportDescription.exportId(), EXPORTID_BINDING);
            protocolMarshaller.marshall((Object)continuousExportDescription.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)continuousExportDescription.statusDetail(), STATUSDETAIL_BINDING);
            protocolMarshaller.marshall((Object)continuousExportDescription.s3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)continuousExportDescription.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)continuousExportDescription.stopTime(), STOPTIME_BINDING);
            protocolMarshaller.marshall((Object)continuousExportDescription.dataSourceAsString(), DATASOURCE_BINDING);
            protocolMarshaller.marshall(continuousExportDescription.schemaStorageConfig(), SCHEMASTORAGECONFIG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

