/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportDescription;
import software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeContinuousExportsResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, DescribeContinuousExportsResponse> {
    private final List<ContinuousExportDescription> descriptions;
    private final String nextToken;

    private DescribeContinuousExportsResponse(BuilderImpl builder) {
        super(builder);
        this.descriptions = builder.descriptions;
        this.nextToken = builder.nextToken;
    }

    public List<ContinuousExportDescription> descriptions() {
        return this.descriptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.descriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContinuousExportsResponse)) {
            return false;
        }
        DescribeContinuousExportsResponse other = (DescribeContinuousExportsResponse)((Object)obj);
        return Objects.equals(this.descriptions(), other.descriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeContinuousExportsResponse").add("Descriptions", this.descriptions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "descriptions": {
                return Optional.ofNullable(clazz.cast(this.descriptions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<ContinuousExportDescription> descriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContinuousExportsResponse model) {
            super(model);
            this.descriptions(model.descriptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<ContinuousExportDescription.Builder> getDescriptions() {
            return this.descriptions != null ? (Collection)this.descriptions.stream().map(ContinuousExportDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder descriptions(Collection<ContinuousExportDescription> descriptions) {
            this.descriptions = ContinuousExportDescriptionsCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(ContinuousExportDescription ... descriptions) {
            this.descriptions(Arrays.asList(descriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(Consumer<ContinuousExportDescription.Builder> ... descriptions) {
            this.descriptions(Stream.of(descriptions).map(c -> (ContinuousExportDescription)((ContinuousExportDescription.Builder)ContinuousExportDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDescriptions(Collection<ContinuousExportDescription.BuilderImpl> descriptions) {
            this.descriptions = ContinuousExportDescriptionsCopier.copyFromBuilder(descriptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeContinuousExportsResponse build() {
            return new DescribeContinuousExportsResponse(this);
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    CopyableBuilder<Builder, DescribeContinuousExportsResponse> {
        public Builder descriptions(Collection<ContinuousExportDescription> var1);

        public Builder descriptions(ContinuousExportDescription ... var1);

        public Builder descriptions(Consumer<ContinuousExportDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

