/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationdiscovery.transform.AgentNetworkInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentNetworkInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, AgentNetworkInfo> {
    private final String ipAddress;
    private final String macAddress;

    private AgentNetworkInfo(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.macAddress = builder.macAddress;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentNetworkInfo)) {
            return false;
        }
        AgentNetworkInfo other = (AgentNetworkInfo)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.macAddress(), other.macAddress());
    }

    public String toString() {
        return ToString.builder((String)"AgentNetworkInfo").add("IpAddress", (Object)this.ipAddress()).add("MacAddress", (Object)this.macAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "macAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgentNetworkInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private String macAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentNetworkInfo model) {
            this.ipAddress(model.ipAddress);
            this.macAddress(model.macAddress);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public AgentNetworkInfo build() {
            return new AgentNetworkInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AgentNetworkInfo> {
        public Builder ipAddress(String var1);

        public Builder macAddress(String var1);
    }
}

