/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ClientAssociationMetadataCopier;
import software.amazon.awssdk.services.appintegrations.model.ExecutionConfiguration;
import software.amazon.awssdk.services.appintegrations.model.ObjectConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataIntegrationAssociationRequest
extends AppIntegrationsRequest
implements ToCopyableBuilder<Builder, CreateDataIntegrationAssociationRequest> {
    private static final SdkField<String> DATA_INTEGRATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataIntegrationIdentifier").getter(CreateDataIntegrationAssociationRequest.getter(CreateDataIntegrationAssociationRequest::dataIntegrationIdentifier)).setter(CreateDataIntegrationAssociationRequest.setter(Builder::dataIntegrationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(CreateDataIntegrationAssociationRequest.getter(CreateDataIntegrationAssociationRequest::clientId)).setter(CreateDataIntegrationAssociationRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<Map<String, Map<String, List<String>>>> OBJECT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ObjectConfiguration").getter(CreateDataIntegrationAssociationRequest.getter(CreateDataIntegrationAssociationRequest::objectConfiguration)).setter(CreateDataIntegrationAssociationRequest.setter(Builder::objectConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> DESTINATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationURI").getter(CreateDataIntegrationAssociationRequest.getter(CreateDataIntegrationAssociationRequest::destinationURI)).setter(CreateDataIntegrationAssociationRequest.setter(Builder::destinationURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationURI").build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_ASSOCIATION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientAssociationMetadata").getter(CreateDataIntegrationAssociationRequest.getter(CreateDataIntegrationAssociationRequest::clientAssociationMetadata)).setter(CreateDataIntegrationAssociationRequest.setter(Builder::clientAssociationMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAssociationMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateDataIntegrationAssociationRequest.getter(CreateDataIntegrationAssociationRequest::clientToken)).setter(CreateDataIntegrationAssociationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionConfiguration").getter(CreateDataIntegrationAssociationRequest.getter(CreateDataIntegrationAssociationRequest::executionConfiguration)).setter(CreateDataIntegrationAssociationRequest.setter(Builder::executionConfiguration)).constructor(ExecutionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_INTEGRATION_IDENTIFIER_FIELD, CLIENT_ID_FIELD, OBJECT_CONFIGURATION_FIELD, DESTINATION_URI_FIELD, CLIENT_ASSOCIATION_METADATA_FIELD, CLIENT_TOKEN_FIELD, EXECUTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataIntegrationAssociationRequest.memberNameToFieldInitializer();
    private final String dataIntegrationIdentifier;
    private final String clientId;
    private final Map<String, Map<String, List<String>>> objectConfiguration;
    private final String destinationURI;
    private final Map<String, String> clientAssociationMetadata;
    private final String clientToken;
    private final ExecutionConfiguration executionConfiguration;

    private CreateDataIntegrationAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.dataIntegrationIdentifier = builder.dataIntegrationIdentifier;
        this.clientId = builder.clientId;
        this.objectConfiguration = builder.objectConfiguration;
        this.destinationURI = builder.destinationURI;
        this.clientAssociationMetadata = builder.clientAssociationMetadata;
        this.clientToken = builder.clientToken;
        this.executionConfiguration = builder.executionConfiguration;
    }

    public final String dataIntegrationIdentifier() {
        return this.dataIntegrationIdentifier;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final boolean hasObjectConfiguration() {
        return this.objectConfiguration != null && !(this.objectConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, List<String>>> objectConfiguration() {
        return this.objectConfiguration;
    }

    public final String destinationURI() {
        return this.destinationURI;
    }

    public final boolean hasClientAssociationMetadata() {
        return this.clientAssociationMetadata != null && !(this.clientAssociationMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> clientAssociationMetadata() {
        return this.clientAssociationMetadata;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ExecutionConfiguration executionConfiguration() {
        return this.executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataIntegrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectConfiguration() ? this.objectConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientAssociationMetadata() ? this.clientAssociationMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataIntegrationAssociationRequest)) {
            return false;
        }
        CreateDataIntegrationAssociationRequest other = (CreateDataIntegrationAssociationRequest)((Object)obj);
        return Objects.equals(this.dataIntegrationIdentifier(), other.dataIntegrationIdentifier()) && Objects.equals(this.clientId(), other.clientId()) && this.hasObjectConfiguration() == other.hasObjectConfiguration() && Objects.equals(this.objectConfiguration(), other.objectConfiguration()) && Objects.equals(this.destinationURI(), other.destinationURI()) && this.hasClientAssociationMetadata() == other.hasClientAssociationMetadata() && Objects.equals(this.clientAssociationMetadata(), other.clientAssociationMetadata()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.executionConfiguration(), other.executionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataIntegrationAssociationRequest").add("DataIntegrationIdentifier", (Object)this.dataIntegrationIdentifier()).add("ClientId", (Object)this.clientId()).add("ObjectConfiguration", this.hasObjectConfiguration() ? this.objectConfiguration() : null).add("DestinationURI", (Object)this.destinationURI()).add("ClientAssociationMetadata", this.hasClientAssociationMetadata() ? this.clientAssociationMetadata() : null).add("ClientToken", (Object)this.clientToken()).add("ExecutionConfiguration", (Object)this.executionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataIntegrationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataIntegrationIdentifier()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ObjectConfiguration": {
                return Optional.ofNullable(clazz.cast(this.objectConfiguration()));
            }
            case "DestinationURI": {
                return Optional.ofNullable(clazz.cast(this.destinationURI()));
            }
            case "ClientAssociationMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientAssociationMetadata()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ExecutionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.executionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", DATA_INTEGRATION_IDENTIFIER_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ObjectConfiguration", OBJECT_CONFIGURATION_FIELD);
        map.put("DestinationURI", DESTINATION_URI_FIELD);
        map.put("ClientAssociationMetadata", CLIENT_ASSOCIATION_METADATA_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ExecutionConfiguration", EXECUTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataIntegrationAssociationRequest, T> g) {
        return obj -> g.apply((CreateDataIntegrationAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsRequest.BuilderImpl
    implements Builder {
        private String dataIntegrationIdentifier;
        private String clientId;
        private Map<String, Map<String, List<String>>> objectConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String destinationURI;
        private Map<String, String> clientAssociationMetadata = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataIntegrationAssociationRequest model) {
            super(model);
            this.dataIntegrationIdentifier(model.dataIntegrationIdentifier);
            this.clientId(model.clientId);
            this.objectConfiguration(model.objectConfiguration);
            this.destinationURI(model.destinationURI);
            this.clientAssociationMetadata(model.clientAssociationMetadata);
            this.clientToken(model.clientToken);
            this.executionConfiguration(model.executionConfiguration);
        }

        public final String getDataIntegrationIdentifier() {
            return this.dataIntegrationIdentifier;
        }

        public final void setDataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
        }

        @Override
        public final Builder dataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getObjectConfiguration() {
            if (this.objectConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.objectConfiguration;
        }

        public final void setObjectConfiguration(Map<String, ? extends Map<String, ? extends Collection<String>>> objectConfiguration) {
            this.objectConfiguration = ObjectConfigurationCopier.copy(objectConfiguration);
        }

        @Override
        public final Builder objectConfiguration(Map<String, ? extends Map<String, ? extends Collection<String>>> objectConfiguration) {
            this.objectConfiguration = ObjectConfigurationCopier.copy(objectConfiguration);
            return this;
        }

        public final String getDestinationURI() {
            return this.destinationURI;
        }

        public final void setDestinationURI(String destinationURI) {
            this.destinationURI = destinationURI;
        }

        @Override
        public final Builder destinationURI(String destinationURI) {
            this.destinationURI = destinationURI;
            return this;
        }

        public final Map<String, String> getClientAssociationMetadata() {
            if (this.clientAssociationMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.clientAssociationMetadata;
        }

        public final void setClientAssociationMetadata(Map<String, String> clientAssociationMetadata) {
            this.clientAssociationMetadata = ClientAssociationMetadataCopier.copy(clientAssociationMetadata);
        }

        @Override
        public final Builder clientAssociationMetadata(Map<String, String> clientAssociationMetadata) {
            this.clientAssociationMetadata = ClientAssociationMetadataCopier.copy(clientAssociationMetadata);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ExecutionConfiguration.Builder getExecutionConfiguration() {
            return this.executionConfiguration != null ? this.executionConfiguration.toBuilder() : null;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataIntegrationAssociationRequest build() {
            return new CreateDataIntegrationAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataIntegrationAssociationRequest> {
        public Builder dataIntegrationIdentifier(String var1);

        public Builder clientId(String var1);

        public Builder objectConfiguration(Map<String, ? extends Map<String, ? extends Collection<String>>> var1);

        public Builder destinationURI(String var1);

        public Builder clientAssociationMetadata(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder executionConfiguration(ExecutionConfiguration var1);

        default public Builder executionConfiguration(Consumer<ExecutionConfiguration.Builder> executionConfiguration) {
            return this.executionConfiguration((ExecutionConfiguration)((ExecutionConfiguration.Builder)ExecutionConfiguration.builder().applyMutation(executionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

