/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appintegrations.model.ExecutionMode;
import software.amazon.awssdk.services.appintegrations.model.OnDemandConfiguration;
import software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionConfiguration> {
    private static final SdkField<String> EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionMode").getter(ExecutionConfiguration.getter(ExecutionConfiguration::executionModeAsString)).setter(ExecutionConfiguration.setter(Builder::executionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionMode").build()}).build();
    private static final SdkField<OnDemandConfiguration> ON_DEMAND_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandConfiguration").getter(ExecutionConfiguration.getter(ExecutionConfiguration::onDemandConfiguration)).setter(ExecutionConfiguration.setter(Builder::onDemandConfiguration)).constructor(OnDemandConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandConfiguration").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfiguration").getter(ExecutionConfiguration.getter(ExecutionConfiguration::scheduleConfiguration)).setter(ExecutionConfiguration.setter(Builder::scheduleConfiguration)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_MODE_FIELD, ON_DEMAND_CONFIGURATION_FIELD, SCHEDULE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String executionMode;
    private final OnDemandConfiguration onDemandConfiguration;
    private final ScheduleConfiguration scheduleConfiguration;

    private ExecutionConfiguration(BuilderImpl builder) {
        this.executionMode = builder.executionMode;
        this.onDemandConfiguration = builder.onDemandConfiguration;
        this.scheduleConfiguration = builder.scheduleConfiguration;
    }

    public final ExecutionMode executionMode() {
        return ExecutionMode.fromValue(this.executionMode);
    }

    public final String executionModeAsString() {
        return this.executionMode;
    }

    public final OnDemandConfiguration onDemandConfiguration() {
        return this.onDemandConfiguration;
    }

    public final ScheduleConfiguration scheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionConfiguration)) {
            return false;
        }
        ExecutionConfiguration other = (ExecutionConfiguration)obj;
        return Objects.equals(this.executionModeAsString(), other.executionModeAsString()) && Objects.equals(this.onDemandConfiguration(), other.onDemandConfiguration()) && Objects.equals(this.scheduleConfiguration(), other.scheduleConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionConfiguration").add("ExecutionMode", (Object)this.executionModeAsString()).add("OnDemandConfiguration", (Object)this.onDemandConfiguration()).add("ScheduleConfiguration", (Object)this.scheduleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionMode": {
                return Optional.ofNullable(clazz.cast(this.executionModeAsString()));
            }
            case "OnDemandConfiguration": {
                return Optional.ofNullable(clazz.cast(this.onDemandConfiguration()));
            }
            case "ScheduleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionMode", EXECUTION_MODE_FIELD);
        map.put("OnDemandConfiguration", ON_DEMAND_CONFIGURATION_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionConfiguration, T> g) {
        return obj -> g.apply((ExecutionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionMode;
        private OnDemandConfiguration onDemandConfiguration;
        private ScheduleConfiguration scheduleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionConfiguration model) {
            this.executionMode(model.executionMode);
            this.onDemandConfiguration(model.onDemandConfiguration);
            this.scheduleConfiguration(model.scheduleConfiguration);
        }

        public final String getExecutionMode() {
            return this.executionMode;
        }

        public final void setExecutionMode(String executionMode) {
            this.executionMode = executionMode;
        }

        @Override
        public final Builder executionMode(String executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        @Override
        public final Builder executionMode(ExecutionMode executionMode) {
            this.executionMode(executionMode == null ? null : executionMode.toString());
            return this;
        }

        public final OnDemandConfiguration.Builder getOnDemandConfiguration() {
            return this.onDemandConfiguration != null ? this.onDemandConfiguration.toBuilder() : null;
        }

        public final void setOnDemandConfiguration(OnDemandConfiguration.BuilderImpl onDemandConfiguration) {
            this.onDemandConfiguration = onDemandConfiguration != null ? onDemandConfiguration.build() : null;
        }

        @Override
        public final Builder onDemandConfiguration(OnDemandConfiguration onDemandConfiguration) {
            this.onDemandConfiguration = onDemandConfiguration;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return this.scheduleConfiguration != null ? this.scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public ExecutionConfiguration build() {
            return new ExecutionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionConfiguration> {
        public Builder executionMode(String var1);

        public Builder executionMode(ExecutionMode var1);

        public Builder onDemandConfiguration(OnDemandConfiguration var1);

        default public Builder onDemandConfiguration(Consumer<OnDemandConfiguration.Builder> onDemandConfiguration) {
            return this.onDemandConfiguration((OnDemandConfiguration)((OnDemandConfiguration.Builder)OnDemandConfiguration.builder().applyMutation(onDemandConfiguration)).build());
        }

        public Builder scheduleConfiguration(ScheduleConfiguration var1);

        default public Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return this.scheduleConfiguration((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(scheduleConfiguration)).build());
        }
    }
}

