/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.EventIntegrationAssociation;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse;

public class ListEventIntegrationAssociationsIterable
implements SdkIterable<ListEventIntegrationAssociationsResponse> {
    private final AppIntegrationsClient client;
    private final ListEventIntegrationAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventIntegrationAssociationsIterable(AppIntegrationsClient client, ListEventIntegrationAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventIntegrationAssociationsResponseFetcher();
    }

    public Iterator<ListEventIntegrationAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventIntegrationAssociation> eventIntegrationAssociations() {
        Function<ListEventIntegrationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventIntegrationAssociations() != null) {
                return response.eventIntegrationAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventIntegrationAssociationsResponseFetcher
    implements SyncPageFetcher<ListEventIntegrationAssociationsResponse> {
        private ListEventIntegrationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventIntegrationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventIntegrationAssociationsResponse nextPage(ListEventIntegrationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListEventIntegrationAssociationsIterable.this.client.listEventIntegrationAssociations(ListEventIntegrationAssociationsIterable.this.firstRequest);
            }
            return ListEventIntegrationAssociationsIterable.this.client.listEventIntegrationAssociations((ListEventIntegrationAssociationsRequest)((Object)ListEventIntegrationAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

