/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.EventIntegration;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse;

public class ListEventIntegrationsIterable
implements SdkIterable<ListEventIntegrationsResponse> {
    private final AppIntegrationsClient client;
    private final ListEventIntegrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventIntegrationsIterable(AppIntegrationsClient client, ListEventIntegrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventIntegrationsResponseFetcher();
    }

    public Iterator<ListEventIntegrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventIntegration> eventIntegrations() {
        Function<ListEventIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventIntegrations() != null) {
                return response.eventIntegrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventIntegrationsResponseFetcher
    implements SyncPageFetcher<ListEventIntegrationsResponse> {
        private ListEventIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventIntegrationsResponse nextPage(ListEventIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return ListEventIntegrationsIterable.this.client.listEventIntegrations(ListEventIntegrationsIterable.this.firstRequest);
            }
            return ListEventIntegrationsIterable.this.client.listEventIntegrations((ListEventIntegrationsRequest)((Object)ListEventIntegrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

