/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AmplitudeConnectorOperator;
import software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator;
import software.amazon.awssdk.services.appflow.model.DynatraceConnectorOperator;
import software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator;
import software.amazon.awssdk.services.appflow.model.InforNexusConnectorOperator;
import software.amazon.awssdk.services.appflow.model.MarketoConnectorOperator;
import software.amazon.awssdk.services.appflow.model.Operator;
import software.amazon.awssdk.services.appflow.model.PardotConnectorOperator;
import software.amazon.awssdk.services.appflow.model.S3ConnectorOperator;
import software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator;
import software.amazon.awssdk.services.appflow.model.SalesforceConnectorOperator;
import software.amazon.awssdk.services.appflow.model.ServiceNowConnectorOperator;
import software.amazon.awssdk.services.appflow.model.SingularConnectorOperator;
import software.amazon.awssdk.services.appflow.model.SlackConnectorOperator;
import software.amazon.awssdk.services.appflow.model.TrendmicroConnectorOperator;
import software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator;
import software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorOperator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorOperator> {
    private static final SdkField<String> AMPLITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Amplitude").getter(ConnectorOperator.getter(ConnectorOperator::amplitudeAsString)).setter(ConnectorOperator.setter(Builder::amplitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amplitude").build()}).build();
    private static final SdkField<String> DATADOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Datadog").getter(ConnectorOperator.getter(ConnectorOperator::datadogAsString)).setter(ConnectorOperator.setter(Builder::datadog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datadog").build()}).build();
    private static final SdkField<String> DYNATRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dynatrace").getter(ConnectorOperator.getter(ConnectorOperator::dynatraceAsString)).setter(ConnectorOperator.setter(Builder::dynatrace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynatrace").build()}).build();
    private static final SdkField<String> GOOGLE_ANALYTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GoogleAnalytics").getter(ConnectorOperator.getter(ConnectorOperator::googleAnalyticsAsString)).setter(ConnectorOperator.setter(Builder::googleAnalytics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleAnalytics").build()}).build();
    private static final SdkField<String> INFOR_NEXUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InforNexus").getter(ConnectorOperator.getter(ConnectorOperator::inforNexusAsString)).setter(ConnectorOperator.setter(Builder::inforNexus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InforNexus").build()}).build();
    private static final SdkField<String> MARKETO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marketo").getter(ConnectorOperator.getter(ConnectorOperator::marketoAsString)).setter(ConnectorOperator.setter(Builder::marketo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()}).build();
    private static final SdkField<String> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3").getter(ConnectorOperator.getter(ConnectorOperator::s3AsString)).setter(ConnectorOperator.setter(Builder::s3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final SdkField<String> SALESFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Salesforce").getter(ConnectorOperator.getter(ConnectorOperator::salesforceAsString)).setter(ConnectorOperator.setter(Builder::salesforce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()}).build();
    private static final SdkField<String> SERVICE_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNow").getter(ConnectorOperator.getter(ConnectorOperator::serviceNowAsString)).setter(ConnectorOperator.setter(Builder::serviceNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()}).build();
    private static final SdkField<String> SINGULAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Singular").getter(ConnectorOperator.getter(ConnectorOperator::singularAsString)).setter(ConnectorOperator.setter(Builder::singular)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Singular").build()}).build();
    private static final SdkField<String> SLACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Slack").getter(ConnectorOperator.getter(ConnectorOperator::slackAsString)).setter(ConnectorOperator.setter(Builder::slack)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slack").build()}).build();
    private static final SdkField<String> TRENDMICRO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Trendmicro").getter(ConnectorOperator.getter(ConnectorOperator::trendmicroAsString)).setter(ConnectorOperator.setter(Builder::trendmicro)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trendmicro").build()}).build();
    private static final SdkField<String> VEEVA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Veeva").getter(ConnectorOperator.getter(ConnectorOperator::veevaAsString)).setter(ConnectorOperator.setter(Builder::veeva)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Veeva").build()}).build();
    private static final SdkField<String> ZENDESK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Zendesk").getter(ConnectorOperator.getter(ConnectorOperator::zendeskAsString)).setter(ConnectorOperator.setter(Builder::zendesk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()}).build();
    private static final SdkField<String> SAPO_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAPOData").getter(ConnectorOperator.getter(ConnectorOperator::sapoDataAsString)).setter(ConnectorOperator.setter(Builder::sapoData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAPOData").build()}).build();
    private static final SdkField<String> CUSTOM_CONNECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomConnector").getter(ConnectorOperator.getter(ConnectorOperator::customConnectorAsString)).setter(ConnectorOperator.setter(Builder::customConnector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConnector").build()}).build();
    private static final SdkField<String> PARDOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Pardot").getter(ConnectorOperator.getter(ConnectorOperator::pardotAsString)).setter(ConnectorOperator.setter(Builder::pardot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pardot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLITUDE_FIELD, DATADOG_FIELD, DYNATRACE_FIELD, GOOGLE_ANALYTICS_FIELD, INFOR_NEXUS_FIELD, MARKETO_FIELD, S3_FIELD, SALESFORCE_FIELD, SERVICE_NOW_FIELD, SINGULAR_FIELD, SLACK_FIELD, TRENDMICRO_FIELD, VEEVA_FIELD, ZENDESK_FIELD, SAPO_DATA_FIELD, CUSTOM_CONNECTOR_FIELD, PARDOT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectorOperator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String amplitude;
    private final String datadog;
    private final String dynatrace;
    private final String googleAnalytics;
    private final String inforNexus;
    private final String marketo;
    private final String s3;
    private final String salesforce;
    private final String serviceNow;
    private final String singular;
    private final String slack;
    private final String trendmicro;
    private final String veeva;
    private final String zendesk;
    private final String sapoData;
    private final String customConnector;
    private final String pardot;

    private ConnectorOperator(BuilderImpl builder) {
        this.amplitude = builder.amplitude;
        this.datadog = builder.datadog;
        this.dynatrace = builder.dynatrace;
        this.googleAnalytics = builder.googleAnalytics;
        this.inforNexus = builder.inforNexus;
        this.marketo = builder.marketo;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.singular = builder.singular;
        this.slack = builder.slack;
        this.trendmicro = builder.trendmicro;
        this.veeva = builder.veeva;
        this.zendesk = builder.zendesk;
        this.sapoData = builder.sapoData;
        this.customConnector = builder.customConnector;
        this.pardot = builder.pardot;
    }

    public final AmplitudeConnectorOperator amplitude() {
        return AmplitudeConnectorOperator.fromValue(this.amplitude);
    }

    public final String amplitudeAsString() {
        return this.amplitude;
    }

    public final DatadogConnectorOperator datadog() {
        return DatadogConnectorOperator.fromValue(this.datadog);
    }

    public final String datadogAsString() {
        return this.datadog;
    }

    public final DynatraceConnectorOperator dynatrace() {
        return DynatraceConnectorOperator.fromValue(this.dynatrace);
    }

    public final String dynatraceAsString() {
        return this.dynatrace;
    }

    public final GoogleAnalyticsConnectorOperator googleAnalytics() {
        return GoogleAnalyticsConnectorOperator.fromValue(this.googleAnalytics);
    }

    public final String googleAnalyticsAsString() {
        return this.googleAnalytics;
    }

    public final InforNexusConnectorOperator inforNexus() {
        return InforNexusConnectorOperator.fromValue(this.inforNexus);
    }

    public final String inforNexusAsString() {
        return this.inforNexus;
    }

    public final MarketoConnectorOperator marketo() {
        return MarketoConnectorOperator.fromValue(this.marketo);
    }

    public final String marketoAsString() {
        return this.marketo;
    }

    public final S3ConnectorOperator s3() {
        return S3ConnectorOperator.fromValue(this.s3);
    }

    public final String s3AsString() {
        return this.s3;
    }

    public final SalesforceConnectorOperator salesforce() {
        return SalesforceConnectorOperator.fromValue(this.salesforce);
    }

    public final String salesforceAsString() {
        return this.salesforce;
    }

    public final ServiceNowConnectorOperator serviceNow() {
        return ServiceNowConnectorOperator.fromValue(this.serviceNow);
    }

    public final String serviceNowAsString() {
        return this.serviceNow;
    }

    public final SingularConnectorOperator singular() {
        return SingularConnectorOperator.fromValue(this.singular);
    }

    public final String singularAsString() {
        return this.singular;
    }

    public final SlackConnectorOperator slack() {
        return SlackConnectorOperator.fromValue(this.slack);
    }

    public final String slackAsString() {
        return this.slack;
    }

    public final TrendmicroConnectorOperator trendmicro() {
        return TrendmicroConnectorOperator.fromValue(this.trendmicro);
    }

    public final String trendmicroAsString() {
        return this.trendmicro;
    }

    public final VeevaConnectorOperator veeva() {
        return VeevaConnectorOperator.fromValue(this.veeva);
    }

    public final String veevaAsString() {
        return this.veeva;
    }

    public final ZendeskConnectorOperator zendesk() {
        return ZendeskConnectorOperator.fromValue(this.zendesk);
    }

    public final String zendeskAsString() {
        return this.zendesk;
    }

    public final SAPODataConnectorOperator sapoData() {
        return SAPODataConnectorOperator.fromValue(this.sapoData);
    }

    public final String sapoDataAsString() {
        return this.sapoData;
    }

    public final Operator customConnector() {
        return Operator.fromValue(this.customConnector);
    }

    public final String customConnectorAsString() {
        return this.customConnector;
    }

    public final PardotConnectorOperator pardot() {
        return PardotConnectorOperator.fromValue(this.pardot);
    }

    public final String pardotAsString() {
        return this.pardot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amplitudeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datadogAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynatraceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.googleAnalyticsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inforNexusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.singularAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trendmicroAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.veevaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zendeskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sapoDataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customConnectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pardotAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOperator)) {
            return false;
        }
        ConnectorOperator other = (ConnectorOperator)obj;
        return Objects.equals(this.amplitudeAsString(), other.amplitudeAsString()) && Objects.equals(this.datadogAsString(), other.datadogAsString()) && Objects.equals(this.dynatraceAsString(), other.dynatraceAsString()) && Objects.equals(this.googleAnalyticsAsString(), other.googleAnalyticsAsString()) && Objects.equals(this.inforNexusAsString(), other.inforNexusAsString()) && Objects.equals(this.marketoAsString(), other.marketoAsString()) && Objects.equals(this.s3AsString(), other.s3AsString()) && Objects.equals(this.salesforceAsString(), other.salesforceAsString()) && Objects.equals(this.serviceNowAsString(), other.serviceNowAsString()) && Objects.equals(this.singularAsString(), other.singularAsString()) && Objects.equals(this.slackAsString(), other.slackAsString()) && Objects.equals(this.trendmicroAsString(), other.trendmicroAsString()) && Objects.equals(this.veevaAsString(), other.veevaAsString()) && Objects.equals(this.zendeskAsString(), other.zendeskAsString()) && Objects.equals(this.sapoDataAsString(), other.sapoDataAsString()) && Objects.equals(this.customConnectorAsString(), other.customConnectorAsString()) && Objects.equals(this.pardotAsString(), other.pardotAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorOperator").add("Amplitude", (Object)this.amplitudeAsString()).add("Datadog", (Object)this.datadogAsString()).add("Dynatrace", (Object)this.dynatraceAsString()).add("GoogleAnalytics", (Object)this.googleAnalyticsAsString()).add("InforNexus", (Object)this.inforNexusAsString()).add("Marketo", (Object)this.marketoAsString()).add("S3", (Object)this.s3AsString()).add("Salesforce", (Object)this.salesforceAsString()).add("ServiceNow", (Object)this.serviceNowAsString()).add("Singular", (Object)this.singularAsString()).add("Slack", (Object)this.slackAsString()).add("Trendmicro", (Object)this.trendmicroAsString()).add("Veeva", (Object)this.veevaAsString()).add("Zendesk", (Object)this.zendeskAsString()).add("SAPOData", (Object)this.sapoDataAsString()).add("CustomConnector", (Object)this.customConnectorAsString()).add("Pardot", (Object)this.pardotAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amplitude": {
                return Optional.ofNullable(clazz.cast(this.amplitudeAsString()));
            }
            case "Datadog": {
                return Optional.ofNullable(clazz.cast(this.datadogAsString()));
            }
            case "Dynatrace": {
                return Optional.ofNullable(clazz.cast(this.dynatraceAsString()));
            }
            case "GoogleAnalytics": {
                return Optional.ofNullable(clazz.cast(this.googleAnalyticsAsString()));
            }
            case "InforNexus": {
                return Optional.ofNullable(clazz.cast(this.inforNexusAsString()));
            }
            case "Marketo": {
                return Optional.ofNullable(clazz.cast(this.marketoAsString()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3AsString()));
            }
            case "Salesforce": {
                return Optional.ofNullable(clazz.cast(this.salesforceAsString()));
            }
            case "ServiceNow": {
                return Optional.ofNullable(clazz.cast(this.serviceNowAsString()));
            }
            case "Singular": {
                return Optional.ofNullable(clazz.cast(this.singularAsString()));
            }
            case "Slack": {
                return Optional.ofNullable(clazz.cast(this.slackAsString()));
            }
            case "Trendmicro": {
                return Optional.ofNullable(clazz.cast(this.trendmicroAsString()));
            }
            case "Veeva": {
                return Optional.ofNullable(clazz.cast(this.veevaAsString()));
            }
            case "Zendesk": {
                return Optional.ofNullable(clazz.cast(this.zendeskAsString()));
            }
            case "SAPOData": {
                return Optional.ofNullable(clazz.cast(this.sapoDataAsString()));
            }
            case "CustomConnector": {
                return Optional.ofNullable(clazz.cast(this.customConnectorAsString()));
            }
            case "Pardot": {
                return Optional.ofNullable(clazz.cast(this.pardotAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Amplitude", AMPLITUDE_FIELD);
        map.put("Datadog", DATADOG_FIELD);
        map.put("Dynatrace", DYNATRACE_FIELD);
        map.put("GoogleAnalytics", GOOGLE_ANALYTICS_FIELD);
        map.put("InforNexus", INFOR_NEXUS_FIELD);
        map.put("Marketo", MARKETO_FIELD);
        map.put("S3", S3_FIELD);
        map.put("Salesforce", SALESFORCE_FIELD);
        map.put("ServiceNow", SERVICE_NOW_FIELD);
        map.put("Singular", SINGULAR_FIELD);
        map.put("Slack", SLACK_FIELD);
        map.put("Trendmicro", TRENDMICRO_FIELD);
        map.put("Veeva", VEEVA_FIELD);
        map.put("Zendesk", ZENDESK_FIELD);
        map.put("SAPOData", SAPO_DATA_FIELD);
        map.put("CustomConnector", CUSTOM_CONNECTOR_FIELD);
        map.put("Pardot", PARDOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOperator, T> g) {
        return obj -> g.apply((ConnectorOperator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amplitude;
        private String datadog;
        private String dynatrace;
        private String googleAnalytics;
        private String inforNexus;
        private String marketo;
        private String s3;
        private String salesforce;
        private String serviceNow;
        private String singular;
        private String slack;
        private String trendmicro;
        private String veeva;
        private String zendesk;
        private String sapoData;
        private String customConnector;
        private String pardot;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOperator model) {
            this.amplitude(model.amplitude);
            this.datadog(model.datadog);
            this.dynatrace(model.dynatrace);
            this.googleAnalytics(model.googleAnalytics);
            this.inforNexus(model.inforNexus);
            this.marketo(model.marketo);
            this.s3(model.s3);
            this.salesforce(model.salesforce);
            this.serviceNow(model.serviceNow);
            this.singular(model.singular);
            this.slack(model.slack);
            this.trendmicro(model.trendmicro);
            this.veeva(model.veeva);
            this.zendesk(model.zendesk);
            this.sapoData(model.sapoData);
            this.customConnector(model.customConnector);
            this.pardot(model.pardot);
        }

        public final String getAmplitude() {
            return this.amplitude;
        }

        public final void setAmplitude(String amplitude) {
            this.amplitude = amplitude;
        }

        @Override
        public final Builder amplitude(String amplitude) {
            this.amplitude = amplitude;
            return this;
        }

        @Override
        public final Builder amplitude(AmplitudeConnectorOperator amplitude) {
            this.amplitude(amplitude == null ? null : amplitude.toString());
            return this;
        }

        public final String getDatadog() {
            return this.datadog;
        }

        public final void setDatadog(String datadog) {
            this.datadog = datadog;
        }

        @Override
        public final Builder datadog(String datadog) {
            this.datadog = datadog;
            return this;
        }

        @Override
        public final Builder datadog(DatadogConnectorOperator datadog) {
            this.datadog(datadog == null ? null : datadog.toString());
            return this;
        }

        public final String getDynatrace() {
            return this.dynatrace;
        }

        public final void setDynatrace(String dynatrace) {
            this.dynatrace = dynatrace;
        }

        @Override
        public final Builder dynatrace(String dynatrace) {
            this.dynatrace = dynatrace;
            return this;
        }

        @Override
        public final Builder dynatrace(DynatraceConnectorOperator dynatrace) {
            this.dynatrace(dynatrace == null ? null : dynatrace.toString());
            return this;
        }

        public final String getGoogleAnalytics() {
            return this.googleAnalytics;
        }

        public final void setGoogleAnalytics(String googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
        }

        @Override
        public final Builder googleAnalytics(String googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
            return this;
        }

        @Override
        public final Builder googleAnalytics(GoogleAnalyticsConnectorOperator googleAnalytics) {
            this.googleAnalytics(googleAnalytics == null ? null : googleAnalytics.toString());
            return this;
        }

        public final String getInforNexus() {
            return this.inforNexus;
        }

        public final void setInforNexus(String inforNexus) {
            this.inforNexus = inforNexus;
        }

        @Override
        public final Builder inforNexus(String inforNexus) {
            this.inforNexus = inforNexus;
            return this;
        }

        @Override
        public final Builder inforNexus(InforNexusConnectorOperator inforNexus) {
            this.inforNexus(inforNexus == null ? null : inforNexus.toString());
            return this;
        }

        public final String getMarketo() {
            return this.marketo;
        }

        public final void setMarketo(String marketo) {
            this.marketo = marketo;
        }

        @Override
        public final Builder marketo(String marketo) {
            this.marketo = marketo;
            return this;
        }

        @Override
        public final Builder marketo(MarketoConnectorOperator marketo) {
            this.marketo(marketo == null ? null : marketo.toString());
            return this;
        }

        public final String getS3() {
            return this.s3;
        }

        public final void setS3(String s3) {
            this.s3 = s3;
        }

        @Override
        public final Builder s3(String s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public final Builder s3(S3ConnectorOperator s3) {
            this.s3(s3 == null ? null : s3.toString());
            return this;
        }

        public final String getSalesforce() {
            return this.salesforce;
        }

        public final void setSalesforce(String salesforce) {
            this.salesforce = salesforce;
        }

        @Override
        public final Builder salesforce(String salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        @Override
        public final Builder salesforce(SalesforceConnectorOperator salesforce) {
            this.salesforce(salesforce == null ? null : salesforce.toString());
            return this;
        }

        public final String getServiceNow() {
            return this.serviceNow;
        }

        public final void setServiceNow(String serviceNow) {
            this.serviceNow = serviceNow;
        }

        @Override
        public final Builder serviceNow(String serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        @Override
        public final Builder serviceNow(ServiceNowConnectorOperator serviceNow) {
            this.serviceNow(serviceNow == null ? null : serviceNow.toString());
            return this;
        }

        public final String getSingular() {
            return this.singular;
        }

        public final void setSingular(String singular) {
            this.singular = singular;
        }

        @Override
        public final Builder singular(String singular) {
            this.singular = singular;
            return this;
        }

        @Override
        public final Builder singular(SingularConnectorOperator singular) {
            this.singular(singular == null ? null : singular.toString());
            return this;
        }

        public final String getSlack() {
            return this.slack;
        }

        public final void setSlack(String slack) {
            this.slack = slack;
        }

        @Override
        public final Builder slack(String slack) {
            this.slack = slack;
            return this;
        }

        @Override
        public final Builder slack(SlackConnectorOperator slack) {
            this.slack(slack == null ? null : slack.toString());
            return this;
        }

        public final String getTrendmicro() {
            return this.trendmicro;
        }

        public final void setTrendmicro(String trendmicro) {
            this.trendmicro = trendmicro;
        }

        @Override
        public final Builder trendmicro(String trendmicro) {
            this.trendmicro = trendmicro;
            return this;
        }

        @Override
        public final Builder trendmicro(TrendmicroConnectorOperator trendmicro) {
            this.trendmicro(trendmicro == null ? null : trendmicro.toString());
            return this;
        }

        public final String getVeeva() {
            return this.veeva;
        }

        public final void setVeeva(String veeva) {
            this.veeva = veeva;
        }

        @Override
        public final Builder veeva(String veeva) {
            this.veeva = veeva;
            return this;
        }

        @Override
        public final Builder veeva(VeevaConnectorOperator veeva) {
            this.veeva(veeva == null ? null : veeva.toString());
            return this;
        }

        public final String getZendesk() {
            return this.zendesk;
        }

        public final void setZendesk(String zendesk) {
            this.zendesk = zendesk;
        }

        @Override
        public final Builder zendesk(String zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        @Override
        public final Builder zendesk(ZendeskConnectorOperator zendesk) {
            this.zendesk(zendesk == null ? null : zendesk.toString());
            return this;
        }

        public final String getSapoData() {
            return this.sapoData;
        }

        public final void setSapoData(String sapoData) {
            this.sapoData = sapoData;
        }

        @Override
        public final Builder sapoData(String sapoData) {
            this.sapoData = sapoData;
            return this;
        }

        @Override
        public final Builder sapoData(SAPODataConnectorOperator sapoData) {
            this.sapoData(sapoData == null ? null : sapoData.toString());
            return this;
        }

        public final String getCustomConnector() {
            return this.customConnector;
        }

        public final void setCustomConnector(String customConnector) {
            this.customConnector = customConnector;
        }

        @Override
        public final Builder customConnector(String customConnector) {
            this.customConnector = customConnector;
            return this;
        }

        @Override
        public final Builder customConnector(Operator customConnector) {
            this.customConnector(customConnector == null ? null : customConnector.toString());
            return this;
        }

        public final String getPardot() {
            return this.pardot;
        }

        public final void setPardot(String pardot) {
            this.pardot = pardot;
        }

        @Override
        public final Builder pardot(String pardot) {
            this.pardot = pardot;
            return this;
        }

        @Override
        public final Builder pardot(PardotConnectorOperator pardot) {
            this.pardot(pardot == null ? null : pardot.toString());
            return this;
        }

        public ConnectorOperator build() {
            return new ConnectorOperator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorOperator> {
        public Builder amplitude(String var1);

        public Builder amplitude(AmplitudeConnectorOperator var1);

        public Builder datadog(String var1);

        public Builder datadog(DatadogConnectorOperator var1);

        public Builder dynatrace(String var1);

        public Builder dynatrace(DynatraceConnectorOperator var1);

        public Builder googleAnalytics(String var1);

        public Builder googleAnalytics(GoogleAnalyticsConnectorOperator var1);

        public Builder inforNexus(String var1);

        public Builder inforNexus(InforNexusConnectorOperator var1);

        public Builder marketo(String var1);

        public Builder marketo(MarketoConnectorOperator var1);

        public Builder s3(String var1);

        public Builder s3(S3ConnectorOperator var1);

        public Builder salesforce(String var1);

        public Builder salesforce(SalesforceConnectorOperator var1);

        public Builder serviceNow(String var1);

        public Builder serviceNow(ServiceNowConnectorOperator var1);

        public Builder singular(String var1);

        public Builder singular(SingularConnectorOperator var1);

        public Builder slack(String var1);

        public Builder slack(SlackConnectorOperator var1);

        public Builder trendmicro(String var1);

        public Builder trendmicro(TrendmicroConnectorOperator var1);

        public Builder veeva(String var1);

        public Builder veeva(VeevaConnectorOperator var1);

        public Builder zendesk(String var1);

        public Builder zendesk(ZendeskConnectorOperator var1);

        public Builder sapoData(String var1);

        public Builder sapoData(SAPODataConnectorOperator var1);

        public Builder customConnector(String var1);

        public Builder customConnector(Operator var1);

        public Builder pardot(String var1);

        public Builder pardot(PardotConnectorOperator var1);
    }
}

