/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataTransferApiType {
    SYNC("SYNC"),
    ASYNC("ASYNC"),
    AUTOMATIC("AUTOMATIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataTransferApiType> VALUE_MAP;
    private final String value;

    private DataTransferApiType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataTransferApiType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataTransferApiType> knownValues() {
        EnumSet<DataTransferApiType> knownValues = EnumSet.allOf(DataTransferApiType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataTransferApiType.class, DataTransferApiType::toString);
    }
}

