/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appflow.AppflowClient;
import software.amazon.awssdk.services.appflow.AppflowClientBuilder;
import software.amazon.awssdk.services.appflow.AppflowServiceClientConfiguration;
import software.amazon.awssdk.services.appflow.DefaultAppflowBaseClientBuilder;
import software.amazon.awssdk.services.appflow.DefaultAppflowClient;
import software.amazon.awssdk.services.appflow.endpoints.AppflowEndpointProvider;

@SdkInternalApi
final class DefaultAppflowClientBuilder
extends DefaultAppflowBaseClientBuilder<AppflowClientBuilder, AppflowClient>
implements AppflowClientBuilder {
    DefaultAppflowClientBuilder() {
    }

    @Override
    public DefaultAppflowClientBuilder endpointProvider(AppflowEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppflowClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppflowClientBuilder.validateClientOptions(clientConfiguration);
        AppflowServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppflowClient client = new DefaultAppflowClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppflowServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppflowServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

