/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectorEntitiesRequest extends AppflowRequest implements
        ToCopyableBuilder<ListConnectorEntitiesRequest.Builder, ListConnectorEntitiesRequest> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(ListConnectorEntitiesRequest::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(ListConnectorEntitiesRequest::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> ENTITIES_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entitiesPath").getter(getter(ListConnectorEntitiesRequest::entitiesPath))
            .setter(setter(Builder::entitiesPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitiesPath").build()).build();

    private static final SdkField<String> API_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiVersion").getter(getter(ListConnectorEntitiesRequest::apiVersion))
            .setter(setter(Builder::apiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiVersion").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListConnectorEntitiesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConnectorEntitiesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD,
            CONNECTOR_TYPE_FIELD, ENTITIES_PATH_FIELD, API_VERSION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String connectorProfileName;

    private final String connectorType;

    private final String entitiesPath;

    private final String apiVersion;

    private final Integer maxResults;

    private final String nextToken;

    private ListConnectorEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileName = builder.connectorProfileName;
        this.connectorType = builder.connectorType;
        this.entitiesPath = builder.entitiesPath;
        this.apiVersion = builder.apiVersion;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web
     * Services account, and is used to query the downstream connector.
     * </p>
     * 
     * @return The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the
     *         Amazon Web Services account, and is used to query the downstream connector.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * This optional parameter is specific to connector implementation. Some connectors support multiple levels or
     * categories of entities. You can find out the list of roots for such providers by sending a request without the
     * <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial request
     * returns the list of roots. Otherwise, this request returns all entities supported by the provider.
     * </p>
     * 
     * @return This optional parameter is specific to connector implementation. Some connectors support multiple levels
     *         or categories of entities. You can find out the list of roots for such providers by sending a request
     *         without the <code>entitiesPath</code> parameter. If the connector supports entities at different roots,
     *         this initial request returns the list of roots. Otherwise, this request returns all entities supported by
     *         the provider.
     */
    public final String entitiesPath() {
        return entitiesPath;
    }

    /**
     * <p>
     * The version of the API that's used by the connector.
     * </p>
     * 
     * @return The version of the API that's used by the connector.
     */
    public final String apiVersion() {
        return apiVersion;
    }

    /**
     * <p>
     * The maximum number of items that the operation returns in the response.
     * </p>
     * 
     * @return The maximum number of items that the operation returns in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that was provided by your prior <code>ListConnectorEntities</code> operation if the response was too big
     * for the page size. You specify this token to get the next page of results in paginated response.
     * </p>
     * 
     * @return A token that was provided by your prior <code>ListConnectorEntities</code> operation if the response was
     *         too big for the page size. You specify this token to get the next page of results in paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entitiesPath());
        hashCode = 31 * hashCode + Objects.hashCode(apiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorEntitiesRequest)) {
            return false;
        }
        ListConnectorEntitiesRequest other = (ListConnectorEntitiesRequest) obj;
        return Objects.equals(connectorProfileName(), other.connectorProfileName())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(entitiesPath(), other.entitiesPath()) && Objects.equals(apiVersion(), other.apiVersion())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectorEntitiesRequest").add("ConnectorProfileName", connectorProfileName())
                .add("ConnectorType", connectorTypeAsString()).add("EntitiesPath", entitiesPath())
                .add("ApiVersion", apiVersion()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "entitiesPath":
            return Optional.ofNullable(clazz.cast(entitiesPath()));
        case "apiVersion":
            return Optional.ofNullable(clazz.cast(apiVersion()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorEntitiesRequest, T> g) {
        return obj -> g.apply((ListConnectorEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectorEntitiesRequest> {
        /**
         * <p>
         * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon
         * Web Services account, and is used to query the downstream connector.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the
         *        Amazon Web Services account, and is used to query the downstream connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * This optional parameter is specific to connector implementation. Some connectors support multiple levels or
         * categories of entities. You can find out the list of roots for such providers by sending a request without
         * the <code>entitiesPath</code> parameter. If the connector supports entities at different roots, this initial
         * request returns the list of roots. Otherwise, this request returns all entities supported by the provider.
         * </p>
         * 
         * @param entitiesPath
         *        This optional parameter is specific to connector implementation. Some connectors support multiple
         *        levels or categories of entities. You can find out the list of roots for such providers by sending a
         *        request without the <code>entitiesPath</code> parameter. If the connector supports entities at
         *        different roots, this initial request returns the list of roots. Otherwise, this request returns all
         *        entities supported by the provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesPath(String entitiesPath);

        /**
         * <p>
         * The version of the API that's used by the connector.
         * </p>
         * 
         * @param apiVersion
         *        The version of the API that's used by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiVersion(String apiVersion);

        /**
         * <p>
         * The maximum number of items that the operation returns in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items that the operation returns in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that was provided by your prior <code>ListConnectorEntities</code> operation if the response was too
         * big for the page size. You specify this token to get the next page of results in paginated response.
         * </p>
         * 
         * @param nextToken
         *        A token that was provided by your prior <code>ListConnectorEntities</code> operation if the response
         *        was too big for the page size. You specify this token to get the next page of results in paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String connectorProfileName;

        private String connectorType;

        private String entitiesPath;

        private String apiVersion;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorEntitiesRequest model) {
            super(model);
            connectorProfileName(model.connectorProfileName);
            connectorType(model.connectorType);
            entitiesPath(model.entitiesPath);
            apiVersion(model.apiVersion);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getEntitiesPath() {
            return entitiesPath;
        }

        public final void setEntitiesPath(String entitiesPath) {
            this.entitiesPath = entitiesPath;
        }

        @Override
        public final Builder entitiesPath(String entitiesPath) {
            this.entitiesPath = entitiesPath;
            return this;
        }

        public final String getApiVersion() {
            return apiVersion;
        }

        public final void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        @Override
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectorEntitiesRequest build() {
            return new ListConnectorEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
