/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile properties required by Infor Nexus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InforNexusConnectorProfileProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<InforNexusConnectorProfileProperties.Builder, InforNexusConnectorProfileProperties> {
    private static final SdkField<String> INSTANCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceUrl").getter(getter(InforNexusConnectorProfileProperties::instanceUrl))
            .setter(setter(Builder::instanceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceUrl;

    private InforNexusConnectorProfileProperties(BuilderImpl builder) {
        this.instanceUrl = builder.instanceUrl;
    }

    /**
     * <p>
     * The location of the Infor Nexus resource.
     * </p>
     * 
     * @return The location of the Infor Nexus resource.
     */
    public final String instanceUrl() {
        return instanceUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InforNexusConnectorProfileProperties)) {
            return false;
        }
        InforNexusConnectorProfileProperties other = (InforNexusConnectorProfileProperties) obj;
        return Objects.equals(instanceUrl(), other.instanceUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InforNexusConnectorProfileProperties").add("InstanceUrl", instanceUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceUrl":
            return Optional.ofNullable(clazz.cast(instanceUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InforNexusConnectorProfileProperties, T> g) {
        return obj -> g.apply((InforNexusConnectorProfileProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InforNexusConnectorProfileProperties> {
        /**
         * <p>
         * The location of the Infor Nexus resource.
         * </p>
         * 
         * @param instanceUrl
         *        The location of the Infor Nexus resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUrl(String instanceUrl);
    }

    static final class BuilderImpl implements Builder {
        private String instanceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(InforNexusConnectorProfileProperties model) {
            instanceUrl(model.instanceUrl);
        }

        public final String getInstanceUrl() {
            return instanceUrl;
        }

        public final void setInstanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
        }

        @Override
        public final Builder instanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
            return this;
        }

        @Override
        public InforNexusConnectorProfileProperties build() {
            return new InforNexusConnectorProfileProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
