/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile credentials that are required when using the custom connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomConnectorProfileCredentials.Builder, CustomConnectorProfileCredentials> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(CustomConnectorProfileCredentials::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<BasicAuthCredentials> BASIC_FIELD = SdkField
            .<BasicAuthCredentials> builder(MarshallingType.SDK_POJO).memberName("basic")
            .getter(getter(CustomConnectorProfileCredentials::basic)).setter(setter(Builder::basic))
            .constructor(BasicAuthCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basic").build()).build();

    private static final SdkField<OAuth2Credentials> OAUTH2_FIELD = SdkField
            .<OAuth2Credentials> builder(MarshallingType.SDK_POJO).memberName("oauth2")
            .getter(getter(CustomConnectorProfileCredentials::oauth2)).setter(setter(Builder::oauth2))
            .constructor(OAuth2Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2").build()).build();

    private static final SdkField<ApiKeyCredentials> API_KEY_FIELD = SdkField
            .<ApiKeyCredentials> builder(MarshallingType.SDK_POJO).memberName("apiKey")
            .getter(getter(CustomConnectorProfileCredentials::apiKey)).setter(setter(Builder::apiKey))
            .constructor(ApiKeyCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKey").build()).build();

    private static final SdkField<CustomAuthCredentials> CUSTOM_FIELD = SdkField
            .<CustomAuthCredentials> builder(MarshallingType.SDK_POJO).memberName("custom")
            .getter(getter(CustomConnectorProfileCredentials::custom)).setter(setter(Builder::custom))
            .constructor(CustomAuthCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            BASIC_FIELD, OAUTH2_FIELD, API_KEY_FIELD, CUSTOM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final BasicAuthCredentials basic;

    private final OAuth2Credentials oauth2;

    private final ApiKeyCredentials apiKey;

    private final CustomAuthCredentials custom;

    private CustomConnectorProfileCredentials(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.basic = builder.basic;
        this.oauth2 = builder.oauth2;
        this.apiKey = builder.apiKey;
        this.custom = builder.custom;
    }

    /**
     * <p>
     * The authentication type that the custom connector uses for authenticating while creating a connector profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type that the custom connector uses for authenticating while creating a connector
     *         profile.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type that the custom connector uses for authenticating while creating a connector profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type that the custom connector uses for authenticating while creating a connector
     *         profile.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The basic credentials that are required for the authentication of the user.
     * </p>
     * 
     * @return The basic credentials that are required for the authentication of the user.
     */
    public final BasicAuthCredentials basic() {
        return basic;
    }

    /**
     * <p>
     * The OAuth 2.0 credentials required for the authentication of the user.
     * </p>
     * 
     * @return The OAuth 2.0 credentials required for the authentication of the user.
     */
    public final OAuth2Credentials oauth2() {
        return oauth2;
    }

    /**
     * <p>
     * The API keys required for the authentication of the user.
     * </p>
     * 
     * @return The API keys required for the authentication of the user.
     */
    public final ApiKeyCredentials apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * If the connector uses the custom authentication mechanism, this holds the required credentials.
     * </p>
     * 
     * @return If the connector uses the custom authentication mechanism, this holds the required credentials.
     */
    public final CustomAuthCredentials custom() {
        return custom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(basic());
        hashCode = 31 * hashCode + Objects.hashCode(oauth2());
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(custom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorProfileCredentials)) {
            return false;
        }
        CustomConnectorProfileCredentials other = (CustomConnectorProfileCredentials) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(basic(), other.basic()) && Objects.equals(oauth2(), other.oauth2())
                && Objects.equals(apiKey(), other.apiKey()) && Objects.equals(custom(), other.custom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomConnectorProfileCredentials").add("AuthenticationType", authenticationTypeAsString())
                .add("Basic", basic()).add("Oauth2", oauth2()).add("ApiKey", apiKey()).add("Custom", custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "basic":
            return Optional.ofNullable(clazz.cast(basic()));
        case "oauth2":
            return Optional.ofNullable(clazz.cast(oauth2()));
        case "apiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "custom":
            return Optional.ofNullable(clazz.cast(custom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomConnectorProfileCredentials, T> g) {
        return obj -> g.apply((CustomConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomConnectorProfileCredentials> {
        /**
         * <p>
         * The authentication type that the custom connector uses for authenticating while creating a connector profile.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type that the custom connector uses for authenticating while creating a connector
         *        profile.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type that the custom connector uses for authenticating while creating a connector profile.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type that the custom connector uses for authenticating while creating a connector
         *        profile.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The basic credentials that are required for the authentication of the user.
         * </p>
         * 
         * @param basic
         *        The basic credentials that are required for the authentication of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basic(BasicAuthCredentials basic);

        /**
         * <p>
         * The basic credentials that are required for the authentication of the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link BasicAuthCredentials.Builder} avoiding
         * the need to create one manually via {@link BasicAuthCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BasicAuthCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #basic(BasicAuthCredentials)}.
         * 
         * @param basic
         *        a consumer that will call methods on {@link BasicAuthCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basic(BasicAuthCredentials)
         */
        default Builder basic(Consumer<BasicAuthCredentials.Builder> basic) {
            return basic(BasicAuthCredentials.builder().applyMutation(basic).build());
        }

        /**
         * <p>
         * The OAuth 2.0 credentials required for the authentication of the user.
         * </p>
         * 
         * @param oauth2
         *        The OAuth 2.0 credentials required for the authentication of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2(OAuth2Credentials oauth2);

        /**
         * <p>
         * The OAuth 2.0 credentials required for the authentication of the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuth2Credentials.Builder} avoiding the
         * need to create one manually via {@link OAuth2Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2Credentials.Builder#build()} is called immediately and its
         * result is passed to {@link #oauth2(OAuth2Credentials)}.
         * 
         * @param oauth2
         *        a consumer that will call methods on {@link OAuth2Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oauth2(OAuth2Credentials)
         */
        default Builder oauth2(Consumer<OAuth2Credentials.Builder> oauth2) {
            return oauth2(OAuth2Credentials.builder().applyMutation(oauth2).build());
        }

        /**
         * <p>
         * The API keys required for the authentication of the user.
         * </p>
         * 
         * @param apiKey
         *        The API keys required for the authentication of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(ApiKeyCredentials apiKey);

        /**
         * <p>
         * The API keys required for the authentication of the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiKeyCredentials.Builder} avoiding the
         * need to create one manually via {@link ApiKeyCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiKeyCredentials.Builder#build()} is called immediately and its
         * result is passed to {@link #apiKey(ApiKeyCredentials)}.
         * 
         * @param apiKey
         *        a consumer that will call methods on {@link ApiKeyCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKey(ApiKeyCredentials)
         */
        default Builder apiKey(Consumer<ApiKeyCredentials.Builder> apiKey) {
            return apiKey(ApiKeyCredentials.builder().applyMutation(apiKey).build());
        }

        /**
         * <p>
         * If the connector uses the custom authentication mechanism, this holds the required credentials.
         * </p>
         * 
         * @param custom
         *        If the connector uses the custom authentication mechanism, this holds the required credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(CustomAuthCredentials custom);

        /**
         * <p>
         * If the connector uses the custom authentication mechanism, this holds the required credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomAuthCredentials.Builder} avoiding
         * the need to create one manually via {@link CustomAuthCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomAuthCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #custom(CustomAuthCredentials)}.
         * 
         * @param custom
         *        a consumer that will call methods on {@link CustomAuthCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(CustomAuthCredentials)
         */
        default Builder custom(Consumer<CustomAuthCredentials.Builder> custom) {
            return custom(CustomAuthCredentials.builder().applyMutation(custom).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private BasicAuthCredentials basic;

        private OAuth2Credentials oauth2;

        private ApiKeyCredentials apiKey;

        private CustomAuthCredentials custom;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConnectorProfileCredentials model) {
            authenticationType(model.authenticationType);
            basic(model.basic);
            oauth2(model.oauth2);
            apiKey(model.apiKey);
            custom(model.custom);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final BasicAuthCredentials.Builder getBasic() {
            return basic != null ? basic.toBuilder() : null;
        }

        public final void setBasic(BasicAuthCredentials.BuilderImpl basic) {
            this.basic = basic != null ? basic.build() : null;
        }

        @Override
        public final Builder basic(BasicAuthCredentials basic) {
            this.basic = basic;
            return this;
        }

        public final OAuth2Credentials.Builder getOauth2() {
            return oauth2 != null ? oauth2.toBuilder() : null;
        }

        public final void setOauth2(OAuth2Credentials.BuilderImpl oauth2) {
            this.oauth2 = oauth2 != null ? oauth2.build() : null;
        }

        @Override
        public final Builder oauth2(OAuth2Credentials oauth2) {
            this.oauth2 = oauth2;
            return this;
        }

        public final ApiKeyCredentials.Builder getApiKey() {
            return apiKey != null ? apiKey.toBuilder() : null;
        }

        public final void setApiKey(ApiKeyCredentials.BuilderImpl apiKey) {
            this.apiKey = apiKey != null ? apiKey.build() : null;
        }

        @Override
        public final Builder apiKey(ApiKeyCredentials apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final CustomAuthCredentials.Builder getCustom() {
            return custom != null ? custom.toBuilder() : null;
        }

        public final void setCustom(CustomAuthCredentials.BuilderImpl custom) {
            this.custom = custom != null ? custom.build() : null;
        }

        @Override
        public final Builder custom(CustomAuthCredentials custom) {
            this.custom = custom;
            return this;
        }

        @Override
        public CustomConnectorProfileCredentials build() {
            return new CustomConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
