/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ZendeskConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ZendeskConnectorProfileCredentials> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(ZendeskConnectorProfileCredentials.getter(ZendeskConnectorProfileCredentials::clientId)).setter(ZendeskConnectorProfileCredentials.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientSecret").getter(ZendeskConnectorProfileCredentials.getter(ZendeskConnectorProfileCredentials::clientSecret)).setter(ZendeskConnectorProfileCredentials.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(ZendeskConnectorProfileCredentials.getter(ZendeskConnectorProfileCredentials::accessToken)).setter(ZendeskConnectorProfileCredentials.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuthRequest").getter(ZendeskConnectorProfileCredentials.getter(ZendeskConnectorProfileCredentials::oAuthRequest)).setter(ZendeskConnectorProfileCredentials.setter(Builder::oAuthRequest)).constructor(ConnectorOAuthRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, ACCESS_TOKEN_FIELD, O_AUTH_REQUEST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientId;
    private final String clientSecret;
    private final String accessToken;
    private final ConnectorOAuthRequest oAuthRequest;

    private ZendeskConnectorProfileCredentials(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.accessToken = builder.accessToken;
        this.oAuthRequest = builder.oAuthRequest;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final ConnectorOAuthRequest oAuthRequest() {
        return this.oAuthRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZendeskConnectorProfileCredentials)) {
            return false;
        }
        ZendeskConnectorProfileCredentials other = (ZendeskConnectorProfileCredentials)obj;
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.oAuthRequest(), other.oAuthRequest());
    }

    public final String toString() {
        return ToString.builder((String)"ZendeskConnectorProfileCredentials").add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("OAuthRequest", (Object)this.oAuthRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "clientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "oAuthRequest": {
                return Optional.ofNullable(clazz.cast(this.oAuthRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ZendeskConnectorProfileCredentials, T> g) {
        return obj -> g.apply((ZendeskConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientId;
        private String clientSecret;
        private String accessToken;
        private ConnectorOAuthRequest oAuthRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(ZendeskConnectorProfileCredentials model) {
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.accessToken(model.accessToken);
            this.oAuthRequest(model.oAuthRequest);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return this.oAuthRequest != null ? this.oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        public ZendeskConnectorProfileCredentials build() {
            return new ZendeskConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ZendeskConnectorProfileCredentials> {
        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder accessToken(String var1);

        public Builder oAuthRequest(ConnectorOAuthRequest var1);

        default public Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return this.oAuthRequest((ConnectorOAuthRequest)((ConnectorOAuthRequest.Builder)ConnectorOAuthRequest.builder().applyMutation(oAuthRequest)).build());
        }
    }
}

