/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.appflow.AppflowClient;
import software.amazon.awssdk.services.appflow.AppflowServiceClientConfiguration;
import software.amazon.awssdk.services.appflow.model.AccessDeniedException;
import software.amazon.awssdk.services.appflow.model.AppflowException;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConflictException;
import software.amazon.awssdk.services.appflow.model.ConnectorAuthenticationException;
import software.amazon.awssdk.services.appflow.model.ConnectorServerException;
import software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.CreateFlowRequest;
import software.amazon.awssdk.services.appflow.model.CreateFlowResponse;
import software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.DeleteFlowRequest;
import software.amazon.awssdk.services.appflow.model.DeleteFlowResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse;
import software.amazon.awssdk.services.appflow.model.DescribeFlowRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowResponse;
import software.amazon.awssdk.services.appflow.model.InternalServerException;
import software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest;
import software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse;
import software.amazon.awssdk.services.appflow.model.ListConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.ListConnectorsResponse;
import software.amazon.awssdk.services.appflow.model.ListFlowsRequest;
import software.amazon.awssdk.services.appflow.model.ListFlowsResponse;
import software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appflow.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest;
import software.amazon.awssdk.services.appflow.model.RegisterConnectorResponse;
import software.amazon.awssdk.services.appflow.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appflow.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.appflow.model.StartFlowRequest;
import software.amazon.awssdk.services.appflow.model.StartFlowResponse;
import software.amazon.awssdk.services.appflow.model.StopFlowRequest;
import software.amazon.awssdk.services.appflow.model.StopFlowResponse;
import software.amazon.awssdk.services.appflow.model.TagResourceRequest;
import software.amazon.awssdk.services.appflow.model.TagResourceResponse;
import software.amazon.awssdk.services.appflow.model.ThrottlingException;
import software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest;
import software.amazon.awssdk.services.appflow.model.UnregisterConnectorResponse;
import software.amazon.awssdk.services.appflow.model.UnsupportedOperationException;
import software.amazon.awssdk.services.appflow.model.UntagResourceRequest;
import software.amazon.awssdk.services.appflow.model.UntagResourceResponse;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorRegistrationRequest;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorRegistrationResponse;
import software.amazon.awssdk.services.appflow.model.UpdateFlowRequest;
import software.amazon.awssdk.services.appflow.model.UpdateFlowResponse;
import software.amazon.awssdk.services.appflow.model.ValidationException;
import software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesIterable;
import software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsIterable;
import software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsIterable;
import software.amazon.awssdk.services.appflow.paginators.ListConnectorsIterable;
import software.amazon.awssdk.services.appflow.paginators.ListFlowsIterable;
import software.amazon.awssdk.services.appflow.transform.CreateConnectorProfileRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.CreateFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DeleteConnectorProfileRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DeleteFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeConnectorEntityRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeConnectorProfilesRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeConnectorRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeConnectorsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeFlowExecutionRecordsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.DescribeFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ListConnectorEntitiesRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ListConnectorsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ListFlowsRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.RegisterConnectorRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.StartFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.StopFlowRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UnregisterConnectorRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UpdateConnectorProfileRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UpdateConnectorRegistrationRequestMarshaller;
import software.amazon.awssdk.services.appflow.transform.UpdateFlowRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAppflowClient
implements AppflowClient {
    private static final Logger log = Logger.loggerFor(DefaultAppflowClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final AppflowServiceClientConfiguration serviceClientConfiguration;

    protected DefaultAppflowClient(AppflowServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectorProfileResponse createConnectorProfile(CreateConnectorProfileRequest createConnectorProfileRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, ConnectorAuthenticationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectorProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, createConnectorProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnectorProfile");
            CreateConnectorProfileResponse createConnectorProfileResponse = (CreateConnectorProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnectorProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConnectorProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConnectorProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConnectorProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$createConnectorProfile$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFlowResponse createFlow(CreateFlowRequest createFlowRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, ConnectorAuthenticationException, ConnectorServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, createFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFlow");
            CreateFlowResponse createFlowResponse = (CreateFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$createFlow$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectorProfileResponse deleteConnectorProfile(DeleteConnectorProfileRequest deleteConnectorProfileRequest) throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectorProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, deleteConnectorProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnectorProfile");
            DeleteConnectorProfileResponse deleteConnectorProfileResponse = (DeleteConnectorProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnectorProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConnectorProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectorProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectorProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$deleteConnectorProfile$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFlowResponse deleteFlow(DeleteFlowRequest deleteFlowRequest) throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, deleteFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFlow");
            DeleteFlowResponse deleteFlowResponse = (DeleteFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$deleteFlow$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectorResponse describeConnector(DescribeConnectorRequest describeConnectorRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, describeConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnector");
            DescribeConnectorResponse describeConnectorResponse = (DescribeConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeConnector$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectorEntityResponse describeConnectorEntity(DescribeConnectorEntityRequest describeConnectorEntityRequest) throws ValidationException, ResourceNotFoundException, ConnectorAuthenticationException, ConnectorServerException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorEntityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, describeConnectorEntityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectorEntity");
            DescribeConnectorEntityResponse describeConnectorEntityResponse = (DescribeConnectorEntityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectorEntity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectorEntityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectorEntityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectorEntityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeConnectorEntity$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectorProfilesResponse describeConnectorProfiles(DescribeConnectorProfilesRequest describeConnectorProfilesRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, describeConnectorProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectorProfiles");
            DescribeConnectorProfilesResponse describeConnectorProfilesResponse = (DescribeConnectorProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectorProfiles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectorProfilesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectorProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectorProfilesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeConnectorProfiles$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeConnectorProfilesIterable describeConnectorProfilesPaginator(DescribeConnectorProfilesRequest describeConnectorProfilesRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return new DescribeConnectorProfilesIterable(this, this.applyPaginatorUserAgent(describeConnectorProfilesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectorsResponse describeConnectors(DescribeConnectorsRequest describeConnectorsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, describeConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectors");
            DescribeConnectorsResponse describeConnectorsResponse = (DescribeConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeConnectors$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeConnectorsIterable describeConnectorsPaginator(DescribeConnectorsRequest describeConnectorsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return new DescribeConnectorsIterable(this, this.applyPaginatorUserAgent(describeConnectorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFlowResponse describeFlow(DescribeFlowRequest describeFlowRequest) throws ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, describeFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlow");
            DescribeFlowResponse describeFlowResponse = (DescribeFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeFlow$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFlowExecutionRecordsResponse describeFlowExecutionRecords(DescribeFlowExecutionRecordsRequest describeFlowExecutionRecordsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlowExecutionRecordsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, describeFlowExecutionRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlowExecutionRecords");
            DescribeFlowExecutionRecordsResponse describeFlowExecutionRecordsResponse = (DescribeFlowExecutionRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlowExecutionRecords").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFlowExecutionRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFlowExecutionRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFlowExecutionRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$describeFlowExecutionRecords$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeFlowExecutionRecordsIterable describeFlowExecutionRecordsPaginator(DescribeFlowExecutionRecordsRequest describeFlowExecutionRecordsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return new DescribeFlowExecutionRecordsIterable(this, this.applyPaginatorUserAgent(describeFlowExecutionRecordsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConnectorEntitiesResponse listConnectorEntities(ListConnectorEntitiesRequest listConnectorEntitiesRequest) throws ValidationException, ResourceNotFoundException, ConnectorAuthenticationException, ConnectorServerException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectorEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, listConnectorEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnectorEntities");
            ListConnectorEntitiesResponse listConnectorEntitiesResponse = (ListConnectorEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnectorEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConnectorEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConnectorEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConnectorEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$listConnectorEntities$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConnectorsResponse listConnectors(ListConnectorsRequest listConnectorsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, listConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnectors");
            ListConnectorsResponse listConnectorsResponse = (ListConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConnectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConnectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$listConnectors$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListConnectorsIterable listConnectorsPaginator(ListConnectorsRequest listConnectorsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return new ListConnectorsIterable(this, this.applyPaginatorUserAgent(listConnectorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFlowsResponse listFlows(ListFlowsRequest listFlowsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, listFlowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlows");
            ListFlowsResponse listFlowsResponse = (ListFlowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFlowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFlowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFlowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$listFlows$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFlowsIterable listFlowsPaginator(ListFlowsRequest listFlowsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        return new ListFlowsIterable(this, this.applyPaginatorUserAgent(listFlowsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$listTagsForResource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterConnectorResponse registerConnector(RegisterConnectorRequest registerConnectorRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, ConnectorServerException, ConnectorAuthenticationException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, registerConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterConnector");
            RegisterConnectorResponse registerConnectorResponse = (RegisterConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterConnector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$registerConnector$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartFlowResponse startFlow(StartFlowRequest startFlowRequest) throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, startFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFlow");
            StartFlowResponse startFlowResponse = (StartFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$startFlow$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopFlowResponse stopFlow(StopFlowRequest stopFlowRequest) throws ConflictException, ResourceNotFoundException, UnsupportedOperationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, stopFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopFlow");
            StopFlowResponse stopFlowResponse = (StopFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$stopFlow$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$tagResource$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnregisterConnectorResponse unregisterConnector(UnregisterConnectorRequest unregisterConnectorRequest) throws ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnregisterConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, unregisterConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnregisterConnector");
            UnregisterConnectorResponse unregisterConnectorResponse = (UnregisterConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnregisterConnector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unregisterConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnregisterConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unregisterConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$unregisterConnector$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$untagResource$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConnectorProfileResponse updateConnectorProfile(UpdateConnectorProfileRequest updateConnectorProfileRequest) throws ValidationException, ResourceNotFoundException, ConflictException, ConnectorAuthenticationException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectorProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, updateConnectorProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnectorProfile");
            UpdateConnectorProfileResponse updateConnectorProfileResponse = (UpdateConnectorProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnectorProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConnectorProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConnectorProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConnectorProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$updateConnectorProfile$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConnectorRegistrationResponse updateConnectorRegistration(UpdateConnectorRegistrationRequest updateConnectorRegistrationRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, ConnectorServerException, ConnectorAuthenticationException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectorRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, updateConnectorRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnectorRegistration");
            UpdateConnectorRegistrationResponse updateConnectorRegistrationResponse = (UpdateConnectorRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnectorRegistration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConnectorRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConnectorRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConnectorRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$updateConnectorRegistration$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlowResponse updateFlow(UpdateFlowRequest updateFlowRequest) throws ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, ConnectorAuthenticationException, ConnectorServerException, InternalServerException, AwsServiceException, SdkClientException, AppflowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultAppflowClient.resolveMetricPublishers(this.clientConfiguration, updateFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Appflow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlow");
            UpdateFlowResponse updateFlowResponse = (UpdateFlowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFlowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppflowClient.lambda$updateFlow$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends AppflowRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.38").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AppflowRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "appflow";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppflowException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConnectorAuthenticationException").exceptionBuilderSupplier(ConnectorAuthenticationException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConnectorServerException").exceptionBuilderSupplier(ConnectorServerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    @Override
    public final AppflowServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateFlow$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnectorRegistration$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnectorProfile$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unregisterConnector$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopFlow$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFlow$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerConnector$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlows$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnectors$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnectorEntities$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlowExecutionRecords$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlow$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectors$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectorProfiles$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectorEntity$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnector$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFlow$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnectorProfile$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFlow$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnectorProfile$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

