/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.CustomerProfilesDestinationProperties;
import software.amazon.awssdk.services.appflow.model.EventBridgeDestinationProperties;
import software.amazon.awssdk.services.appflow.model.HoneycodeDestinationProperties;
import software.amazon.awssdk.services.appflow.model.LookoutMetricsDestinationProperties;
import software.amazon.awssdk.services.appflow.model.RedshiftDestinationProperties;
import software.amazon.awssdk.services.appflow.model.S3DestinationProperties;
import software.amazon.awssdk.services.appflow.model.SalesforceDestinationProperties;
import software.amazon.awssdk.services.appflow.model.SnowflakeDestinationProperties;
import software.amazon.awssdk.services.appflow.model.UpsolverDestinationProperties;
import software.amazon.awssdk.services.appflow.model.ZendeskDestinationProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationConnectorProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationConnectorProperties> {
    private static final SdkField<RedshiftDestinationProperties> REDSHIFT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Redshift").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::redshift)).setter(DestinationConnectorProperties.setter(Builder::redshift)).constructor(RedshiftDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redshift").build()}).build();
    private static final SdkField<S3DestinationProperties> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::s3)).setter(DestinationConnectorProperties.setter(Builder::s3)).constructor(S3DestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final SdkField<SalesforceDestinationProperties> SALESFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Salesforce").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::salesforce)).setter(DestinationConnectorProperties.setter(Builder::salesforce)).constructor(SalesforceDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()}).build();
    private static final SdkField<SnowflakeDestinationProperties> SNOWFLAKE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Snowflake").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::snowflake)).setter(DestinationConnectorProperties.setter(Builder::snowflake)).constructor(SnowflakeDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snowflake").build()}).build();
    private static final SdkField<EventBridgeDestinationProperties> EVENT_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventBridge").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::eventBridge)).setter(DestinationConnectorProperties.setter(Builder::eventBridge)).constructor(EventBridgeDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridge").build()}).build();
    private static final SdkField<LookoutMetricsDestinationProperties> LOOKOUT_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LookoutMetrics").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::lookoutMetrics)).setter(DestinationConnectorProperties.setter(Builder::lookoutMetrics)).constructor(LookoutMetricsDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookoutMetrics").build()}).build();
    private static final SdkField<UpsolverDestinationProperties> UPSOLVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Upsolver").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::upsolver)).setter(DestinationConnectorProperties.setter(Builder::upsolver)).constructor(UpsolverDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Upsolver").build()}).build();
    private static final SdkField<HoneycodeDestinationProperties> HONEYCODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Honeycode").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::honeycode)).setter(DestinationConnectorProperties.setter(Builder::honeycode)).constructor(HoneycodeDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Honeycode").build()}).build();
    private static final SdkField<CustomerProfilesDestinationProperties> CUSTOMER_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerProfiles").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::customerProfiles)).setter(DestinationConnectorProperties.setter(Builder::customerProfiles)).constructor(CustomerProfilesDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerProfiles").build()}).build();
    private static final SdkField<ZendeskDestinationProperties> ZENDESK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Zendesk").getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::zendesk)).setter(DestinationConnectorProperties.setter(Builder::zendesk)).constructor(ZendeskDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_FIELD, S3_FIELD, SALESFORCE_FIELD, SNOWFLAKE_FIELD, EVENT_BRIDGE_FIELD, LOOKOUT_METRICS_FIELD, UPSOLVER_FIELD, HONEYCODE_FIELD, CUSTOMER_PROFILES_FIELD, ZENDESK_FIELD));
    private static final long serialVersionUID = 1L;
    private final RedshiftDestinationProperties redshift;
    private final S3DestinationProperties s3;
    private final SalesforceDestinationProperties salesforce;
    private final SnowflakeDestinationProperties snowflake;
    private final EventBridgeDestinationProperties eventBridge;
    private final LookoutMetricsDestinationProperties lookoutMetrics;
    private final UpsolverDestinationProperties upsolver;
    private final HoneycodeDestinationProperties honeycode;
    private final CustomerProfilesDestinationProperties customerProfiles;
    private final ZendeskDestinationProperties zendesk;

    private DestinationConnectorProperties(BuilderImpl builder) {
        this.redshift = builder.redshift;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.snowflake = builder.snowflake;
        this.eventBridge = builder.eventBridge;
        this.lookoutMetrics = builder.lookoutMetrics;
        this.upsolver = builder.upsolver;
        this.honeycode = builder.honeycode;
        this.customerProfiles = builder.customerProfiles;
        this.zendesk = builder.zendesk;
    }

    public final RedshiftDestinationProperties redshift() {
        return this.redshift;
    }

    public final S3DestinationProperties s3() {
        return this.s3;
    }

    public final SalesforceDestinationProperties salesforce() {
        return this.salesforce;
    }

    public final SnowflakeDestinationProperties snowflake() {
        return this.snowflake;
    }

    public final EventBridgeDestinationProperties eventBridge() {
        return this.eventBridge;
    }

    public final LookoutMetricsDestinationProperties lookoutMetrics() {
        return this.lookoutMetrics;
    }

    public final UpsolverDestinationProperties upsolver() {
        return this.upsolver;
    }

    public final HoneycodeDestinationProperties honeycode() {
        return this.honeycode;
    }

    public final CustomerProfilesDestinationProperties customerProfiles() {
        return this.customerProfiles;
    }

    public final ZendeskDestinationProperties zendesk() {
        return this.zendesk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redshift());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowflake());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridge());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookoutMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.upsolver());
        hashCode = 31 * hashCode + Objects.hashCode(this.honeycode());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.zendesk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConnectorProperties)) {
            return false;
        }
        DestinationConnectorProperties other = (DestinationConnectorProperties)obj;
        return Objects.equals(this.redshift(), other.redshift()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.salesforce(), other.salesforce()) && Objects.equals(this.snowflake(), other.snowflake()) && Objects.equals(this.eventBridge(), other.eventBridge()) && Objects.equals(this.lookoutMetrics(), other.lookoutMetrics()) && Objects.equals(this.upsolver(), other.upsolver()) && Objects.equals(this.honeycode(), other.honeycode()) && Objects.equals(this.customerProfiles(), other.customerProfiles()) && Objects.equals(this.zendesk(), other.zendesk());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationConnectorProperties").add("Redshift", (Object)this.redshift()).add("S3", (Object)this.s3()).add("Salesforce", (Object)this.salesforce()).add("Snowflake", (Object)this.snowflake()).add("EventBridge", (Object)this.eventBridge()).add("LookoutMetrics", (Object)this.lookoutMetrics()).add("Upsolver", (Object)this.upsolver()).add("Honeycode", (Object)this.honeycode()).add("CustomerProfiles", (Object)this.customerProfiles()).add("Zendesk", (Object)this.zendesk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Redshift": {
                return Optional.ofNullable(clazz.cast(this.redshift()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "Salesforce": {
                return Optional.ofNullable(clazz.cast(this.salesforce()));
            }
            case "Snowflake": {
                return Optional.ofNullable(clazz.cast(this.snowflake()));
            }
            case "EventBridge": {
                return Optional.ofNullable(clazz.cast(this.eventBridge()));
            }
            case "LookoutMetrics": {
                return Optional.ofNullable(clazz.cast(this.lookoutMetrics()));
            }
            case "Upsolver": {
                return Optional.ofNullable(clazz.cast(this.upsolver()));
            }
            case "Honeycode": {
                return Optional.ofNullable(clazz.cast(this.honeycode()));
            }
            case "CustomerProfiles": {
                return Optional.ofNullable(clazz.cast(this.customerProfiles()));
            }
            case "Zendesk": {
                return Optional.ofNullable(clazz.cast(this.zendesk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConnectorProperties, T> g) {
        return obj -> g.apply((DestinationConnectorProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftDestinationProperties redshift;
        private S3DestinationProperties s3;
        private SalesforceDestinationProperties salesforce;
        private SnowflakeDestinationProperties snowflake;
        private EventBridgeDestinationProperties eventBridge;
        private LookoutMetricsDestinationProperties lookoutMetrics;
        private UpsolverDestinationProperties upsolver;
        private HoneycodeDestinationProperties honeycode;
        private CustomerProfilesDestinationProperties customerProfiles;
        private ZendeskDestinationProperties zendesk;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConnectorProperties model) {
            this.redshift(model.redshift);
            this.s3(model.s3);
            this.salesforce(model.salesforce);
            this.snowflake(model.snowflake);
            this.eventBridge(model.eventBridge);
            this.lookoutMetrics(model.lookoutMetrics);
            this.upsolver(model.upsolver);
            this.honeycode(model.honeycode);
            this.customerProfiles(model.customerProfiles);
            this.zendesk(model.zendesk);
        }

        public final RedshiftDestinationProperties.Builder getRedshift() {
            return this.redshift != null ? this.redshift.toBuilder() : null;
        }

        public final void setRedshift(RedshiftDestinationProperties.BuilderImpl redshift) {
            this.redshift = redshift != null ? redshift.build() : null;
        }

        @Override
        @Transient
        public final Builder redshift(RedshiftDestinationProperties redshift) {
            this.redshift = redshift;
            return this;
        }

        public final S3DestinationProperties.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3DestinationProperties.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        @Transient
        public final Builder s3(S3DestinationProperties s3) {
            this.s3 = s3;
            return this;
        }

        public final SalesforceDestinationProperties.Builder getSalesforce() {
            return this.salesforce != null ? this.salesforce.toBuilder() : null;
        }

        public final void setSalesforce(SalesforceDestinationProperties.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        @Transient
        public final Builder salesforce(SalesforceDestinationProperties salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final SnowflakeDestinationProperties.Builder getSnowflake() {
            return this.snowflake != null ? this.snowflake.toBuilder() : null;
        }

        public final void setSnowflake(SnowflakeDestinationProperties.BuilderImpl snowflake) {
            this.snowflake = snowflake != null ? snowflake.build() : null;
        }

        @Override
        @Transient
        public final Builder snowflake(SnowflakeDestinationProperties snowflake) {
            this.snowflake = snowflake;
            return this;
        }

        public final EventBridgeDestinationProperties.Builder getEventBridge() {
            return this.eventBridge != null ? this.eventBridge.toBuilder() : null;
        }

        public final void setEventBridge(EventBridgeDestinationProperties.BuilderImpl eventBridge) {
            this.eventBridge = eventBridge != null ? eventBridge.build() : null;
        }

        @Override
        @Transient
        public final Builder eventBridge(EventBridgeDestinationProperties eventBridge) {
            this.eventBridge = eventBridge;
            return this;
        }

        public final LookoutMetricsDestinationProperties.Builder getLookoutMetrics() {
            return this.lookoutMetrics != null ? this.lookoutMetrics.toBuilder() : null;
        }

        public final void setLookoutMetrics(LookoutMetricsDestinationProperties.BuilderImpl lookoutMetrics) {
            this.lookoutMetrics = lookoutMetrics != null ? lookoutMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder lookoutMetrics(LookoutMetricsDestinationProperties lookoutMetrics) {
            this.lookoutMetrics = lookoutMetrics;
            return this;
        }

        public final UpsolverDestinationProperties.Builder getUpsolver() {
            return this.upsolver != null ? this.upsolver.toBuilder() : null;
        }

        public final void setUpsolver(UpsolverDestinationProperties.BuilderImpl upsolver) {
            this.upsolver = upsolver != null ? upsolver.build() : null;
        }

        @Override
        @Transient
        public final Builder upsolver(UpsolverDestinationProperties upsolver) {
            this.upsolver = upsolver;
            return this;
        }

        public final HoneycodeDestinationProperties.Builder getHoneycode() {
            return this.honeycode != null ? this.honeycode.toBuilder() : null;
        }

        public final void setHoneycode(HoneycodeDestinationProperties.BuilderImpl honeycode) {
            this.honeycode = honeycode != null ? honeycode.build() : null;
        }

        @Override
        @Transient
        public final Builder honeycode(HoneycodeDestinationProperties honeycode) {
            this.honeycode = honeycode;
            return this;
        }

        public final CustomerProfilesDestinationProperties.Builder getCustomerProfiles() {
            return this.customerProfiles != null ? this.customerProfiles.toBuilder() : null;
        }

        public final void setCustomerProfiles(CustomerProfilesDestinationProperties.BuilderImpl customerProfiles) {
            this.customerProfiles = customerProfiles != null ? customerProfiles.build() : null;
        }

        @Override
        @Transient
        public final Builder customerProfiles(CustomerProfilesDestinationProperties customerProfiles) {
            this.customerProfiles = customerProfiles;
            return this;
        }

        public final ZendeskDestinationProperties.Builder getZendesk() {
            return this.zendesk != null ? this.zendesk.toBuilder() : null;
        }

        public final void setZendesk(ZendeskDestinationProperties.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        @Transient
        public final Builder zendesk(ZendeskDestinationProperties zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        public DestinationConnectorProperties build() {
            return new DestinationConnectorProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationConnectorProperties> {
        public Builder redshift(RedshiftDestinationProperties var1);

        default public Builder redshift(Consumer<RedshiftDestinationProperties.Builder> redshift) {
            return this.redshift((RedshiftDestinationProperties)((RedshiftDestinationProperties.Builder)RedshiftDestinationProperties.builder().applyMutation(redshift)).build());
        }

        public Builder s3(S3DestinationProperties var1);

        default public Builder s3(Consumer<S3DestinationProperties.Builder> s3) {
            return this.s3((S3DestinationProperties)((S3DestinationProperties.Builder)S3DestinationProperties.builder().applyMutation(s3)).build());
        }

        public Builder salesforce(SalesforceDestinationProperties var1);

        default public Builder salesforce(Consumer<SalesforceDestinationProperties.Builder> salesforce) {
            return this.salesforce((SalesforceDestinationProperties)((SalesforceDestinationProperties.Builder)SalesforceDestinationProperties.builder().applyMutation(salesforce)).build());
        }

        public Builder snowflake(SnowflakeDestinationProperties var1);

        default public Builder snowflake(Consumer<SnowflakeDestinationProperties.Builder> snowflake) {
            return this.snowflake((SnowflakeDestinationProperties)((SnowflakeDestinationProperties.Builder)SnowflakeDestinationProperties.builder().applyMutation(snowflake)).build());
        }

        public Builder eventBridge(EventBridgeDestinationProperties var1);

        default public Builder eventBridge(Consumer<EventBridgeDestinationProperties.Builder> eventBridge) {
            return this.eventBridge((EventBridgeDestinationProperties)((EventBridgeDestinationProperties.Builder)EventBridgeDestinationProperties.builder().applyMutation(eventBridge)).build());
        }

        public Builder lookoutMetrics(LookoutMetricsDestinationProperties var1);

        default public Builder lookoutMetrics(Consumer<LookoutMetricsDestinationProperties.Builder> lookoutMetrics) {
            return this.lookoutMetrics((LookoutMetricsDestinationProperties)((LookoutMetricsDestinationProperties.Builder)LookoutMetricsDestinationProperties.builder().applyMutation(lookoutMetrics)).build());
        }

        public Builder upsolver(UpsolverDestinationProperties var1);

        default public Builder upsolver(Consumer<UpsolverDestinationProperties.Builder> upsolver) {
            return this.upsolver((UpsolverDestinationProperties)((UpsolverDestinationProperties.Builder)UpsolverDestinationProperties.builder().applyMutation(upsolver)).build());
        }

        public Builder honeycode(HoneycodeDestinationProperties var1);

        default public Builder honeycode(Consumer<HoneycodeDestinationProperties.Builder> honeycode) {
            return this.honeycode((HoneycodeDestinationProperties)((HoneycodeDestinationProperties.Builder)HoneycodeDestinationProperties.builder().applyMutation(honeycode)).build());
        }

        public Builder customerProfiles(CustomerProfilesDestinationProperties var1);

        default public Builder customerProfiles(Consumer<CustomerProfilesDestinationProperties.Builder> customerProfiles) {
            return this.customerProfiles((CustomerProfilesDestinationProperties)((CustomerProfilesDestinationProperties.Builder)CustomerProfilesDestinationProperties.builder().applyMutation(customerProfiles)).build());
        }

        public Builder zendesk(ZendeskDestinationProperties var1);

        default public Builder zendesk(Consumer<ZendeskDestinationProperties.Builder> zendesk) {
            return this.zendesk((ZendeskDestinationProperties)((ZendeskDestinationProperties.Builder)ZendeskDestinationProperties.builder().applyMutation(zendesk)).build());
        }
    }
}

