/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Range
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Range> {
    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("maximum").getter(Range.getter(Range::maximum)).setter(Range.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximum").build()}).build();
    private static final SdkField<Double> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("minimum").getter(Range.getter(Range::minimum)).setter(Range.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_FIELD, MINIMUM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double maximum;
    private final Double minimum;

    private Range(BuilderImpl builder) {
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
    }

    public final Double maximum() {
        return this.maximum;
    }

    public final Double minimum() {
        return this.minimum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.minimum(), other.minimum());
    }

    public final String toString() {
        return ToString.builder((String)"Range").add("Maximum", (Object)this.maximum()).add("Minimum", (Object)this.minimum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Range, T> g) {
        return obj -> g.apply((Range)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double maximum;
        private Double minimum;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            this.maximum(model.maximum);
            this.minimum(model.minimum);
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public Range build() {
            return new Range(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Range> {
        public Builder maximum(Double var1);

        public Builder minimum(Double var1);
    }
}

