/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FlowStatus {
    ACTIVE("Active"),
    DEPRECATED("Deprecated"),
    DELETED("Deleted"),
    DRAFT("Draft"),
    ERRORED("Errored"),
    SUSPENDED("Suspended"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlowStatus> VALUE_MAP;
    private final String value;

    private FlowStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlowStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlowStatus> knownValues() {
        EnumSet<FlowStatus> knownValues = EnumSet.allOf(FlowStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FlowStatus.class, FlowStatus::toString);
    }
}

