/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorType {
    SALESFORCE("Salesforce"),
    SINGULAR("Singular"),
    SLACK("Slack"),
    REDSHIFT("Redshift"),
    S3("S3"),
    MARKETO("Marketo"),
    GOOGLEANALYTICS("Googleanalytics"),
    ZENDESK("Zendesk"),
    SERVICENOW("Servicenow"),
    DATADOG("Datadog"),
    TRENDMICRO("Trendmicro"),
    SNOWFLAKE("Snowflake"),
    DYNATRACE("Dynatrace"),
    INFORNEXUS("Infornexus"),
    AMPLITUDE("Amplitude"),
    VEEVA("Veeva"),
    EVENT_BRIDGE("EventBridge"),
    LOOKOUT_METRICS("LookoutMetrics"),
    UPSOLVER("Upsolver"),
    HONEYCODE("Honeycode"),
    CUSTOMER_PROFILES("CustomerProfiles"),
    SAPO_DATA("SAPOData"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorType> VALUE_MAP;
    private final String value;

    private ConnectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorType> knownValues() {
        EnumSet<ConnectorType> knownValues = EnumSet.allOf(ConnectorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorType.class, ConnectorType::toString);
    }
}

